/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.jsp.rules;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.jsp.ast.ASTAttribute;
import net.sourceforge.pmd.jsp.ast.ASTElement;
import net.sourceforge.pmd.jsp.rules.AbstractJspRule;

public class NoInlineStyleInformation
extends AbstractJspRule {
    private static final List STYLE_ELEMENT_NAMES = Arrays.asList("B", "I", "FONT", "BASEFONT", "U", "CENTER");
    private static final List ELEMENT_NAMES_THAT_CAN_HAVE_STYLE_ATTRIBUTES = Arrays.asList("P", "TABLE", "THEAD", "TBODY", "TFOOT", "TR", "TD", "COL", "COLGROUP");
    private static final List STYLE_ATTRIBUTES = Arrays.asList("STYLE", "FONT", "SIZE", "COLOR", "FACE", "ALIGN", "VALIGN", "BGCOLOR");

    public Object visit(ASTAttribute node, Object data) {
        if (this.isStyleAttribute(node)) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTElement node, Object data) {
        if (this.isStyleElement(node)) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    private boolean isStyleElement(ASTElement elementNode) {
        return STYLE_ELEMENT_NAMES.contains(elementNode.getName().toUpperCase());
    }

    private boolean isStyleAttribute(ASTAttribute attributeNode) {
        ASTElement parent;
        return STYLE_ATTRIBUTES.contains(attributeNode.getName().toUpperCase()) && attributeNode.jjtGetParent() instanceof ASTElement && ELEMENT_NAMES_THAT_CAN_HAVE_STYLE_ATTRIBUTES.contains((parent = (ASTElement)attributeNode.jjtGetParent()).getName().toUpperCase());
    }
}

