/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;

public class DataFlowNode
implements IDataFlowNode {
    private SimpleNode node;
    private Map typeMap = new HashMap();
    protected List parents = new ArrayList();
    protected List children = new ArrayList();
    protected BitSet type = new BitSet();
    protected List variableAccess = new ArrayList();
    protected LinkedList dataFlow;
    protected int line;

    protected DataFlowNode() {
    }

    public DataFlowNode(SimpleNode node, LinkedList dataFlow) {
        this.dataFlow = dataFlow;
        this.node = node;
        node.setDataFlowNode(this);
        this.line = node.getBeginLine();
        if (!this.dataFlow.isEmpty()) {
            DataFlowNode parent = (DataFlowNode)this.dataFlow.getLast();
            parent.addPathToChild(this);
        }
        this.dataFlow.addLast(this);
    }

    public void addPathToChild(IDataFlowNode child) {
        DataFlowNode thisChild = (DataFlowNode)child;
        if (!this.children.contains(thisChild) || this.equals(thisChild)) {
            this.children.add(thisChild);
            thisChild.parents.add(this);
        }
    }

    public boolean removePathToChild(IDataFlowNode child) {
        DataFlowNode thisChild = (DataFlowNode)child;
        thisChild.parents.remove(this);
        return this.children.remove(thisChild);
    }

    public void reverseParentPathsTo(IDataFlowNode destination) {
        while (!this.parents.isEmpty()) {
            DataFlowNode parent = (DataFlowNode)this.parents.get(0);
            parent.removePathToChild(this);
            parent.addPathToChild(destination);
        }
    }

    public int getLine() {
        return this.line;
    }

    public void setType(int type) {
        this.type.set(type);
    }

    public boolean isType(int intype) {
        try {
            return this.type.get(intype);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
    }

    public SimpleNode getSimpleNode() {
        return this.node;
    }

    public List getChildren() {
        return this.children;
    }

    public List getParents() {
        return this.parents;
    }

    public List getFlow() {
        return this.dataFlow;
    }

    public int getIndex() {
        return this.dataFlow.indexOf(this);
    }

    public void setVariableAccess(List variableAccess) {
        if (this.variableAccess.isEmpty()) {
            this.variableAccess = variableAccess;
        } else {
            this.variableAccess.addAll(variableAccess);
        }
    }

    public List getVariableAccess() {
        return this.variableAccess;
    }

    public String toString() {
        String res = "DataFlowNode: line " + this.getLine() + ", ";
        if (this.node instanceof ASTMethodDeclaration || this.node instanceof ASTConstructorDeclaration) {
            res = res + (this.node instanceof ASTMethodDeclaration ? "(method)" : "(constructor)");
        } else {
            String tmp = this.type.toString();
            String newTmp = "";
            for (int i = 0; i < tmp.length(); ++i) {
                if (tmp.charAt(i) == '{' || tmp.charAt(i) == '}' || tmp.charAt(i) == ' ') continue;
                newTmp = newTmp + tmp.charAt(i);
            }
            StringTokenizer st = new StringTokenizer(newTmp, ",");
            while (st.hasMoreTokens()) {
                int newTmpInt = Integer.parseInt(st.nextToken());
                res = res + "(" + this.stringFromType(newTmpInt) + ")";
            }
            res = res + ", " + this.node.getClass().getName().substring(this.node.getClass().getName().lastIndexOf(46) + 1);
            res = res + (this.node.getImage() == null ? "" : "(" + this.node.getImage() + ")");
        }
        return res;
    }

    private String stringFromType(int intype) {
        if (this.typeMap.isEmpty()) {
            this.typeMap.put(new Integer(1), "IF_EXPR");
            this.typeMap.put(new Integer(2), "IF_LAST_STATEMENT");
            this.typeMap.put(new Integer(3), "IF_LAST_STATEMENT_WITHOUT_ELSE");
            this.typeMap.put(new Integer(4), "ELSE_LAST_STATEMENT");
            this.typeMap.put(new Integer(11), "WHILE_LAST_STATEMENT");
            this.typeMap.put(new Integer(10), "WHILE_EXPR");
            this.typeMap.put(new Integer(20), "SWITCH_START");
            this.typeMap.put(new Integer(21), "CASE_LAST_STATEMENT");
            this.typeMap.put(new Integer(22), "SWITCH_LAST_DEFAULT_STATEMENT");
            this.typeMap.put(new Integer(23), "SWITCH_END");
            this.typeMap.put(new Integer(30), "FOR_INIT");
            this.typeMap.put(new Integer(31), "FOR_EXPR");
            this.typeMap.put(new Integer(32), "FOR_UPDATE");
            this.typeMap.put(new Integer(33), "FOR_BEFORE_FIRST_STATEMENT");
            this.typeMap.put(new Integer(34), "FOR_END");
            this.typeMap.put(new Integer(40), "DO_BEFORE_FIRST_STATEMENT");
            this.typeMap.put(new Integer(41), "DO_EXPR");
            this.typeMap.put(new Integer(50), "RETURN_STATEMENT");
            this.typeMap.put(new Integer(51), "BREAK_STATEMENT");
            this.typeMap.put(new Integer(52), "CONTINUE_STATEMENT");
        }
        if (!this.typeMap.containsKey(new Integer(intype))) {
            throw new RuntimeException("Couldn't find type id " + intype);
        }
        return (String)this.typeMap.get(new Integer(intype));
    }
}

