/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.GridBagHelper;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;

public class GUI
implements CPDListener {
    private JTextField rootDirectoryField = new JTextField(System.getProperty("user.home"));
    private JTextField minimumLengthField = new JTextField("75");
    private JTextField timeField = new JTextField(6);
    private JLabel phaseLabel = new JLabel();
    private JProgressBar tokenizingFilesBar = new JProgressBar();
    private JTextArea resultsTextArea = new JTextArea();
    private JCheckBox recurseCheckbox = new JCheckBox("", true);
    private JCheckBox ignoreLiteralsCheckbox = new JCheckBox("", false);
    private JComboBox languageBox = new JComboBox();
    private JTextField extensionField = new JTextField(".java");
    private JFileChooser fcSave = new JFileChooser();
    private JFrame frame;
    private List matches = new ArrayList();

    public GUI() {
        this.frame = new JFrame("PMD Duplicate Code Detector");
        this.timeField.setEditable(false);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        JMenuItem saveItem = new JMenuItem("Save Text");
        saveItem.setMnemonic('s');
        saveItem.addActionListener(new SaveListener());
        fileMenu.add(saveItem);
        saveItem.setActionCommand(".txt");
        saveItem = new JMenuItem("Save XML");
        saveItem.addActionListener(new SaveListener());
        fileMenu.add(saveItem);
        saveItem.setActionCommand(".xml");
        saveItem = new JMenuItem("Save CSV");
        saveItem.setActionCommand(".csv");
        saveItem.addActionListener(new SaveListener());
        fileMenu.add(saveItem);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic('x');
        exitItem.addActionListener(new CancelListener());
        fileMenu.add(exitItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        this.frame.setJMenuBar(menuBar);
        JButton browseButton = new JButton("Browse");
        browseButton.setMnemonic('b');
        browseButton.addActionListener(new BrowseListener());
        JButton goButton = new JButton("Go");
        goButton.setMnemonic('g');
        goButton.addActionListener(new GoListener());
        JButton cxButton = new JButton("Cancel");
        cxButton.addActionListener(new CancelListener());
        JPanel settingsPanel = this.makeSettingsPanel(browseButton, goButton, cxButton);
        JPanel progressPanel = this.makeProgressPanel();
        JPanel resultsPanel = this.makeResultsPanel();
        this.frame.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)settingsPanel, "North");
        topPanel.add((Component)progressPanel, "Center");
        this.frame.getContentPane().add((Component)topPanel, "North");
        this.frame.getContentPane().add((Component)resultsPanel, "Center");
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.show();
    }

    private JPanel makeSettingsPanel(JButton browseButton, JButton goButton, JButton cxButton) {
        JPanel settingsPanel = new JPanel();
        GridBagHelper helper = new GridBagHelper(settingsPanel, new double[]{0.2, 0.7, 0.1, 0.1});
        helper.addLabel("Root source directory:");
        helper.add(this.rootDirectoryField);
        helper.add(browseButton, 2);
        helper.nextRow();
        helper.addLabel("Report duplicate chunks larger than:");
        this.minimumLengthField.setColumns(4);
        helper.add(this.minimumLengthField);
        helper.addLabel("Language:");
        this.languageBox.addItem("Java");
        this.languageBox.addItem("C++");
        this.languageBox.addItem("PHP");
        this.languageBox.addItem("Ruby");
        this.languageBox.addItem("by extension...");
        this.languageBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUI.this.ignoreLiteralsCheckbox.setEnabled(GUI.this.languageBox.getSelectedItem().equals("Java"));
                GUI.this.extensionField.setEnabled(GUI.this.languageBox.getSelectedItem().equals("by extension..."));
            }
        });
        helper.add(this.languageBox);
        helper.nextRow();
        helper.addLabel("Also scan subdirectories?");
        helper.add(this.recurseCheckbox);
        helper.addLabel("Extension:");
        helper.add(this.extensionField);
        this.extensionField.setEnabled(false);
        helper.nextRow();
        helper.addLabel("Ignore literals and identifiers?");
        helper.add(this.ignoreLiteralsCheckbox);
        helper.add(goButton);
        helper.add(cxButton);
        helper.nextRow();
        settingsPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        return settingsPanel;
    }

    private JPanel makeProgressPanel() {
        JPanel progressPanel = new JPanel();
        double[] weights = new double[]{0.0, 0.8, 0.4, 0.2};
        GridBagHelper helper = new GridBagHelper(progressPanel, weights);
        helper.addLabel("Tokenizing files:");
        helper.add(this.tokenizingFilesBar, 3);
        helper.nextRow();
        helper.addLabel("Phase:");
        helper.add(this.phaseLabel);
        helper.addLabel("Time elapsed:");
        helper.add(this.timeField);
        helper.nextRow();
        progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        return progressPanel;
    }

    private JPanel makeResultsPanel() {
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BorderLayout());
        JScrollPane areaScrollPane = new JScrollPane(this.resultsTextArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(600, 300));
        resultsPanel.add((Component)areaScrollPane, "Center");
        resultsPanel.setBorder(BorderFactory.createTitledBorder("Results"));
        return resultsPanel;
    }

    private void go() {
        try {
            if (!new File(this.rootDirectoryField.getText()).exists()) {
                JOptionPane.showMessageDialog(this.frame, "Can't read from that root source directory", "Error", 0);
                return;
            }
            Language language = null;
            LanguageFactory lf = new LanguageFactory();
            Properties p = new Properties();
            p.setProperty("ignore_literals", String.valueOf(this.ignoreLiteralsCheckbox.isSelected()));
            p.setProperty("extension", this.extensionField.getText());
            if (this.languageBox.getSelectedItem().equals("Java")) {
                language = lf.createLanguage("java", p);
            } else if (this.languageBox.getSelectedItem().equals("C++")) {
                language = lf.createLanguage("cpp");
            } else if (this.languageBox.getSelectedItem().equals("Ruby")) {
                language = lf.createLanguage("ruby");
            } else if (this.languageBox.getSelectedItem().equals("by extension...")) {
                language = lf.createLanguage("by_extension", p);
            } else if (this.languageBox.getSelectedItem().equals("PHP")) {
                language = lf.createLanguage("php");
            }
            CPD cpd = new CPD(Integer.parseInt(this.minimumLengthField.getText()), language);
            cpd.setCpdListener(this);
            this.tokenizingFilesBar.setMinimum(0);
            this.phaseLabel.setText("");
            if (this.rootDirectoryField.getText().endsWith(".class") || this.rootDirectoryField.getText().endsWith(".php") || this.rootDirectoryField.getText().endsWith(".rb") || this.rootDirectoryField.getText().endsWith(".java") || this.rootDirectoryField.getText().endsWith(".cpp") || this.rootDirectoryField.getText().endsWith(".c")) {
                cpd.add(new File(this.rootDirectoryField.getText()));
            } else if (this.recurseCheckbox.isSelected()) {
                cpd.addRecursively(this.rootDirectoryField.getText());
            } else {
                cpd.addAllInDirectory(this.rootDirectoryField.getText());
            }
            final long start = System.currentTimeMillis();
            Timer t = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    long now = System.currentTimeMillis();
                    long elapsedMillis = now - start;
                    long elapsedSeconds = elapsedMillis / 1000L;
                    long minutes = (long)Math.floor(elapsedSeconds / 60L);
                    long seconds = elapsedSeconds - minutes * 60L;
                    GUI.this.timeField.setText("" + this.munge(String.valueOf(minutes)) + ":" + this.munge(String.valueOf(seconds)));
                }

                private String munge(String in) {
                    if (in.length() < 2) {
                        in = "0" + in;
                    }
                    return in;
                }
            });
            t.start();
            cpd.go();
            t.stop();
            this.matches = new ArrayList();
            Iterator i = cpd.getMatches();
            while (i.hasNext()) {
                Match m = (Match)i.next();
                this.matches.add(m);
            }
            String report = new SimpleRenderer().render(cpd.getMatches());
            if (report.length() == 0) {
                JOptionPane.showMessageDialog(this.frame, "Done; couldn't find any duplicates longer than " + this.minimumLengthField.getText() + " tokens");
            } else {
                this.resultsTextArea.setText(report);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "Halted due to " + t.getClass().getName() + "; " + t.getMessage());
        }
    }

    public void phaseUpdate(int phase) {
        this.phaseLabel.setText(this.getPhaseText(phase));
    }

    public String getPhaseText(int phase) {
        switch (phase) {
            case 0: {
                return "Initializing";
            }
            case 1: {
                return "Hashing";
            }
            case 2: {
                return "Matching";
            }
            case 3: {
                return "Grouping";
            }
            case 4: {
                return "Done";
            }
        }
        return "Unknown";
    }

    public void addedFile(int fileCount, File file) {
        this.tokenizingFilesBar.setMaximum(fileCount);
        this.tokenizingFilesBar.setValue(this.tokenizingFilesBar.getValue() + 1);
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        new GUI();
    }

    private class BrowseListener
    implements ActionListener {
        private BrowseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(GUI.this.rootDirectoryField.getText());
            fc.setFileSelectionMode(2);
            fc.showDialog(GUI.this.frame, "Select");
            if (fc.getSelectedFile() != null) {
                GUI.this.rootDirectoryField.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            int ret = GUI.this.fcSave.showSaveDialog(GUI.this.frame);
            File f = GUI.this.fcSave.getSelectedFile();
            if (f == null || ret != 0) {
                return;
            }
            if (!f.canWrite()) {
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(new FileOutputStream(f));
                    if (evt.getActionCommand().equals(".txt")) {
                        pw.write(new SimpleRenderer().render(GUI.this.matches.iterator()));
                    } else if (evt.getActionCommand().equals(".xml")) {
                        pw.write(new XMLRenderer().render(GUI.this.matches.iterator()));
                    } else if (evt.getActionCommand().equals(".csv")) {
                        pw.write(new CSVRenderer().render(GUI.this.matches.iterator()));
                    }
                    pw.flush();
                    JOptionPane.showMessageDialog(GUI.this.frame, "File saved");
                }
                catch (IOException e) {
                    this.error("Couldn't save file" + f.getAbsolutePath(), e);
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
            } else {
                this.error("Could not write to file " + f.getAbsolutePath(), null);
            }
        }

        private void error(String message, Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            JOptionPane.showMessageDialog(GUI.this.frame, message);
        }
    }

    private class GoListener
    implements ActionListener {
        private GoListener() {
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                public void run() {
                    GUI.this.tokenizingFilesBar.setValue(0);
                    GUI.this.tokenizingFilesBar.setString("");
                    GUI.this.resultsTextArea.setText("");
                    GUI.this.phaseLabel.setText("");
                    GUI.this.timeField.setText("");
                    GUI.this.go();
                }
            }).start();
        }
    }

    private static class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

