/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.FileReporter;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.ReportException;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class CPDTask
extends Task {
    private static final String TEXT_FORMAT = "text";
    private static final String XML_FORMAT = "xml";
    private static final String CSV_FORMAT = "csv";
    private String format = "text";
    private String language = "java";
    private int minimumTokenCount;
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;
    private File outputFile;
    private List filesets = new ArrayList();

    public void execute() throws BuildException {
        try {
            this.validateFields();
            this.log("Tokenizing files", 2);
            CPD cpd = new CPD(this.minimumTokenCount, this.createLanguage());
            this.tokenizeFiles(cpd);
            this.log("Starting to analyze code", 2);
            long timeTaken = this.analyzeCode(cpd);
            this.log("Done analyzing code; that took " + timeTaken + " milliseconds");
            this.log("Generating report", 2);
            this.report(cpd);
        }
        catch (IOException ioe) {
            this.log(ioe.toString(), 0);
            throw new BuildException("IOException during task execution", (Throwable)ioe);
        }
        catch (ReportException re) {
            re.printStackTrace();
            this.log(re.toString(), 0);
            throw new BuildException("ReportException during task execution", (Throwable)re);
        }
    }

    private Language createLanguage() {
        Properties p = new Properties();
        if (this.ignoreLiterals) {
            p.setProperty("ignore_literals", "true");
        }
        if (this.ignoreIdentifiers) {
            p.setProperty("ignore_identifiers", "true");
        }
        return new LanguageFactory().createLanguage(this.language, p);
    }

    private void report(CPD cpd) throws ReportException {
        if (!cpd.getMatches().hasNext()) {
            this.log("No duplicates over " + this.minimumTokenCount + " tokens found", 2);
        }
        Renderer renderer = this.createRenderer();
        if (this.outputFile.isAbsolute()) {
            new FileReporter(this.outputFile).report(renderer.render(cpd.getMatches()));
        } else {
            new FileReporter(new File(this.getProject().getBaseDir(), this.outputFile.toString()));
        }
    }

    private void tokenizeFiles(CPD cpd) throws IOException {
        Iterator iterator = this.filesets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] includedFiles = directoryScanner.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                File file = new File(directoryScanner.getBasedir() + System.getProperty("file.separator") + includedFiles[i]);
                this.log("Tokenizing " + file.getAbsolutePath(), 3);
                cpd.add(file);
            }
        }
    }

    private long analyzeCode(CPD cpd) {
        long start = System.currentTimeMillis();
        cpd.go();
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    private Renderer createRenderer() {
        if (this.format.equals(TEXT_FORMAT)) {
            return new SimpleRenderer();
        }
        if (this.format.equals(CSV_FORMAT)) {
            return new CSVRenderer();
        }
        return new XMLRenderer();
    }

    private void validateFields() throws BuildException {
        if (this.minimumTokenCount == 0) {
            throw new BuildException("minimumTokenCount is required and must be greater than zero");
        }
        if (this.outputFile == null) {
            throw new BuildException("outputFile is a required attribute");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("Must include at least one FileSet");
        }
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setMinimumTokenCount(int minimumTokenCount) {
        this.minimumTokenCount = minimumTokenCount;
    }

    public void setIgnoreLiterals(boolean value) {
        this.ignoreLiterals = value;
    }

    public void setIgnoreIdentifiers(boolean value) {
        this.ignoreIdentifiers = value;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setFormat(FormatAttribute formatAttribute) {
        this.format = formatAttribute.getValue();
    }

    public void setLanguage(LanguageAttribute languageAttribute) {
        this.language = languageAttribute.getValue();
    }

    public static class LanguageAttribute
    extends EnumeratedAttribute {
        private String[] LANGUAGES = new String[]{"java", "cpp", "c", "php", "ruby"};

        public String[] getValues() {
            return this.LANGUAGES;
        }
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private static final String[] FORMATS = new String[]{"xml", "text", "csv"};

        public String[] getValues() {
            return FORMATS;
        }
    }
}

