/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.FileFinder;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;

public class CPD {
    private Map source = new HashMap();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private int minimumTileSize;
    private MatchAlgorithm matchAlgorithm;
    private Language language;
    private boolean skipDuplicates;
    private Set current = new HashSet();

    public CPD(int minimumTileSize, Language language) {
        this.minimumTileSize = minimumTileSize;
        this.language = language;
    }

    public void skipDuplicates() {
        this.skipDuplicates = true;
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void go() {
        TokenEntry.clearImages();
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.minimumTileSize, this.listener);
        this.matchAlgorithm.findMatches();
    }

    public Iterator getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void add(File file) throws IOException {
        this.add(1, file);
    }

    public void addAllInDirectory(String dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(String dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List files) throws IOException {
        Iterator i = files.iterator();
        while (i.hasNext()) {
            this.add(files.size(), (File)i.next());
        }
    }

    private void addDirectory(String dir, boolean recurse) throws IOException {
        if (!new File(dir).exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.language.getFileFilter(), recurse));
    }

    private void add(int fileCount, File file) throws IOException {
        if (this.skipDuplicates) {
            String signature = file.getName() + "_" + String.valueOf(file.length());
            if (this.current.contains(signature)) {
                System.out.println("Skipping " + file.getAbsolutePath() + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return;
            }
            this.current.add(signature);
        }
        this.listener.addedFile(fileCount, file);
        SourceCode sourceCode = new SourceCode(new SourceCode.FileCodeLoader(file));
        this.language.getTokenizer().tokenize(sourceCode, this.tokens);
        this.source.put(sourceCode.getFileName(), sourceCode);
    }

    public static Renderer getRendererFromString(String name) {
        if (name.equals("text") || name.equals("")) {
            return new SimpleRenderer();
        }
        try {
            return (Renderer)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            System.out.println("Can't find class '" + name + "' so defaulting to SimpleRenderer.");
            return new SimpleRenderer();
        }
    }

    private static boolean findBooleanSwitch(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private static String findRequiredStringValue(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        System.out.println("No " + name + " value passed in");
        CPD.usage();
        throw new RuntimeException();
    }

    private static String findOptionalStringValue(String[] args, String name, String defaultValue) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CPD.usage();
        }
        try {
            boolean skipDuplicateFiles = CPD.findBooleanSwitch(args, "--skip-duplicate-files");
            String pathToFiles = CPD.findRequiredStringValue(args, "--files");
            String languageString = CPD.findOptionalStringValue(args, "--language", "java");
            String formatString = CPD.findOptionalStringValue(args, "--format", "text");
            int minimumTokens = Integer.parseInt(CPD.findRequiredStringValue(args, "--minimum-tokens"));
            LanguageFactory f = new LanguageFactory();
            Language language = f.createLanguage(languageString);
            Renderer renderer = CPD.getRendererFromString(formatString);
            CPD cpd = new CPD(minimumTokens, language);
            if (skipDuplicateFiles) {
                cpd.skipDuplicates();
            }
            cpd.addRecursively(pathToFiles);
            cpd.go();
            System.out.println(renderer.render(cpd.getMatches()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens xxx --files xxx [--language xxx] [--format (xml|text|csv)] [--skip-duplicate-files] ");
        System.out.println("i.e: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files c:\\jdk14\\src\\java ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files /path/to/c/code --language c ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files /path/to/java/code --format xml");
    }
}

