/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.ast.xpath.AttributeAxisIterator;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.ParseException;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.LocalScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.Scope;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.xpath.Initializer;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.designer.CodeEditorTextPane;
import net.sourceforge.pmd.util.designer.CreateXMLRulePanel;
import net.sourceforge.pmd.util.designer.DFAGraphRule;
import net.sourceforge.pmd.util.designer.DFAPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Designer
implements ClipboardOwner {
    private static final int DEFAULT_LANGUAGE_VERSION_SELECTION_INDEX = Arrays.asList(Designer.getSupportedLanguageVersions()).indexOf((Object)Language.JAVA.getDefaultVersion());
    private boolean exitOnClose = true;
    private final CodeEditorTextPane codeEditorPane = new CodeEditorTextPane();
    private final TreeWidget astTreeWidget = new TreeWidget(new Object[0]);
    private DefaultListModel xpathResults = new DefaultListModel();
    private final JList xpathResultList = new JList(this.xpathResults);
    private final JTextArea xpathQueryArea = new JTextArea(15, 30);
    private final ButtonGroup xpathVersionButtonGroup = new ButtonGroup();
    private final TreeWidget symbolTableTreeWidget = new TreeWidget(new Object[0]);
    private final JFrame frame = new JFrame("PMD Rule Designer (v " + PMD.VERSION + ')');
    private final DFAPanel dfaPanel = new DFAPanel();
    private final JRadioButtonMenuItem[] languageVersionMenuItems = new JRadioButtonMenuItem[Designer.getSupportedLanguageVersions().length];
    private static final String SETTINGS_FILE_NAME = System.getProperty("user.home") + System.getProperty("file.separator") + ".pmd_designer.xml";

    private Node getCompilationUnit() {
        LanguageVersionHandler languageVersionHandler = this.getLanguageVersionHandler();
        Parser parser = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions());
        Node node = parser.parse(null, new StringReader(this.codeEditorPane.getText()));
        languageVersionHandler.getSymbolFacade().start(node);
        languageVersionHandler.getTypeResolutionFacade(null).start(node);
        return node;
    }

    private static LanguageVersion[] getSupportedLanguageVersions() {
        ArrayList<LanguageVersion> languageVersions = new ArrayList<LanguageVersion>();
        for (LanguageVersion languageVersion : LanguageVersion.values()) {
            Parser parser;
            LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
            if (languageVersionHandler == null || (parser = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions())) == null || !parser.canParse()) continue;
            languageVersions.add(languageVersion);
        }
        return languageVersions.toArray(new LanguageVersion[languageVersions.size()]);
    }

    private LanguageVersion getLanguageVersion() {
        return Designer.getSupportedLanguageVersions()[this.selectedLanguageVersionIndex()];
    }

    private void setLanguageVersion(LanguageVersion languageVersion) {
        if (languageVersion != null) {
            LanguageVersion[] versions = Designer.getSupportedLanguageVersions();
            for (int i = 0; i < versions.length; ++i) {
                LanguageVersion version = versions[i];
                if (!languageVersion.equals((Object)version)) continue;
                this.languageVersionMenuItems[i].setSelected(true);
                break;
            }
        }
    }

    private int selectedLanguageVersionIndex() {
        for (int i = 0; i < this.languageVersionMenuItems.length; ++i) {
            if (!this.languageVersionMenuItems[i].isSelected()) continue;
            return i;
        }
        throw new RuntimeException("Initial default language version not specified");
    }

    private LanguageVersionHandler getLanguageVersionHandler() {
        LanguageVersion languageVersion = this.getLanguageVersion();
        return languageVersion.getLanguageVersionHandler();
    }

    private TreeCellRenderer createNoImageTreeCellRenderer() {
        DefaultTreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer();
        treeCellRenderer.setLeafIcon(null);
        treeCellRenderer.setOpenIcon(null);
        treeCellRenderer.setClosedIcon(null);
        return treeCellRenderer;
    }

    private void loadASTTreeData(TreeNode rootNode) {
        this.astTreeWidget.setModel(new DefaultTreeModel(rootNode));
        this.astTreeWidget.setRootVisible(true);
        this.astTreeWidget.expandAll(true);
    }

    private void loadSymbolTableTreeData(TreeNode rootNode) {
        if (rootNode != null) {
            this.symbolTableTreeWidget.setModel(new DefaultTreeModel(rootNode));
            this.symbolTableTreeWidget.expandAll(true);
        } else {
            this.symbolTableTreeWidget.setModel(null);
        }
    }

    public Designer(String[] args) {
        if (args.length > 0) {
            this.exitOnClose = !args[0].equals("-noexitonclose");
        }
        Initializer.initialize();
        this.xpathQueryArea.setFont(new Font("Verdana", 0, 16));
        JSplitPane controlSplitPane = new JSplitPane(1, this.createCodeEditorPanel(), this.createXPathQueryPanel());
        JSplitPane astAndSymbolTablePane = new JSplitPane(0, this.createASTPanel(), this.createSymbolTableResultPanel());
        JSplitPane resultsSplitPane = new JSplitPane(1, astAndSymbolTablePane, this.createXPathResultPanel());
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addTab("Abstract Syntax Tree / XPath / Symbol Table", resultsSplitPane);
        tabbed.addTab("Data Flow Analysis", this.dfaPanel);
        tabbed.setMnemonicAt(0, 65);
        tabbed.setMnemonicAt(1, 68);
        JSplitPane containerSplitPane = new JSplitPane(0, controlSplitPane, tabbed);
        containerSplitPane.setContinuousLayout(true);
        JMenuBar menuBar = this.createMenuBar();
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add(containerSplitPane);
        this.frame.setDefaultCloseOperation(this.exitOnClose ? 3 : 2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.frame.pack();
        this.frame.setSize(screenWidth * 3 / 4, screenHeight * 3 / 4);
        this.frame.setLocation((screenWidth - this.frame.getWidth()) / 2, (screenHeight - this.frame.getHeight()) / 2);
        this.frame.setVisible(true);
        int horozontalMiddleLocation = controlSplitPane.getMaximumDividerLocation() * 3 / 5;
        controlSplitPane.setDividerLocation(horozontalMiddleLocation);
        containerSplitPane.setDividerLocation(containerSplitPane.getMaximumDividerLocation() / 2);
        astAndSymbolTablePane.setDividerLocation(astAndSymbolTablePane.getMaximumDividerLocation() / 3);
        resultsSplitPane.setDividerLocation(horozontalMiddleLocation);
        this.loadSettings();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Language");
        ButtonGroup group = new ButtonGroup();
        LanguageVersion[] languageVersions = Designer.getSupportedLanguageVersions();
        for (int i = 0; i < languageVersions.length; ++i) {
            JRadioButtonMenuItem button;
            LanguageVersion languageVersion = languageVersions[i];
            this.languageVersionMenuItems[i] = button = new JRadioButtonMenuItem(languageVersion.getShortName());
            group.add(button);
            menu.add(button);
        }
        this.languageVersionMenuItems[DEFAULT_LANGUAGE_VERSION_SELECTION_INDEX].setSelected(true);
        menuBar.add(menu);
        JMenu actionsMenu = new JMenu("Actions");
        JMenuItem copyXMLItem = new JMenuItem("Copy xml to clipboard");
        copyXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.copyXmlToClipboard();
            }
        });
        actionsMenu.add(copyXMLItem);
        JMenuItem createRuleXMLItem = new JMenuItem("Create rule XML");
        createRuleXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.createRuleXML();
            }
        });
        actionsMenu.add(createRuleXMLItem);
        menuBar.add(actionsMenu);
        return menuBar;
    }

    private void createRuleXML() {
        CreateXMLRulePanel rulePanel = new CreateXMLRulePanel(this.xpathQueryArea, this.codeEditorPane);
        JFrame xmlframe = new JFrame("Create XML Rule");
        xmlframe.setContentPane(rulePanel);
        xmlframe.setDefaultCloseOperation(2);
        xmlframe.setSize(new Dimension(600, 700));
        xmlframe.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JFrame tmp = (JFrame)e.getSource();
                if (tmp.getWidth() < 600 || tmp.getHeight() < 700) {
                    tmp.setSize(600, 700);
                }
            }
        });
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        xmlframe.pack();
        xmlframe.setLocation((screenWidth - xmlframe.getWidth()) / 2, (screenHeight - xmlframe.getHeight()) / 2);
        xmlframe.setVisible(true);
    }

    private JComponent createCodeEditorPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.codeEditorPane.setBorder(BorderFactory.createLineBorder(Color.black));
        Designer.makeTextComponentUndoable(this.codeEditorPane);
        p.add((Component)new JLabel("Source code:"), "North");
        p.add((Component)new JScrollPane(this.codeEditorPane), "Center");
        return p;
    }

    private JComponent createASTPanel() {
        this.astTreeWidget.setCellRenderer(this.createNoImageTreeCellRenderer());
        TreeSelectionModel model = this.astTreeWidget.getSelectionModel();
        model.setSelectionMode(1);
        model.addTreeSelectionListener(new SymbolTableListener());
        model.addTreeSelectionListener(new CodeHighlightListener());
        return new JScrollPane(this.astTreeWidget);
    }

    private JComponent createXPathResultPanel() {
        this.xpathResults.addElement("No XPath results yet, run an XPath Query first.");
        this.xpathResultList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.xpathResultList.setFixedCellWidth(300);
        this.xpathResultList.setCellRenderer(new ASTListCellRenderer());
        this.xpathResultList.setSelectionMode(0);
        this.xpathResultList.getSelectionModel().addListSelectionListener(new ASTSelectionListener());
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.xpathResultList);
        return scrollPane;
    }

    private JPanel createXPathQueryPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.xpathQueryArea.setBorder(BorderFactory.createLineBorder(Color.black));
        Designer.makeTextComponentUndoable(this.xpathQueryArea);
        JScrollPane scrollPane = new JScrollPane(this.xpathQueryArea);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        JButton b = this.createGoButton();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)new JLabel("XPath Query (if any):"), "West");
        topPanel.add((Component)this.createXPathVersionPanel(), "East");
        p.add((Component)topPanel, "North");
        p.add((Component)scrollPane, "Center");
        p.add((Component)b, "South");
        return p;
    }

    private JComponent createSymbolTableResultPanel() {
        this.symbolTableTreeWidget.setCellRenderer(this.createNoImageTreeCellRenderer());
        return new JScrollPane(this.symbolTableTreeWidget);
    }

    private JPanel createXPathVersionPanel() {
        JPanel p = new JPanel();
        p.add(new JLabel("XPath Version:"));
        for (Object[] values : XPathRule.VERSION_DESCRIPTOR.choices()) {
            JRadioButton b = new JRadioButton();
            b.setText((String)values[0]);
            b.setActionCommand(b.getText());
            if (values[0].equals(XPathRule.VERSION_DESCRIPTOR.defaultValue())) {
                b.setSelected(true);
            }
            this.xpathVersionButtonGroup.add(b);
            p.add(b);
        }
        return p;
    }

    private JButton createGoButton() {
        JButton b = new JButton("Go");
        b.setMnemonic('g');
        b.addActionListener(new ShowListener());
        b.addActionListener(new XPathListener());
        b.addActionListener(new DFAListener());
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Designer.this.saveSettings();
            }
        });
        return b;
    }

    private static void makeTextComponentUndoable(JTextComponent textConponent) {
        final UndoManager undoManager = new UndoManager();
        textConponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                undoManager.addEdit(evt.getEdit());
            }
        });
        ActionMap actionMap = textConponent.getActionMap();
        InputMap inputMap = textConponent.getInputMap();
        actionMap.put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control Z"), "Undo");
        actionMap.put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    public static void main(String[] args) {
        new Designer(args);
    }

    private final void copyXmlToClipboard() {
        if (this.codeEditorPane.getText() != null && this.codeEditorPane.getText().trim().length() > 0) {
            String xml = "";
            Node cu = this.getCompilationUnit();
            if (cu != null) {
                try {
                    xml = this.getXmlString(cu);
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    xml = "Error trying to construct XML representation";
                }
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(xml), this);
        }
    }

    private String getXmlString(Node node) throws TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(node.getAsDocument());
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 3);
        Transformer xformer = transformerFactory.newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.transform(source, result);
        return writer.toString();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void loadSettings() {
        block5: {
            try {
                File file = new File(SETTINGS_FILE_NAME);
                if (!file.exists()) break block5;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(new FileInputStream(file));
                Element settingsElement = document.getDocumentElement();
                Element codeElement = (Element)settingsElement.getElementsByTagName("code").item(0);
                Element xpathElement = (Element)settingsElement.getElementsByTagName("xpath").item(0);
                String code = this.getTextContext(codeElement);
                String languageVersion = codeElement.getAttribute("language-version");
                String xpath = this.getTextContext(xpathElement);
                String xpathVersion = xpathElement.getAttribute("version");
                this.codeEditorPane.setText(code);
                this.setLanguageVersion(LanguageVersion.findByTerseName(languageVersion));
                this.xpathQueryArea.setText(xpath);
                Enumeration<AbstractButton> e = this.xpathVersionButtonGroup.getElements();
                while (e.hasMoreElements()) {
                    AbstractButton button = e.nextElement();
                    if (!xpathVersion.equals(button.getActionCommand())) continue;
                    button.setSelected(true);
                    break;
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveSettings() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element settingsElement = document.createElement("settings");
            document.appendChild(settingsElement);
            Element codeElement = document.createElement("code");
            settingsElement.appendChild(codeElement);
            codeElement.setAttribute("language-version", this.getLanguageVersion().getTerseName());
            codeElement.appendChild(document.createCDATASection(this.codeEditorPane.getText()));
            Element xpathElement = document.createElement("xpath");
            settingsElement.appendChild(xpathElement);
            xpathElement.setAttribute("version", this.xpathVersionButtonGroup.getSelection().getActionCommand());
            xpathElement.appendChild(document.createCDATASection(this.xpathQueryArea.getText()));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileWriter(new File(SETTINGS_FILE_NAME)));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private String getTextContext(Element element) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
            org.w3c.dom.Node child = element.getChildNodes().item(i);
            if (!(child instanceof Text)) continue;
            buf.append(((Text)child).getData());
        }
        return buf.toString();
    }

    private class ASTSelectionListener
    implements ListSelectionListener {
        private ASTSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            Object o;
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty() && (o = Designer.this.xpathResults.get(lsm.getMinSelectionIndex())) instanceof Node) {
                Designer.this.codeEditorPane.select((Node)o);
            }
        }
    }

    private class ASTListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ASTListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof Node) {
                Node node = (Node)value;
                StringBuffer sb = new StringBuffer();
                String name = node.getClass().getName().substring(node.getClass().getName().lastIndexOf(46) + 1);
                if (Proxy.isProxyClass(value.getClass())) {
                    name = value.toString();
                }
                sb.append(name).append(" at line ").append(node.getBeginLine()).append(" column ").append(node.getBeginColumn()).append(PMD.EOL);
                text = sb.toString();
            } else {
                text = value.toString();
            }
            this.setText(text);
            return this;
        }
    }

    private class CodeHighlightListener
    implements TreeSelectionListener {
        private CodeHighlightListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            ASTTreeNode selected;
            if (e.getNewLeadSelectionPath() != null && (selected = (ASTTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()) != null) {
                Designer.this.codeEditorPane.select(selected.node);
            }
        }
    }

    private class SymbolTableListener
    implements TreeSelectionListener {
        private SymbolTableListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() != null) {
                Scope scope;
                ASTTreeNode astTreeNode = (ASTTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                DefaultMutableTreeNode symbolTableTreeNode = new DefaultMutableTreeNode();
                DefaultMutableTreeNode selectedAstTreeNode = new DefaultMutableTreeNode("AST Node: " + astTreeNode.label());
                symbolTableTreeNode.add(selectedAstTreeNode);
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                for (scope = astTreeNode.getScope(); scope != null; scope = scope.getParent()) {
                    scopes.add(scope);
                }
                Collections.reverse(scopes);
                for (int i = 0; i < scopes.size(); ++i) {
                    ClassScope classScope;
                    DefaultMutableTreeNode nameOccurenceTreeNode;
                    scope = (Scope)scopes.get(i);
                    DefaultMutableTreeNode scopeTreeNode = new DefaultMutableTreeNode("Scope: " + scope.getClass().getSimpleName());
                    selectedAstTreeNode.add(scopeTreeNode);
                    if (!(scope instanceof MethodScope || scope instanceof LocalScope || scope.getClassDeclarations().isEmpty())) {
                        for (ClassNameDeclaration classNameDeclaration : scope.getClassDeclarations().keySet()) {
                            DefaultMutableTreeNode classNameDeclarationTreeNode = new DefaultMutableTreeNode("Class name declaration: " + classNameDeclaration);
                            scopeTreeNode.add(classNameDeclarationTreeNode);
                            for (NameOccurrence nameOccurrence : scope.getClassDeclarations().get(classNameDeclaration)) {
                                nameOccurenceTreeNode = new DefaultMutableTreeNode("Name occurrence: " + nameOccurrence);
                                classNameDeclarationTreeNode.add(nameOccurenceTreeNode);
                            }
                        }
                    }
                    if (scope instanceof ClassScope && !(classScope = (ClassScope)scope).getMethodDeclarations().isEmpty()) {
                        for (MethodNameDeclaration methodNameDeclaration : classScope.getMethodDeclarations().keySet()) {
                            DefaultMutableTreeNode methodNameDeclarationTreeNode = new DefaultMutableTreeNode("Method name declaration: " + methodNameDeclaration);
                            scopeTreeNode.add(methodNameDeclarationTreeNode);
                            for (NameOccurrence nameOccurrence : classScope.getMethodDeclarations().get(methodNameDeclaration)) {
                                DefaultMutableTreeNode nameOccurenceTreeNode2 = new DefaultMutableTreeNode("Name occurrence: " + nameOccurrence);
                                methodNameDeclarationTreeNode.add(nameOccurenceTreeNode2);
                            }
                        }
                    }
                    if (scope instanceof SourceFileScope || scope.getVariableDeclarations().isEmpty()) continue;
                    for (VariableNameDeclaration variableNameDeclaration : scope.getVariableDeclarations().keySet()) {
                        DefaultMutableTreeNode variableNameDeclarationTreeNode = new DefaultMutableTreeNode("Variable name declaration: " + variableNameDeclaration);
                        scopeTreeNode.add(variableNameDeclarationTreeNode);
                        for (NameOccurrence nameOccurrence : scope.getVariableDeclarations().get(variableNameDeclaration)) {
                            nameOccurenceTreeNode = new DefaultMutableTreeNode("Name occurrence: " + nameOccurrence);
                            variableNameDeclarationTreeNode.add(nameOccurenceTreeNode);
                        }
                    }
                }
                List<String> attributes = astTreeNode.getAttributes();
                DefaultMutableTreeNode attributesNode = new DefaultMutableTreeNode("Attributes (accessible via XPath):");
                selectedAstTreeNode.add(attributesNode);
                for (String attribute : attributes) {
                    attributesNode.add(new DefaultMutableTreeNode(attribute));
                }
                Designer.this.loadSymbolTableTreeData(symbolTableTreeNode);
            }
        }
    }

    private class XPathListener
    implements ActionListener {
        private XPathListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            Designer.this.xpathResults.clear();
            if (StringUtil.isEmpty(Designer.this.xpathQueryArea.getText())) {
                Designer.this.xpathResults.addElement("XPath query field is empty.");
                Designer.this.xpathResultList.repaint();
                Designer.this.codeEditorPane.requestFocus();
                return;
            }
            Node c = Designer.this.getCompilationUnit();
            try {
                XPathRule xpathRule = new XPathRule(){

                    public void addViolation(Object data, Node node, String arg) {
                        Designer.this.xpathResults.addElement(node);
                    }
                };
                xpathRule.setMessage("");
                xpathRule.setLanguage(Designer.this.getLanguageVersion().getLanguage());
                xpathRule.setXPath(Designer.this.xpathQueryArea.getText());
                xpathRule.setVersion(Designer.this.xpathVersionButtonGroup.getSelection().getActionCommand());
                RuleSet ruleSet = new RuleSet();
                ruleSet.addRule(xpathRule);
                RuleSets ruleSets = new RuleSets(ruleSet);
                RuleContext ruleContext = new RuleContext();
                ruleContext.setLanguageVersion(Designer.this.getLanguageVersion());
                ArrayList<Node> nodes = new ArrayList<Node>();
                nodes.add(c);
                ruleSets.apply(nodes, ruleContext, xpathRule.getLanguage());
                if (Designer.this.xpathResults.isEmpty()) {
                    Designer.this.xpathResults.addElement("No matching nodes " + System.currentTimeMillis());
                }
            }
            catch (ParseException pe) {
                Designer.this.xpathResults.addElement(pe.fillInStackTrace().getMessage());
            }
            Designer.this.xpathResultList.repaint();
            Designer.this.xpathQueryArea.requestFocus();
        }
    }

    private class DFAListener
    implements ActionListener {
        private DFAListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            DFAGraphRule dfaGraphRule = new DFAGraphRule();
            RuleSet rs = new RuleSet();
            LanguageVersion languageVersion = Designer.this.getLanguageVersion();
            if (languageVersion.getLanguage().equals((Object)Language.JAVA)) {
                rs.addRule(dfaGraphRule);
            }
            RuleContext ctx = new RuleContext();
            ctx.setSourceCodeFilename("[no filename]." + languageVersion.getLanguage().getExtensions().get(0));
            StringReader reader = new StringReader(Designer.this.codeEditorPane.getText());
            PMDConfiguration config = new PMDConfiguration();
            config.setDefaultLanguageVersion(languageVersion);
            try {
                new SourceCodeProcessor(config).processSourceCode(reader, new RuleSets(rs), ctx);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            List<ASTMethodDeclaration> methods = dfaGraphRule.getMethods();
            if (methods != null && !methods.isEmpty()) {
                Designer.this.dfaPanel.resetTo(methods, Designer.this.codeEditorPane);
                Designer.this.dfaPanel.repaint();
            }
        }
    }

    private class ShowListener
    implements ActionListener {
        private ShowListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            TreeNode tn;
            try {
                Node lastCompilationUnit = Designer.this.getCompilationUnit();
                tn = new ASTTreeNode(lastCompilationUnit);
            }
            catch (ParseException pe) {
                tn = new ExceptionNode(pe);
            }
            Designer.this.loadASTTreeData(tn);
            Designer.this.loadSymbolTableTreeData(null);
        }
    }

    private class TreeWidget
    extends JTree {
        private static final long serialVersionUID = 1L;

        public TreeWidget(Object[] items) {
            super(items);
            this.setToolTipText("");
        }

        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value == null) {
                return "";
            }
            if (value instanceof ASTTreeNode) {
                return ((ASTTreeNode)value).label();
            }
            if (value instanceof ExceptionNode) {
                return ((ExceptionNode)value).label();
            }
            return value.toString();
        }

        public String getToolTipText(MouseEvent e) {
            if (this.getRowForLocation(e.getX(), e.getY()) == -1) {
                return null;
            }
            TreePath curPath = this.getPathForLocation(e.getX(), e.getY());
            if (curPath.getLastPathComponent() instanceof ASTTreeNode) {
                return ((ASTTreeNode)curPath.getLastPathComponent()).getToolTipText();
            }
            return super.getToolTipText(e);
        }

        public void expandAll(boolean expand) {
            TreeNode root = (TreeNode)this.getModel().getRoot();
            this.expandAll(new TreePath(root), expand);
        }

        private void expandAll(TreePath parent, boolean expand) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(path, expand);
                }
            }
            if (expand) {
                this.expandPath(parent);
            } else {
                this.collapsePath(parent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ASTTreeNode
    implements TreeNode {
        private Node node;
        private ASTTreeNode parent;
        private ASTTreeNode[] kids;

        public ASTTreeNode(Node theNode) {
            this.node = theNode;
            Node parent = this.node.jjtGetParent();
            if (parent != null) {
                this.parent = new ASTTreeNode(parent);
            }
        }

        private ASTTreeNode(ASTTreeNode parent, Node theNode) {
            this.node = theNode;
            this.parent = parent;
        }

        @Override
        public int getChildCount() {
            return this.node.jjtGetNumChildren();
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return this.node.jjtGetNumChildren() == 0;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        public Scope getScope() {
            if (this.node instanceof JavaNode) {
                return ((JavaNode)this.node).getScope();
            }
            return null;
        }

        public Enumeration<ASTTreeNode> children() {
            if (this.getChildCount() > 0) {
                this.getChildAt(0);
            }
            Enumeration<ASTTreeNode> e = new Enumeration<ASTTreeNode>(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return ASTTreeNode.this.kids != null && this.i < ASTTreeNode.this.kids.length;
                }

                @Override
                public ASTTreeNode nextElement() {
                    return ASTTreeNode.this.kids[this.i++];
                }
            };
            return e;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            if (this.kids == null) {
                this.kids = new ASTTreeNode[this.node.jjtGetNumChildren()];
                for (int i = 0; i < this.kids.length; ++i) {
                    this.kids[i] = new ASTTreeNode(this.parent, this.node.jjtGetChild(i));
                }
            }
            return this.kids[childIndex];
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != node) continue;
                return i;
            }
            return -1;
        }

        public String label() {
            LanguageVersionHandler languageVersionHandler = Designer.this.getLanguageVersionHandler();
            StringWriter writer = new StringWriter();
            languageVersionHandler.getDumpFacade(writer, "", false).start(this.node);
            return writer.toString();
        }

        public String getToolTipText() {
            String tooltip = "Line: " + this.node.getBeginLine() + " Column: " + this.node.getBeginColumn();
            if (this.node instanceof AccessNode) {
                AccessNode accessNode = (AccessNode)((Object)this.node);
                if (!"".equals(tooltip)) {
                    tooltip = tooltip + ",";
                }
                tooltip = tooltip + (accessNode.isAbstract() ? " Abstract" : "");
                tooltip = tooltip + (accessNode.isStatic() ? " Static" : "");
                tooltip = tooltip + (accessNode.isFinal() ? " Final" : "");
                tooltip = tooltip + (accessNode.isNative() ? " Native" : "");
                tooltip = tooltip + (accessNode.isPrivate() ? " Private" : "");
                tooltip = tooltip + (accessNode.isSynchronized() ? " Synchronised" : "");
                tooltip = tooltip + (accessNode.isTransient() ? " Transient" : "");
                tooltip = tooltip + (accessNode.isVolatile() ? " Volatile" : "");
                tooltip = tooltip + (accessNode.isStrictfp() ? " Strictfp" : "");
            }
            return tooltip;
        }

        public List<String> getAttributes() {
            LinkedList<String> result = new LinkedList<String>();
            AttributeAxisIterator attributeAxisIterator = new AttributeAxisIterator(this.node);
            while (attributeAxisIterator.hasNext()) {
                Attribute attribute = attributeAxisIterator.next();
                result.add(attribute.getName() + "=" + attribute.getStringValue());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionNode
    implements TreeNode {
        private Object item;
        private ExceptionNode[] kids;

        public ExceptionNode(Object theItem) {
            this.item = theItem;
            if (this.item instanceof ParseException) {
                this.createKids();
            }
        }

        private void createKids() {
            String message = ((ParseException)this.item).getMessage();
            String[] lines = StringUtil.substringsOf(message, PMD.EOL);
            this.kids = new ExceptionNode[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                this.kids[i] = new ExceptionNode(lines[i]);
            }
        }

        @Override
        public int getChildCount() {
            return this.kids == null ? 0 : this.kids.length;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return this.kids == null;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.kids[childIndex];
        }

        public String label() {
            return this.item.toString();
        }

        public Enumeration<ExceptionNode> children() {
            Enumeration<ExceptionNode> e = new Enumeration<ExceptionNode>(){
                int i = 0;

                @Override
                public boolean hasMoreElements() {
                    return ExceptionNode.this.kids != null && this.i < ExceptionNode.this.kids.length;
                }

                @Override
                public ExceptionNode nextElement() {
                    return ExceptionNode.this.kids[this.i++];
                }
            };
            return e;
        }

        @Override
        public int getIndex(TreeNode node) {
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != node) continue;
                return i;
            }
            return -1;
        }
    }
}

