/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.xml.XmlParserOptions;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.util.CompoundIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParser {
    protected final XmlParserOptions parserOptions;
    protected Map<org.w3c.dom.Node, XmlNode> nodeCache = new HashMap<org.w3c.dom.Node, XmlNode>();

    public XmlParser(XmlParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    protected Document parseDocument(Reader reader) throws ParseException {
        this.nodeCache.clear();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setCoalescing(this.parserOptions.isCoalescing());
            documentBuilderFactory.setExpandEntityReferences(this.parserOptions.isExpandEntityReferences());
            documentBuilderFactory.setIgnoringComments(this.parserOptions.isIgnoringComments());
            documentBuilderFactory.setIgnoringElementContentWhitespace(this.parserOptions.isIgnoringElementContentWhitespace());
            documentBuilderFactory.setNamespaceAware(this.parserOptions.isNamespaceAware());
            documentBuilderFactory.setValidating(this.parserOptions.isValidating());
            documentBuilderFactory.setXIncludeAware(this.parserOptions.isXincludeAware());
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.parserOptions.getEntityResolver());
            Document document = documentBuilder.parse(new InputSource(reader));
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public XmlNode parse(Reader reader) {
        Document document = this.parseDocument(reader);
        return this.createProxy(document);
    }

    public XmlNode createProxy(org.w3c.dom.Node node) {
        XmlNode proxy = this.nodeCache.get(node);
        if (proxy != null) {
            return proxy;
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        interfaces.add(XmlNode.class);
        if (node instanceof Document) {
            interfaces.add(RootNode.class);
        }
        this.addAllInterfaces(interfaces, node.getClass());
        proxy = (XmlNode)Proxy.newProxyInstance(XmlParser.class.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new XmlNodeInvocationHandler(node));
        this.nodeCache.put(node, proxy);
        return proxy;
    }

    public void addAllInterfaces(Set<Class<?>> interfaces, Class<?> clazz) {
        interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
        if (clazz.getSuperclass() != null) {
            this.addAllInterfaces(interfaces, clazz.getSuperclass());
        }
    }

    public class XmlNodeInvocationHandler
    implements InvocationHandler {
        private final org.w3c.dom.Node node;
        private Object userData;

        public XmlNodeInvocationHandler(org.w3c.dom.Node node) {
            this.node = node;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().isAssignableFrom(XmlNode.class) && !"java.lang.Object".equals(method.getDeclaringClass().getName())) {
                if ("jjtGetNumChildren".equals(method.getName())) {
                    return this.node.hasChildNodes() ? this.node.getChildNodes().getLength() : 0;
                }
                if ("jjtGetChild".equals(method.getName())) {
                    return XmlParser.this.createProxy(this.node.getChildNodes().item((Integer)args[0]));
                }
                if ("getImage".equals(method.getName())) {
                    if (this.node instanceof Text) {
                        return ((Text)this.node).getData();
                    }
                    return null;
                }
                if ("jjtGetParent".equals(method.getName())) {
                    org.w3c.dom.Node parent = this.node.getParentNode();
                    if (parent != null && !(parent instanceof Document)) {
                        return XmlParser.this.createProxy(parent);
                    }
                    return null;
                }
                if ("getAttributeIterator".equals(method.getName())) {
                    ArrayList<Iterator<Attribute>> iterators = new ArrayList<Iterator<Attribute>>();
                    final NamedNodeMap attributes = this.node.getAttributes();
                    iterators.add(new Iterator<Attribute>(){
                        private int index;

                        @Override
                        public boolean hasNext() {
                            return attributes != null && this.index < attributes.getLength();
                        }

                        @Override
                        public Attribute next() {
                            org.w3c.dom.Node attributeNode = attributes.item(this.index++);
                            return new Attribute((Node)XmlParser.this.createProxy(XmlNodeInvocationHandler.this.node), attributeNode.getNodeName(), attributeNode.getNodeValue());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    });
                    if (proxy instanceof Text) {
                        iterators.add(Collections.singletonList(new Attribute((Node)proxy, "Image", ((Text)proxy).getData())).iterator());
                    }
                    return new CompoundIterator(iterators.toArray(new Iterator[iterators.size()]));
                }
                if ("getBeginLine".equals(method.getName())) {
                    return -1;
                }
                if ("getBeginColumn".equals(method.getName())) {
                    return -1;
                }
                if ("getEndLine".equals(method.getName())) {
                    return -1;
                }
                if ("getEndColumn".equals(method.getName())) {
                    return -1;
                }
                if ("getNode".equals(method.getName())) {
                    return this.node;
                }
                if ("getUserData".equals(method.getName())) {
                    return this.userData;
                }
                if ("setUserData".equals(method.getName())) {
                    this.userData = args[0];
                    return null;
                }
                throw new UnsupportedOperationException("Method not supported for XmlNode: " + method);
            }
            if ("toString".equals(method.getName())) {
                String s = this.node.getNodeName();
                s = s.replace("#", "");
                return s;
            }
            Object result = method.invoke((Object)this.node, args);
            return result;
        }
    }
}

