/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.util.StringUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParserOptions
extends ParserOptions {
    public static final BooleanProperty COALESCING_DESCRIPTOR = new BooleanProperty("coalescing", "Specifies that the XML parser convert CDATA nodes to Text nodes and append it to the adjacent (if any) text node.", Boolean.FALSE, 3.0f);
    public static final BooleanProperty EXPAND_ENTITY_REFERENCES_DESCRIPTOR = new BooleanProperty("expandEntityReferences", "Specifies that the XML parser expand entity reference nodes.", Boolean.TRUE, 4.0f);
    public static final BooleanProperty IGNORING_COMMENTS_DESCRIPTOR = new BooleanProperty("ignoringComments", "Specifies that the XML parser ignore comments.", Boolean.FALSE, 5.0f);
    public static final BooleanProperty IGNORING_ELEMENT_CONTENT_WHITESPACE_DESCRIPTOR = new BooleanProperty("ignoringElementContentWhitespace", "Specifies that the XML parser eliminate whitespace in element content.  Setting this to 'true' will force validating.", Boolean.FALSE, 6.0f);
    public static final BooleanProperty NAMESPACE_AWARE_DESCRIPTOR = new BooleanProperty("namespaceAware", "Specifies that the XML parser will provide support for XML namespaces.", Boolean.TRUE, 7.0f);
    public static final BooleanProperty VALIDATING_DESCRIPTOR = new BooleanProperty("validating", "Specifies that the XML parser will validate documents as they are parsed.  This only works for DTDs.", Boolean.FALSE, 8.0f);
    public static final BooleanProperty XINCLUDE_AWARE_DESCRIPTOR = new BooleanProperty("xincludeAware", "Specifies that the XML parser will process XInclude markup.", Boolean.FALSE, 9.0f);
    public static final BooleanProperty LOOKUP_DESCRIPTOR_DTD = new BooleanProperty("xincludeAware", "Specifies whether XML parser will attempt to lookup the DTD.", Boolean.FALSE, 10.0f);
    public static final EntityResolver SILENT_ENTITY_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream("".getBytes()));
        }
    };
    private boolean coalescing;
    private boolean expandEntityReferences;
    private boolean ignoringComments;
    private boolean ignoringElementContentWhitespace;
    private boolean namespaceAware;
    private boolean validating;
    private boolean xincludeAware;
    private boolean lookupDescriptorDoc;

    public XmlParserOptions() {
        this.coalescing = (Boolean)COALESCING_DESCRIPTOR.defaultValue();
        this.expandEntityReferences = (Boolean)EXPAND_ENTITY_REFERENCES_DESCRIPTOR.defaultValue();
        this.ignoringComments = (Boolean)IGNORING_COMMENTS_DESCRIPTOR.defaultValue();
        this.ignoringElementContentWhitespace = (Boolean)IGNORING_ELEMENT_CONTENT_WHITESPACE_DESCRIPTOR.defaultValue();
        this.namespaceAware = (Boolean)NAMESPACE_AWARE_DESCRIPTOR.defaultValue();
        this.validating = (Boolean)VALIDATING_DESCRIPTOR.defaultValue();
        this.xincludeAware = (Boolean)XINCLUDE_AWARE_DESCRIPTOR.defaultValue();
        this.lookupDescriptorDoc = (Boolean)LOOKUP_DESCRIPTOR_DTD.defaultValue();
    }

    public XmlParserOptions(Rule rule) {
        this.coalescing = rule.getProperty(COALESCING_DESCRIPTOR);
        this.expandEntityReferences = rule.getProperty(EXPAND_ENTITY_REFERENCES_DESCRIPTOR);
        this.ignoringComments = rule.getProperty(IGNORING_COMMENTS_DESCRIPTOR);
        this.ignoringElementContentWhitespace = rule.getProperty(IGNORING_ELEMENT_CONTENT_WHITESPACE_DESCRIPTOR);
        this.namespaceAware = rule.getProperty(NAMESPACE_AWARE_DESCRIPTOR);
        this.validating = rule.getProperty(VALIDATING_DESCRIPTOR);
        this.xincludeAware = rule.getProperty(XINCLUDE_AWARE_DESCRIPTOR);
        this.lookupDescriptorDoc = rule.getProperty(LOOKUP_DESCRIPTOR_DTD);
    }

    public EntityResolver getEntityResolver() {
        if (!this.lookupDescriptorDoc) {
            return SILENT_ENTITY_RESOLVER;
        }
        return null;
    }

    public boolean isLookupDescriptorDoc() {
        return this.lookupDescriptorDoc;
    }

    public void setLookupDescriptorDoc(boolean lookupDescriptorDoc) {
        this.lookupDescriptorDoc = lookupDescriptorDoc;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    public void setExpandEntityReferences(boolean expandEntityReferences) {
        this.expandEntityReferences = expandEntityReferences;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public void setIgnoringComments(boolean ignoringComments) {
        this.ignoringComments = ignoringComments;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringElementContentWhitespace) {
        this.ignoringElementContentWhitespace = ignoringElementContentWhitespace;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isXincludeAware() {
        return this.xincludeAware;
    }

    public void setXincludeAware(boolean xincludeAware) {
        this.xincludeAware = xincludeAware;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.coalescing ? 1231 : 1237);
        result = 31 * result + (this.expandEntityReferences ? 1231 : 1237);
        result = 31 * result + (this.ignoringComments ? 1231 : 1237);
        result = 31 * result + (this.ignoringElementContentWhitespace ? 1231 : 1237);
        result = 31 * result + (this.namespaceAware ? 1231 : 1237);
        result = 31 * result + (this.validating ? 1231 : 1237);
        result = 31 * result + (this.xincludeAware ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        XmlParserOptions that = (XmlParserOptions)obj;
        return StringUtil.isSame(this.suppressMarker, that.suppressMarker, false, false, false) && this.coalescing == that.coalescing && this.expandEntityReferences == that.expandEntityReferences && this.ignoringComments == that.ignoringComments && this.ignoringElementContentWhitespace == that.ignoringElementContentWhitespace && this.namespaceAware == that.namespaceAware && this.validating == that.validating && this.xincludeAware == that.xincludeAware;
    }
}

