/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.AbstractXPathRuleQuery;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.expr.AllNodeStep;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnionExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxenXPathRuleQuery
extends AbstractXPathRuleQuery {
    private static final Logger LOG = Logger.getLogger(JaxenXPathRuleQuery.class.getName());
    private InitializationStatus initializationStatus = InitializationStatus.NONE;
    private Map<String, List<XPath>> nodeNameToXPaths;
    private static final String AST_ROOT = "_AST_ROOT_";

    @Override
    public boolean isSupportedVersion(String version) {
        return "1.0".equals(version);
    }

    @Override
    public List<Node> evaluate(Node node, RuleContext data) {
        ArrayList<Node> results = new ArrayList<Node>();
        try {
            this.initializeXPathExpression(data.getLanguageVersion().getLanguageVersionHandler().getXPathHandler().getNavigator());
            List<XPath> xpaths = this.nodeNameToXPaths.get(node.toString());
            if (xpaths == null) {
                xpaths = this.nodeNameToXPaths.get(AST_ROOT);
            }
            for (XPath xpath : xpaths) {
                List nodes = xpath.selectNodes((Object)node);
                results.addAll(nodes);
            }
        }
        catch (JaxenException ex) {
            throw new RuntimeException(ex);
        }
        return results;
    }

    @Override
    public List<String> getRuleChainVisits() {
        try {
            this.initializeXPathExpression(null);
            return super.getRuleChainVisits();
        }
        catch (JaxenException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeXPathExpression(Navigator navigator) throws JaxenException {
        if (this.initializationStatus == InitializationStatus.FULL || this.initializationStatus == InitializationStatus.PARTIAL && navigator == null) {
            return;
        }
        this.nodeNameToXPaths = new HashMap<String, List<XPath>>();
        BaseXPath originalXPath = this.createXPath(this.xpath, navigator);
        this.indexXPath((XPath)originalXPath, AST_ROOT);
        boolean useRuleChain = true;
        Stack<Expr> pending = new Stack<Expr>();
        pending.push(originalXPath.getRootExpr());
        while (!pending.isEmpty()) {
            Expr node = (Expr)pending.pop();
            boolean valid = false;
            if (node instanceof LocationPath) {
                List steps;
                LocationPath locationPath = (LocationPath)node;
                if (locationPath.isAbsolute() && (steps = locationPath.getSteps()).size() >= 2) {
                    Step step1 = (Step)steps.get(0);
                    Step step2 = (Step)steps.get(1);
                    if (step1 instanceof AllNodeStep && ((AllNodeStep)step1).getAxis() == 12 && step2 instanceof NameStep && ((NameStep)step2).getAxis() == 1) {
                        DefaultXPathFactory xpathFactory = new DefaultXPathFactory();
                        LocationPath relativeLocationPath = xpathFactory.createRelativeLocationPath();
                        Step allNodeStep = xpathFactory.createAllNodeStep(11);
                        Iterator i = step2.getPredicates().iterator();
                        while (i.hasNext()) {
                            allNodeStep.addPredicate((Predicate)i.next());
                        }
                        relativeLocationPath.addStep(allNodeStep);
                        for (int i2 = 2; i2 < steps.size(); ++i2) {
                            relativeLocationPath.addStep((Step)steps.get(i2));
                        }
                        BaseXPath xpath = this.createXPath(relativeLocationPath.getText(), navigator);
                        this.indexXPath((XPath)xpath, ((NameStep)step2).getLocalName());
                        valid = true;
                    }
                }
            } else if (node instanceof UnionExpr) {
                UnionExpr unionExpr = (UnionExpr)node;
                pending.push(unionExpr.getLHS());
                pending.push(unionExpr.getRHS());
                valid = true;
            }
            if (valid) continue;
            useRuleChain = false;
            break;
        }
        if (useRuleChain) {
            this.ruleChainVisits.addAll(this.nodeNameToXPaths.keySet());
        } else {
            this.nodeNameToXPaths.clear();
            this.indexXPath((XPath)originalXPath, AST_ROOT);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Unable to use RuleChain for for XPath: " + this.xpath);
            }
        }
        if (navigator == null) {
            this.initializationStatus = InitializationStatus.PARTIAL;
            this.nodeNameToXPaths = null;
        } else {
            this.initializationStatus = InitializationStatus.FULL;
        }
    }

    private void indexXPath(XPath xpath, String nodeName) {
        List<XPath> xpaths = this.nodeNameToXPaths.get(nodeName);
        if (xpaths == null) {
            xpaths = new ArrayList<XPath>();
            this.nodeNameToXPaths.put(nodeName, xpaths);
        }
        xpaths.add(xpath);
    }

    private BaseXPath createXPath(String xpathQueryString, Navigator navigator) throws JaxenException {
        BaseXPath xpath = new BaseXPath(xpathQueryString, navigator);
        if (this.properties.size() > 1) {
            SimpleVariableContext vc = new SimpleVariableContext();
            for (Map.Entry e : this.properties.entrySet()) {
                String propName = ((PropertyDescriptor)e.getKey()).name();
                if ("xpath".equals(propName)) continue;
                Object value = e.getValue();
                vc.setVariableValue(propName, (Object)(value != null ? value.toString() : null));
            }
            xpath.setVariableContext((VariableContext)vc);
        }
        return xpath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InitializationStatus {
        NONE,
        PARTIAL,
        FULL;

    }
}

