/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedProperty;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.lang.rule.xpath.JaxenXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.SaxonXPathRuleQuery;
import net.sourceforge.pmd.lang.rule.xpath.XPathRuleQuery;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathRule
extends AbstractRule {
    public static final StringProperty XPATH_DESCRIPTOR = new StringProperty("xpath", "XPath expression", "", 1.0f);
    public static final EnumeratedProperty<String> VERSION_DESCRIPTOR = new EnumeratedProperty<String>("version", "XPath specification version", new String[]{"1.0", "1.0 compatibility", "2.0"}, new String[]{"1.0", "1.0 compatibility", "2.0"}, 0, 2.0f);
    private XPathRuleQuery xpathRuleQuery;

    public XPathRule() {
        this.definePropertyDescriptor(XPATH_DESCRIPTOR);
        this.definePropertyDescriptor(VERSION_DESCRIPTOR);
    }

    public XPathRule(String xPath) {
        this();
        this.setXPath(xPath);
    }

    public void setXPath(String xPath) {
        this.setProperty(XPATH_DESCRIPTOR, xPath);
    }

    public void setVersion(String version) {
        this.setProperty(VERSION_DESCRIPTOR, version);
    }

    @Override
    public void apply(List<? extends Node> nodes, RuleContext ctx) {
        for (Node node : nodes) {
            this.evaluate(node, ctx);
        }
    }

    public void evaluate(Node node, RuleContext data) {
        this.init();
        List<Node> nodes = this.xpathRuleQuery.evaluate(node, data);
        if (nodes != null) {
            for (Node n : nodes) {
                this.addViolation((Object)data, n, n.getImage());
            }
        }
    }

    @Override
    public List<String> getRuleChainVisits() {
        if (this.init()) {
            for (String nodeName : this.xpathRuleQuery.getRuleChainVisits()) {
                super.addRuleChainVisit(nodeName);
            }
        }
        return super.getRuleChainVisits();
    }

    private boolean init() {
        if (this.xpathRuleQuery == null) {
            String xpath = this.getProperty(XPATH_DESCRIPTOR);
            String version = (String)this.getProperty(VERSION_DESCRIPTOR);
            this.xpathRuleQuery = "1.0".equals(version) ? new JaxenXPathRuleQuery() : new SaxonXPathRuleQuery();
            this.xpathRuleQuery.setXPath(xpath);
            this.xpathRuleQuery.setVersion(version);
            this.xpathRuleQuery.setProperties(this.getPropertiesByPropertyDescriptor());
            return true;
        }
        return false;
    }

    public boolean hasXPathExpression() {
        String xPath = this.getProperty(XPATH_DESCRIPTOR);
        return StringUtil.isNotEmpty(xPath);
    }

    @Override
    public String dysfunctionReason() {
        return this.hasXPathExpression() ? null : "Missing xPath expression";
    }
}

