/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.comments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.FormalComment;
import net.sourceforge.pmd.lang.java.ast.MultiLineComment;
import net.sourceforge.pmd.lang.java.ast.SingleLineComment;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommentRule
extends AbstractJavaRule {
    protected AbstractCommentRule() {
    }

    protected List<Integer> tagsIndicesIn(String comments) {
        int atPos = comments.indexOf(64);
        if (atPos < 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.add(atPos);
        atPos = comments.indexOf(64, atPos + 1);
        while (atPos >= 0) {
            ints.add(atPos);
            atPos = comments.indexOf(64, atPos + 1);
        }
        return ints;
    }

    protected String filteredCommentIn(Comment comment) {
        String trimmed = comment.getImage().trim();
        if (comment instanceof SingleLineComment) {
            return this.singleLineIn(trimmed);
        }
        if (comment instanceof MultiLineComment) {
            return AbstractCommentRule.multiLinesIn(trimmed);
        }
        if (comment instanceof FormalComment) {
            return this.formalLinesIn(trimmed);
        }
        return trimmed;
    }

    private String singleLineIn(String comment) {
        if (comment.startsWith("//")) {
            return comment.substring(2);
        }
        return comment;
    }

    private static String asSingleString(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (StringUtil.isEmpty(line)) continue;
            sb.append(line).append('\n');
        }
        return sb.toString().trim();
    }

    private static String multiLinesIn(String comment) {
        String[] lines = comment.split("\n");
        ArrayList<String> filteredLines = new ArrayList<String>(lines.length);
        for (String rawLine : lines) {
            String line = rawLine.trim();
            if (line.endsWith("*/")) {
                int end = line.length() - 2;
                int start = line.startsWith("/*") ? 2 : 0;
                filteredLines.add(line.substring(start, end));
                continue;
            }
            if (line.length() > 0 && line.charAt(0) == '*') {
                filteredLines.add(line.substring(1));
                continue;
            }
            if (!line.startsWith("/*")) continue;
            filteredLines.add(line.substring(2));
        }
        return AbstractCommentRule.asSingleString(filteredLines);
    }

    private String formalLinesIn(String comment) {
        String[] lines = comment.split("\n");
        ArrayList<String> filteredLines = new ArrayList<String>(lines.length);
        for (String line : lines) {
            if (line.endsWith("*/")) {
                filteredLines.add(line.substring(0, line.length() - 2));
                continue;
            }
            if (line.length() > 0 && line.charAt(0) == '*') {
                filteredLines.add(line.substring(1));
                continue;
            }
            if (!line.startsWith("/**")) continue;
            filteredLines.add(line.substring(3));
        }
        return AbstractCommentRule.asSingleString(filteredLines);
    }

    protected SortedMap<Integer, Object> orderedCommentsAndDeclarations(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Object> itemsByLineNumber = new TreeMap<Integer, Object>();
        List<ASTPackageDeclaration> packageDecl = cUnit.findDescendantsOfType(ASTPackageDeclaration.class);
        for (ASTPackageDeclaration decl : packageDecl) {
            itemsByLineNumber.put(decl.getBeginLine(), decl);
        }
        for (Comment comment : cUnit.getComments()) {
            itemsByLineNumber.put(comment.getBeginLine(), comment);
        }
        List<ASTFieldDeclaration> fields = cUnit.findDescendantsOfType(ASTFieldDeclaration.class);
        for (ASTFieldDeclaration fieldDecl : fields) {
            itemsByLineNumber.put(fieldDecl.getBeginLine(), fieldDecl);
        }
        List<ASTMethodDeclaration> methods = cUnit.findDescendantsOfType(ASTMethodDeclaration.class);
        for (ASTMethodDeclaration methodDecl : methods) {
            itemsByLineNumber.put(methodDecl.getBeginLine(), methodDecl);
        }
        System.out.println("Items:" + itemsByLineNumber);
        return itemsByLineNumber;
    }
}

