/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.basic;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedMultiProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvoidBranchingStatementAsLastInLoopRule
extends AbstractJavaRule {
    public static final String CHECK_FOR = "for";
    public static final String CHECK_DO = "do";
    public static final String CHECK_WHILE = "while";
    private static final String[] ALL_LOOP_TYPES_LABELS = new String[]{"for", "do", "while"};
    private static final String[] ALL_LOOP_TYPES_VALUES = ALL_LOOP_TYPES_LABELS;
    private static final int[] ALL_LOOP_TYPES_DEFAULTS = new int[]{0, 1, 2};
    public static final EnumeratedMultiProperty<String> CHECK_BREAK_LOOP_TYPES = new EnumeratedMultiProperty<String>("checkBreakLoopTypes", "Check for break statements in loop types", ALL_LOOP_TYPES_LABELS, ALL_LOOP_TYPES_VALUES, ALL_LOOP_TYPES_DEFAULTS, 1.0f);
    public static final EnumeratedMultiProperty<String> CHECK_CONTINUE_LOOP_TYPES = new EnumeratedMultiProperty<String>("checkContinueLoopTypes", "Check for continue statements in loop types", ALL_LOOP_TYPES_LABELS, ALL_LOOP_TYPES_VALUES, ALL_LOOP_TYPES_DEFAULTS, 2.0f);
    public static final EnumeratedMultiProperty<String> CHECK_RETURN_LOOP_TYPES = new EnumeratedMultiProperty<String>("checkReturnLoopTypes", "Check for return statements in loop types", ALL_LOOP_TYPES_LABELS, ALL_LOOP_TYPES_VALUES, ALL_LOOP_TYPES_DEFAULTS, 3.0f);

    public AvoidBranchingStatementAsLastInLoopRule() {
        this.definePropertyDescriptor(CHECK_BREAK_LOOP_TYPES);
        this.definePropertyDescriptor(CHECK_CONTINUE_LOOP_TYPES);
        this.definePropertyDescriptor(CHECK_RETURN_LOOP_TYPES);
        this.addRuleChainVisit(ASTBreakStatement.class);
        this.addRuleChainVisit(ASTContinueStatement.class);
        this.addRuleChainVisit(ASTReturnStatement.class);
    }

    @Override
    public Object visit(ASTBreakStatement node, Object data) {
        return this.check(CHECK_BREAK_LOOP_TYPES, node, data);
    }

    @Override
    public Object visit(ASTContinueStatement node, Object data) {
        return this.check(CHECK_CONTINUE_LOOP_TYPES, node, data);
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        return this.check(CHECK_RETURN_LOOP_TYPES, node, data);
    }

    protected Object check(EnumeratedMultiProperty<String> property, Node node, Object data) {
        Node parent = node.getNthParent(5);
        if (parent instanceof ASTForStatement) {
            if (this.hasPropertyValue(property, CHECK_FOR)) {
                super.addViolation(data, node);
            }
        } else if (parent instanceof ASTWhileStatement) {
            if (this.hasPropertyValue(property, CHECK_WHILE)) {
                super.addViolation(data, node);
            }
        } else if (parent instanceof ASTDoStatement && this.hasPropertyValue(property, CHECK_DO)) {
            super.addViolation(data, node);
        }
        return data;
    }

    protected boolean hasPropertyValue(EnumeratedMultiProperty<String> property, String value) {
        Object[] values = this.getProperty(property);
        for (int i = 0; i < values.length; ++i) {
            if (!value.equals(values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean checksNothing() {
        return this.getProperty(CHECK_BREAK_LOOP_TYPES).length == 0 && this.getProperty(CHECK_CONTINUE_LOOP_TYPES).length == 0 && this.getProperty(CHECK_RETURN_LOOP_TYPES).length == 0;
    }

    @Override
    public String dysfunctionReason() {
        return this.checksNothing() ? "All loop types are ignored" : null;
    }
}

