/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTArrayComprehension;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTExpressionStatement;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTForInLoop;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTFunctionCall;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTFunctionNode;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTKeywordLiteral;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTLetNode;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTName;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTNewExpression;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTNumberLiteral;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTObjectProperty;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTRegExpLiteral;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTSwitchCase;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.ecmascript.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.ecmascript.ast.DestructuringNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptNode;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpFacade {
    private PrintWriter writer;
    private boolean recurse;

    public void initializeWith(Writer writer, String prefix, boolean recurse, EcmascriptNode<?> node) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.recurse = recurse;
        this.dump(node, prefix);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem flushing PrintWriter.", e);
        }
    }

    public Object visit(EcmascriptNode<?> node, Object data) {
        this.dump(node, (String)data);
        if (this.recurse) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.visit((EcmascriptNode)node.jjtGetChild(i), data + " ");
            }
            return data;
        }
        return data;
    }

    private void dump(EcmascriptNode<?> node, String prefix) {
        this.writer.print(prefix);
        this.writer.print(node.toString());
        String image = node.getImage();
        image = StringUtil.escapeWhitespace(image);
        ArrayList<String> extras = new ArrayList<String>();
        if (node instanceof DestructuringNode && ((DestructuringNode)((Object)node)).isDestructuring()) {
            extras.add("destructuring");
        }
        if (node instanceof ASTArrayComprehension) {
            if (((ASTArrayComprehension)node).hasFilter()) {
                extras.add("has filter");
            }
        } else if (node instanceof ASTBreakStatement) {
            if (((ASTBreakStatement)node).hasLabel()) {
                extras.add("has label");
            }
        } else if (node instanceof ASTCatchClause) {
            if (((ASTCatchClause)node).isIf()) {
                extras.add("if");
            }
        } else if (node instanceof ASTContinueStatement) {
            if (((ASTContinueStatement)node).hasLabel()) {
                extras.add("has label");
            }
        } else if (node instanceof ASTExpressionStatement) {
            if (((ASTExpressionStatement)node).hasResult()) {
                extras.add("has result");
            }
        } else if (node instanceof ASTForInLoop) {
            if (((ASTForInLoop)node).isForEach()) {
                extras.add("for each");
            }
        } else if (node instanceof ASTFunctionCall) {
            if (((ASTFunctionCall)node).hasArguments()) {
                extras.add("has arguments");
            }
        } else if (node instanceof ASTFunctionNode) {
            if (((ASTFunctionNode)node).isClosure()) {
                extras.add("closure");
            }
            if (((ASTFunctionNode)node).isGetter()) {
                extras.add("getter");
            }
            if (((ASTFunctionNode)node).isSetter()) {
                extras.add("setter");
            }
        } else if (node instanceof ASTIfStatement) {
            if (((ASTIfStatement)node).hasElse()) {
                extras.add("has else");
            }
        } else if (node instanceof ASTKeywordLiteral) {
            if (((ASTKeywordLiteral)node).isBoolean()) {
                extras.add("boolean");
            }
        } else if (node instanceof ASTLetNode) {
            if (((ASTLetNode)node).hasBody()) {
                extras.add("has body");
            }
        } else if (node instanceof ASTName) {
            if (((ASTName)node).isLocalName()) {
                extras.add("local");
            }
            if (((ASTName)node).isGlobalName()) {
                extras.add("global");
            }
        } else if (node instanceof ASTNewExpression) {
            if (((ASTNewExpression)node).hasArguments()) {
                extras.add("has arguments");
            }
            if (((ASTNewExpression)node).hasInitializer()) {
                extras.add("has initializer");
            }
        } else if (node instanceof ASTNumberLiteral) {
            extras.add("Number=" + ((ASTNumberLiteral)node).getNumber());
            extras.add("NormalizedImage=" + ((ASTNumberLiteral)node).getNormalizedImage());
        } else if (node instanceof ASTObjectProperty) {
            if (((ASTObjectProperty)node).isGetter()) {
                extras.add("getter");
            }
            if (((ASTObjectProperty)node).isSetter()) {
                extras.add("setter");
            }
        } else if (node instanceof ASTRegExpLiteral) {
            extras.add("Flags=" + ((ASTRegExpLiteral)node).getFlags());
        } else if (node instanceof ASTReturnStatement) {
            if (((ASTReturnStatement)node).hasResult()) {
                extras.add("has result");
            }
        } else if (node instanceof ASTStringLiteral) {
            if (((ASTStringLiteral)node).isSingleQuoted()) {
                extras.add("single quoted");
            }
            if (((ASTStringLiteral)node).isDoubleQuoted()) {
                extras.add("double quoted");
            }
        } else if (node instanceof ASTSwitchCase) {
            if (((ASTSwitchCase)node).isDefault()) {
                extras.add("default");
            }
        } else if (node instanceof ASTTryStatement) {
            if (((ASTTryStatement)node).isCatch()) {
                extras.add("catch");
            }
            if (((ASTTryStatement)node).isFinally()) {
                extras.add("finally");
            }
        } else if (node instanceof ASTUnaryExpression) {
            if (((ASTUnaryExpression)node).isPrefix()) {
                extras.add("prefix");
            }
            if (((ASTUnaryExpression)node).isPostfix()) {
                extras.add("postfix");
            }
        }
        if (node.hasSideEffects()) {
            extras.add("has side effects");
        }
        if (image != null || !extras.isEmpty()) {
            this.writer.print(':');
            if (image != null) {
                this.writer.print(image);
            }
            for (String extra : extras) {
                this.writer.print('(');
                this.writer.print(extra);
                this.writer.print(')');
            }
        }
        this.writer.println();
    }
}

