/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dcd.asm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.dcd.ClassLoaderUtil;
import net.sourceforge.pmd.dcd.asm.PrintVisitor;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSignatureVisitor
extends PrintVisitor
implements SignatureVisitor {
    private static final boolean TRACE = false;
    private static final int NO_TYPE = 0;
    private static final int FIELD_TYPE = 1;
    private static final int RETURN_TYPE = 2;
    private static final int PARAMETER_TYPE = 3;
    private int typeType;
    private Class<?> type;
    private int arrayDimensions = 0;
    private Class<?> fieldType;
    private Class<?> returnType;
    private List<Class<?>> parameterTypes = new ArrayList(0);

    public TypeSignatureVisitor() {
        this.init();
    }

    public TypeSignatureVisitor(PrintVisitor parent) {
        super(parent);
        this.init();
    }

    public void init() {
        this.typeType = 1;
        this.type = null;
        this.arrayDimensions = 0;
        this.parameterTypes.clear();
    }

    public Class<?> getFieldType() {
        this.popType();
        if (this.fieldType == null) {
            throw new RuntimeException();
        }
        return this.fieldType;
    }

    public Class<?> getMethodReturnType() {
        this.popType();
        if (this.returnType == null) {
            throw new RuntimeException();
        }
        return this.returnType;
    }

    public Class<?>[] getMethodParameterTypes() {
        this.popType();
        if (this.parameterTypes == null) {
            throw new RuntimeException();
        }
        if (this.parameterTypes != null) {
            return this.parameterTypes.toArray(new Class[this.parameterTypes.size()]);
        }
        return null;
    }

    private void pushType(int type) {
        this.typeType = type;
    }

    private void popType() {
        switch (this.typeType) {
            case 0: {
                break;
            }
            case 1: {
                this.fieldType = this.getType();
                break;
            }
            case 2: {
                this.returnType = this.getType();
                break;
            }
            case 3: {
                this.parameterTypes.add(this.getType());
                break;
            }
            default: {
                throw new RuntimeException("Unknown type type: " + this.typeType);
            }
        }
        this.typeType = 0;
        this.type = null;
        this.arrayDimensions = 0;
    }

    private Class<?> getType() {
        Class<?> type = null;
        if (this.type != null) {
            type = this.type;
            for (int i = 0; i < this.arrayDimensions; ++i) {
                Object array = Array.newInstance(type, 0);
                type = array.getClass();
            }
        }
        return type;
    }

    public SignatureVisitor visitArrayType() {
        ++this.arrayDimensions;
        return this;
    }

    public void visitBaseType(char descriptor) {
        switch (descriptor) {
            case 'B': {
                this.type = Byte.TYPE;
                break;
            }
            case 'C': {
                this.type = Character.TYPE;
                break;
            }
            case 'D': {
                this.type = Double.TYPE;
                break;
            }
            case 'F': {
                this.type = Float.TYPE;
                break;
            }
            case 'I': {
                this.type = Integer.TYPE;
                break;
            }
            case 'J': {
                this.type = Long.TYPE;
                break;
            }
            case 'S': {
                this.type = Short.TYPE;
                break;
            }
            case 'Z': {
                this.type = Boolean.TYPE;
                break;
            }
            case 'V': {
                this.type = Void.TYPE;
                break;
            }
            default: {
                throw new RuntimeException("Unknown baseType descriptor: " + descriptor);
            }
        }
    }

    public SignatureVisitor visitClassBound() {
        return this;
    }

    public void visitClassType(String name) {
        name = ClassLoaderUtil.fromInternalForm(name);
        this.type = ClassLoaderUtil.getClass(name);
    }

    public void visitEnd() {
        this.popType();
    }

    public SignatureVisitor visitExceptionType() {
        return this;
    }

    public void visitFormalTypeParameter(String name) {
    }

    public void visitInnerClassType(String name) {
    }

    public SignatureVisitor visitInterface() {
        return this;
    }

    public SignatureVisitor visitInterfaceBound() {
        return this;
    }

    public SignatureVisitor visitParameterType() {
        this.popType();
        this.pushType(3);
        return this;
    }

    public SignatureVisitor visitReturnType() {
        this.popType();
        this.pushType(2);
        return this;
    }

    public SignatureVisitor visitSuperclass() {
        return this;
    }

    public void visitTypeArgument() {
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        return this;
    }

    public void visitTypeVariable(String name) {
    }
}

