/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.util.datasource.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIncrementingRenderer
extends AbstractRenderer {
    protected List<Report.ProcessingError> errors = new LinkedList<Report.ProcessingError>();
    protected List<Report.SuppressedViolation> suppressed = new LinkedList<Report.SuppressedViolation>();

    public AbstractIncrementingRenderer(String name, String description) {
        super(name, description);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void startFileAnalysis(DataSource dataSource) {
    }

    @Override
    public void renderFileReport(Report report) throws IOException {
        Iterator<RuleViolation> violations = report.iterator();
        if (violations.hasNext()) {
            this.renderFileViolations(violations);
            this.getWriter().flush();
        }
        Iterator<Report.ProcessingError> i = report.errors();
        while (i.hasNext()) {
            this.errors.add(i.next());
        }
        if (this.showSuppressedViolations) {
            this.suppressed.addAll(report.getSuppressedRuleViolations());
        }
    }

    public abstract void renderFileViolations(Iterator<RuleViolation> var1) throws IOException;

    @Override
    public void end() throws IOException {
    }
}

