/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.optimizations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrematureDeclarationRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        Node block;
        ASTBlockStatement statement;
        if (node.jjtGetParent().getClass().equals(ASTForInit.class)) {
            return this.visit((JavaNode)node, data);
        }
        String varName = PrematureDeclarationRule.varNameIn(node);
        AbstractJavaNode grandparent = (AbstractJavaNode)node.jjtGetParent().jjtGetParent();
        List<Node> nextBlocks = PrematureDeclarationRule.blocksAfter(grandparent, node);
        Iterator<Node> i$ = nextBlocks.iterator();
        while (i$.hasNext() && !PrematureDeclarationRule.hasReferencesIn(statement = (ASTBlockStatement)(block = i$.next()), varName)) {
            if (!this.hasExit(statement)) continue;
            this.addViolation(data, (Node)node, varName);
            break;
        }
        return this.visit((JavaNode)node, data);
    }

    public static boolean hasAsParentBetween(Node node, Class<?> intermediateParentClass, Node topParent) {
        Node currentParent = node.jjtGetParent();
        while (currentParent != topParent) {
            if (!(currentParent = currentParent.jjtGetParent()).getClass().equals(intermediateParentClass)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExit(ASTBlockStatement block) {
        List<ASTReturnStatement> exitBlocks = block.findDescendantsOfType(ASTReturnStatement.class);
        exitBlocks.addAll(block.findDescendantsOfType(ASTThrowStatement.class));
        if (exitBlocks.isEmpty()) {
            return false;
        }
        for (int i = 0; i < exitBlocks.size(); ++i) {
            Node exitNode = exitBlocks.get(i);
            if (PrematureDeclarationRule.hasAsParentBetween(exitNode, ASTMethodDeclaration.class, block)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasReferencesIn(ASTBlockStatement block, String varName) {
        List<ASTName> names = block.findDescendantsOfType(ASTName.class);
        for (ASTName name : names) {
            if (!PrematureDeclarationRule.isReference(varName, name.getImage())) continue;
            return true;
        }
        return false;
    }

    private static boolean isReference(String shortName, String compoundName) {
        int dotPos = compoundName.indexOf(46);
        return dotPos < 0 ? shortName.equals(compoundName) : shortName.endsWith(compoundName.substring(0, dotPos));
    }

    private static String varNameIn(ASTLocalVariableDeclaration node) {
        ASTVariableDeclarator declarator = node.getFirstChildOfType(ASTVariableDeclarator.class);
        return ((ASTVariableDeclaratorId)declarator.jjtGetChild(0)).getImage();
    }

    private static int indexOf(AbstractJavaNode block, Node node) {
        int count = block.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            if (node != block.jjtGetChild(i)) continue;
            return i;
        }
        return -1;
    }

    private static List<Node> blocksAfter(AbstractJavaNode block, AbstractJavaNode node) {
        int count = block.jjtGetNumChildren();
        int start = PrematureDeclarationRule.indexOf(block, node.jjtGetParent()) + 1;
        ArrayList<Node> nextBlocks = new ArrayList<Node>(count);
        for (int i = start; i < count; ++i) {
            nextBlocks.add(block.jjtGetChild(i));
        }
        return nextBlocks;
    }
}

