/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codesize;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractStatisticalJavaRule;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NPathComplexityRule
extends AbstractStatisticalJavaRule {
    public NPathComplexityRule() {
        this.setProperty(MINIMUM_DESCRIPTOR, 200.0);
    }

    private int complexityMultipleOf(JavaNode node, int npathStart, Object data) {
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            JavaNode n = (JavaNode)node.jjtGetChild(i);
            npath *= ((Integer)n.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    private int complexitySumOf(JavaNode node, int npathStart, Object data) {
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            JavaNode n = (JavaNode)node.jjtGetChild(i);
            npath += ((Integer)n.jjtAccept(this, data)).intValue();
        }
        return npath;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode(node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        return npath;
    }

    public Object visit(JavaNode node, Object data) {
        int npath = this.complexityMultipleOf(node, 1, data);
        return npath;
    }

    public Object visit(ASTIfStatement node, Object data) {
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        int complexity = 0;
        ArrayList<JavaNode> statementChildren = new ArrayList<JavaNode>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i).getClass() != ASTStatement.class) continue;
            statementChildren.add((JavaNode)node.jjtGetChild(i));
        }
        if (statementChildren.isEmpty() || statementChildren.size() == 1 && node.hasElse() || statementChildren.size() != 1 && !node.hasElse()) {
            throw new IllegalStateException("If node has wrong number of children");
        }
        if (!node.hasElse()) {
            ++complexity;
        }
        for (JavaNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        return boolCompIf + complexity;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        Integer nPathWhile = (Integer)((JavaNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompWhile + nPathWhile + 1;
    }

    public Object visit(ASTDoStatement node, Object data) {
        int boolCompDo = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        Integer nPathDo = (Integer)((JavaNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompDo + nPathDo + 1;
    }

    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = NPathComplexityRule.sumExpressionComplexity(node.getFirstDescendantOfType(ASTExpression.class));
        Integer nPathFor = (Integer)((JavaNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        return boolCompFor + nPathFor + 1;
    }

    public Object visit(ASTReturnStatement node, Object data) {
        ASTExpression expr = node.getFirstChildOfType(ASTExpression.class);
        if (expr == null) {
            return NumericConstants.ONE;
        }
        int boolCompReturn = NPathComplexityRule.sumExpressionComplexity(expr);
        int conditionalExpressionComplexity = this.complexityMultipleOf(expr, 1, data);
        if (conditionalExpressionComplexity > 1) {
            boolCompReturn += conditionalExpressionComplexity;
        }
        if (boolCompReturn > 0) {
            return boolCompReturn;
        }
        return NumericConstants.ONE;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        int npath = 0;
        int caseRange = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            JavaNode n = (JavaNode)node.jjtGetChild(i);
            if (n instanceof ASTSwitchLabel) {
                npath += caseRange;
                caseRange = 1;
                continue;
            }
            Integer complexity = (Integer)n.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        return boolCompSwitch + (npath += caseRange);
    }

    public Object visit(ASTTryStatement node, Object data) {
        int npath = this.complexitySumOf(node, 0, data);
        return npath;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            int npath = this.complexitySumOf(node, 0, data);
            return npath += 2;
        }
        return NumericConstants.ONE;
    }

    public static int sumExpressionComplexity(ASTExpression expr) {
        if (expr == null) {
            return 0;
        }
        List<ASTConditionalAndExpression> andNodes = expr.findDescendantsOfType(ASTConditionalAndExpression.class);
        List<ASTConditionalOrExpression> orNodes = expr.findDescendantsOfType(ASTConditionalOrExpression.class);
        int children = 0;
        for (ASTConditionalOrExpression aSTConditionalOrExpression : orNodes) {
            children += aSTConditionalOrExpression.jjtGetNumChildren();
            --children;
        }
        for (ASTConditionalAndExpression aSTConditionalAndExpression : andNodes) {
            children += aSTConditionalAndExpression.jjtGetNumChildren();
            --children;
        }
        return children;
    }

    public Object[] getViolationParameters(DataPoint point) {
        return new String[]{((ASTMethodDeclaration)point.getNode()).getMethodName(), String.valueOf((int)point.getScore())};
    }
}

