/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa.report;

import java.util.Iterator;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.dfa.report.AbstractReportNode;
import net.sourceforge.pmd.lang.dfa.report.ClassNode;
import net.sourceforge.pmd.lang.dfa.report.PackageNode;
import net.sourceforge.pmd.lang.dfa.report.ViolationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTree {
    private PackageNode rootNode = new PackageNode("");
    private AbstractReportNode level;

    public Iterator<RuleViolation> iterator() {
        return new TreeIterator();
    }

    public int size() {
        int count = 0;
        Iterator<RuleViolation> i = this.iterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public AbstractReportNode getRootNode() {
        return this.rootNode;
    }

    public void addRuleViolation(RuleViolation violation) {
        ViolationNode tmp;
        AbstractReportNode node;
        String packageName = violation.getPackageName();
        if (packageName == null) {
            packageName = "";
        }
        this.level = this.rootNode;
        int endIndex = packageName.indexOf(46);
        while (true) {
            String parentPackage;
            if (!this.isStringInLevel(parentPackage = endIndex < 0 ? packageName : packageName.substring(0, endIndex))) {
                node = new PackageNode(parentPackage);
                this.level.addFirst(node);
                this.level = node;
            }
            if (endIndex < 0) break;
            endIndex = packageName.indexOf(46, endIndex + 1);
        }
        String cl = violation.getClassName();
        if (!this.isStringInLevel(cl)) {
            node = new ClassNode(cl);
            this.level.addFirst(node);
            this.level = node;
        }
        if (!this.equalsNodeInLevel(this.level, tmp = new ViolationNode(violation))) {
            this.level.add(tmp);
        }
    }

    private boolean equalsNodeInLevel(AbstractReportNode level, AbstractReportNode node) {
        for (int i = 0; i < level.getChildCount(); ++i) {
            if (!level.getChildAt(i).equalsNode(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isStringInLevel(String str) {
        for (int i = 0; i < this.level.getChildCount(); ++i) {
            String tmp;
            AbstractReportNode child = this.level.getChildAt(i);
            if (child instanceof PackageNode) {
                tmp = ((PackageNode)child).getPackageName();
            } else if (child instanceof ClassNode) {
                tmp = ((ClassNode)child).getClassName();
            } else {
                return false;
            }
            if (tmp == null || !tmp.equals(str)) continue;
            this.level = child;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeIterator
    implements Iterator<RuleViolation> {
        private AbstractReportNode iterNode;
        private boolean hasNextFlag;

        private TreeIterator() {
            this.iterNode = ReportTree.this.rootNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            this.hasNextFlag = true;
            return this.getNext() != null;
        }

        @Override
        public RuleViolation next() {
            if (!this.hasNextFlag) {
                this.getNext();
            } else {
                this.hasNextFlag = false;
            }
            if (this.iterNode instanceof ViolationNode) {
                return ((ViolationNode)this.iterNode).getRuleViolation();
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private AbstractReportNode getNext() {
            do lbl-1000:
            // 3 sources

            {
                block3: {
                    if (!this.iterNode.isLeaf()) break block3;
                    while ((node = this.iterNode.getNextSibling()) == null) {
                        node = this.iterNode.getParent();
                        if (node == null) {
                            return null;
                        }
                        this.iterNode = node;
                    }
                    this.iterNode = node;
                    if (!this.iterNode.isLeaf()) ** GOTO lbl-1000
                    return this.iterNode;
                }
                this.iterNode = this.iterNode.getFirstChild();
            } while (!this.iterNode.isLeaf());
            return this.iterNode;
        }
    }
}

