/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath.saxon;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingleNodeIterator;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.saxon.AbstractNodeInfo;
import net.sourceforge.pmd.lang.ast.xpath.saxon.AttributeAxisIterator;
import net.sourceforge.pmd.lang.ast.xpath.saxon.DocumentNode;
import net.sourceforge.pmd.lang.ast.xpath.saxon.IdGenerator;

public class ElementNode
extends AbstractNodeInfo {
    protected final DocumentNode document;
    protected final ElementNode parent;
    protected final Node node;
    protected final int id;
    protected final int siblingPosition;
    protected final NodeInfo[] children;

    public ElementNode(DocumentNode document, IdGenerator idGenerator, ElementNode parent, Node node, int siblingPosition) {
        this.document = document;
        this.parent = parent;
        this.node = node;
        this.id = idGenerator.getNextId();
        this.siblingPosition = siblingPosition;
        if (node.jjtGetNumChildren() > 0) {
            this.children = new NodeInfo[node.jjtGetNumChildren()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = new ElementNode(document, idGenerator, this, node.jjtGetChild(i), i);
            }
        } else {
            this.children = null;
        }
        document.nodeToElementNode.put(node, this);
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public int getSiblingPosition() {
        return this.siblingPosition;
    }

    public int getColumnNumber() {
        return this.node.getBeginColumn();
    }

    public int getLineNumber() {
        return this.node.getBeginLine();
    }

    public boolean hasChildNodes() {
        return this.children != null;
    }

    public int getNodeKind() {
        return 1;
    }

    public DocumentInfo getDocumentRoot() {
        return this.document;
    }

    public String getLocalPart() {
        return this.node.toString();
    }

    public String getURI() {
        return "";
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public int compareOrder(NodeInfo other) {
        return Integer.signum(this.node.jjtGetId() - ((ElementNode)other).node.jjtGetId());
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: {
                return new Navigator.AncestorEnumeration((NodeInfo)this, false);
            }
            case 1: {
                return new Navigator.AncestorEnumeration((NodeInfo)this, true);
            }
            case 2: {
                return new AttributeAxisIterator(this);
            }
            case 3: {
                if (this.children == null) {
                    return EmptyIterator.getInstance();
                }
                return new NodeArrayIterator(this.children);
            }
            case 4: {
                return new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
            }
            case 5: {
                return new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
            }
            case 6: {
                return new Navigator.FollowingEnumeration((NodeInfo)this);
            }
            case 7: {
                if (this.parent == null || this.siblingPosition == this.parent.children.length - 1) {
                    return EmptyIterator.getInstance();
                }
                return new NodeArrayIterator(this.parent.children, this.siblingPosition, this.parent.children.length);
            }
            case 8: {
                return super.iterateAxis(axisNumber);
            }
            case 9: {
                return SingleNodeIterator.makeIterator((NodeInfo)this.parent);
            }
            case 10: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, false);
            }
            case 11: {
                if (this.parent == null || this.siblingPosition == 0) {
                    return EmptyIterator.getInstance();
                }
                return new NodeArrayIterator(this.parent.children, 0, this.siblingPosition);
            }
            case 12: {
                return SingleNodeIterator.makeIterator((NodeInfo)this);
            }
            case 13: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, true);
            }
        }
        return super.iterateAxis(axisNumber);
    }
}

