




/**
 * Last modified: Nov 05 2004
 *
 * @author Takayuki Hoshi <hoshi103@chapman.edu>
 * File: SystemCPL.java
 * 
 *
 */
 
public class SystemCPL {

	
// 	private final int FALSE = 0;
// 	private final int TRUE = 1;

// 	private final int[] truth_values = ;
	

/*
 * Translates a truth value to english
 */
	public static String truthValueToEnglish( int a ) {
			/* 1 -> True, 0 -> False CONVERSION */
			if (a == 0) {
				return "False" ;
			}
			else {
				return "True" ;
			}
	}


/*
 * [ ~x ] For any x, return ~x
 */
	public static int interpretNot( int x ) {
		if ( x == 0 ) return 1;
		else return 0;
	}

/*
 * [ x & y ] Return 1 iff  x != y != 0 (normally if x = y = 1) .
 */
	
	public static int interpretAnd( int x, int y ) {
		if ( x != 0 && y != 0 ) return 1;
		else return 0;
	}


/*
 * [ x | y ] Return 1 iff x = y = 0; otherwise, return 1
 */
	public static int interpretOr( int x, int y ) {
		if ( x == 0 && y == 0 ) return 0;
		else return 1;
	}

/*
 * [ x => y ] Return 0 iff x != 0 and y = 1; return 1 o.w. I might add that,
 * since this is the system of CPL, the implication is material.
 */
	public static int interpretImplies( int x, int y ) {
		if ( x != 0 && y == 0 ) return 0;
		else return 1;
	}

/*
 * [ x <=> y ] Return 0 iff one of them is 0 and the other is not; 1 o.w.
 */
	public static int interpretIff( int x, int y ) {
		if ( (x != 0 && y != 0) || ( x == 0 && y == 0) ) return 1;
		else  return 0;
	}

}		// end of class `SystemCPL'
