/**
 * Last modified: 2004-11-11 [18:48]1 14 2004
 *
 * @author Takayuki Hoshi <hoshi103@chapman.edu>
 * File: Replacer.java
 * 
 *
 */
/* !!: NOTE THAT THIS CLASS WORKS ONLY AFTER JDK 1.4 */
import java.util.regex.*;


public class Replacer {
	public static final boolean DEBUG = false;
	
	private int nElements;
	private String [] symbols;
	private String [] elements;
	private String original_formula = "" ;
	private String formula = "" ;
	
	public Replacer(int size) {
		nElements = size;
		symbols = new String[nElements];
		elements = new String[nElements];
	}
	
/**
 * Given a set of symbols `symbols', a set of corresponding replacement strings `elements',
 * and an original formula `original_formula':String , return a formula `formula':String, obtained
 * by replacing every symbol found in `symbols' with corresponding element in `elements' 
 */
	public String replace(String original_formula, String[] symbols, String[] replacement_strings) {
		
		symbols = symbols;
		elements = replacement_strings;
		original_formula = original_formula;
		formula = original_formula;
		
		for(int i = 0; i < symbols.length; i++) {
			/* \\b is a word boundary; needed to prevent matching, e.g., a in
			 * alpha. (I don't know why java used \\b instead of \\< and
			 * \\>.)  */
			Pattern pattern = Pattern.compile("\\b" + symbols[i] + "\\b");
			Matcher matcher = pattern.matcher( formula );
			
			formula = matcher.replaceAll( elements[i] );
			if(DEBUG) System.out.println(formula);
		}
		
		return formula;
	}
	
	public String replace(String original_formula, String[] symbols, String replacement_string) {
		
		symbols = symbols;
		String element = replacement_string;
		original_formula = original_formula;
		formula = original_formula;
		
		for(int i = 0; i < symbols.length; i++) {
			/* \\b is a word boundary; needed to prevent matching, e.g., a in
			 * alpha. (I don't know why java used \\b instead of \\< and
			 * \\>.)  */
			Pattern pattern = Pattern.compile("\\b" + symbols[i] + "\\b");
			Matcher matcher = pattern.matcher( formula );
			
			formula = matcher.replaceAll( element.substring(i, i + 1) );
			if(DEBUG) System.out.println(formula);
		}
		
		return formula;
	}
	
	
	public String replaceSingleSymbol (String original_formula, String symbol, String replacement_string) {
		formula = original_formula;
		Pattern pattern = Pattern.compile("\\b" + symbol + "\\b");
		Matcher matcher = pattern.matcher( formula );
		formula = matcher.replaceAll( replacement_string );
		if(DEBUG) System.out.println(formula);
		
		return formula;
	}
	
	public static void main(String[] args) {
		
		int nElements = 4;
		String [] symbols = { "p" , "q" , "r" , "s" , "t "};
		String [] elements = { "T" , "F" , "T" , "F", "F"  };
		String s = "p & q | r & p & s | ~ p & q | z";
		
		String formula;
		
		Replacer replacer = new Replacer(nElements);
		formula = replacer.replace( s, symbols, elements);
		System.out.println("Changed formula is: " + formula  );

// -----------------------------------------------------------------------------

		String input = "TTTFF" ;
		
		formula = replacer.replace( s, symbols, input);
		System.out.println("Changed formula is: " + formula  );



	} // end of main()
	
}		// end of class `Replacer'
