import java.util.*;

/*
 * Naive, but much faster implementation. Older version can be seen at the end of this file.
 */


/*
 * Binary relational object whose format is < some_symbol, some_integer >.
 */
public class BinaryTwoValuedRelation  {

	SortedSet sortedSet;


	public BinaryTwoValuedRelation() {
		sortedSet = new TreeSet();
	}
	
// 	public OrderedPair getOrderedPair( ) {
// 		String pair_string = "<" + symbol + "," + value + ">" ;
// 		return sortedSet.contains( pair_string );
// 	}


	public boolean contains(String symbol, String value ) {
		String pair_string = "<" + symbol + "," + value + ">" ;
		return sortedSet.contains( pair_string );
	}

	public boolean contains(OrderedPair pair ) {
		String symbol = pair.getFirst();
		String value = pair.getSecond();
		String pair_string = "<" + symbol + "," + value + ">" ;
		return sortedSet.contains( pair_string );
	}


	public boolean add(String symbol, String value ) {
		String pair_string = "<" + symbol + "," + value + ">" ;
		return sortedSet.add( pair_string );
	}

	public boolean add(OrderedPair pair  ) {
		String symbol = pair.getFirst();
		String value = pair.getSecond();
		String pair_string = "<" + symbol + "," + value + ">" ;
		return sortedSet.add( pair_string );
	}

	public boolean remove(String symbol, String value ) {
		String pair_string = "<" + symbol + "," + value + ">" ;
		return sortedSet.remove( pair_string );
	}

	public boolean remove(OrderedPair pair ) {
		String symbol = pair.getFirst();
		String value = pair.getSecond();
		String pair_string = "<" + symbol + "," + value + ">" ;
		return sortedSet.remove( pair_string );
	}

	public void printAllRelations( ) {
		for ( Iterator it = sortedSet.iterator(); it.hasNext(); ) {
			System.out.println( it.next() );
		}
	}

	public static void main(String[] args) {
		BinaryTwoValuedRelation relation = new BinaryTwoValuedRelation( );
		relation.add( "a", "0" );
		relation.add( "a", "0" );
		relation.add( "a", "0" );
		relation.add( "a", "0" );
		relation.add( "a", "1" );
		relation.add( "b", "0" );
		relation.add( "b", "0" );
		relation.add( "c", "1" );
		relation.add( "c", "1" );
		relation.add( "c", "0" );
		relation.add( "d", "1" );
		relation.add( "e", "0" );
		relation.printAllRelations();
		System.out.println(  );

		relation.remove( "a", "0" );
		relation.remove( "a", "0" );
		relation.remove( "a", "1" );
		relation.remove( "b", "0" );
		relation.printAllRelations();


	}
}




// ----------------------------------------------------------------------------

// 2004-11-09 [22:39]


// import java.util.*;

// /*
//  * Binary relational object whose format is < some_symbol, some_integer >.
//  */
// public class BinaryTwoValuedRelation  {

// 	private HashSet set;
// //  	private TreeSet set;

// 	public BinaryTwoValuedRelation() {
// 		set = new HashSet();
// // 		set = new TreeSet();
// 	}
	
// // 	public boolean contains(String symbol, int value ) {
// 	public boolean contains(String symbol, String value ) {
// 		for ( Iterator it = set.iterator(); it.hasNext(); ) {
// 			OrderedPair pair = (OrderedPair) it.next();
// 			if( symbol.equals( pair.getFirst() ) && ( value.equals( pair.getSecond() )) )
// 				return true;
// 		}
// 		return false;
// 	}
	
// 	public boolean contains(OrderedPair pair ) {
// 		String symbol = pair.getFirst();
// 		String value = pair.getSecond();
		
// 		for ( Iterator it = set.iterator(); it.hasNext(); ) {
// 			OrderedPair pair2 = (OrderedPair) it.next();
// 			if( symbol.equals( pair2.getFirst() ) && ( value.equals( pair2.getSecond() )) )
// 				return true;
// 		}
// 		return false;
// 	}


// 	public boolean add(String symbol, String value ) {
// 		if( ! contains(symbol, value) ) {
// 			OrderedPair pair = new OrderedPair(symbol, value);
// 			return set.add( pair );
// 		}
// 		return false;
// 	}

// 	public boolean add(OrderedPair pair  ) {
// 		if( ! contains(pair) ) {
// 			return set.add( pair );
// 		}
// 		return false;
// 	}

// 	public boolean remove(String symbol, String value ) {
// 		for ( Iterator it = set.iterator(); it.hasNext(); ) {
// 			OrderedPair pair = (OrderedPair) it.next();
// 			if( symbol.equals( pair.getFirst() ) && ( value.equals( pair.getSecond() )) ) {
// 				return set.remove( pair );
// 			}
// 		}
// 		return false;
// 	}

// 	public boolean remove(OrderedPair pair ) {
// 		String symbol = pair.getFirst();
// 		String value = pair.getSecond();
// 		for ( Iterator it = set.iterator(); it.hasNext(); ) {
// 			OrderedPair pair2 = (OrderedPair) it.next();
// 			if( symbol.equals( pair2.getFirst() ) && ( value.equals( pair2.getSecond() )) ) {
// 				return set.remove( pair2 );
// 			}
// 		}
// 		return false;
// // 		return set.remove( pair );
// 	}



// 	public void printAllRelations( ) {
// 		for ( Iterator it = set.iterator(); it.hasNext(); ) {
// 			OrderedPair pair = (OrderedPair) it.next();
// 			System.out.println( pair.toString() );
// 		}
// 	}

// 	public static void main(String[] args) {
// 		BinaryTwoValuedRelation relation = new BinaryTwoValuedRelation( );
// 		relation.add( "a", "0" );
// 		relation.add( "a", "0" );
// 		relation.add( "a", "0" );
// 		relation.add( "a", "0" );
// 		relation.add( "a", "1" );
// 		relation.add( "b", "0" );
// 		relation.add( "c", "1" );
// 		relation.add( "c", "0" );
// 		relation.add( "d", "1" );
// 		relation.add( "e", "0" );

// 		relation.printAllRelations();
// 		System.out.println(  );
// 		relation.remove( "a", "0" );
// 		relation.remove( "b", "0" );
		
// 		relation.printAllRelations();

		

// 		SortedSet sortedSet = new TreeSet( );
// 		sortedSet.add( "<e,0>" );
// 		sortedSet.add( "<a,1>" );
// 		sortedSet.add( "<a,0>" );
// 		for ( Iterator it = sortedSet.iterator(); it.hasNext(); ) {
// 			System.out.println( it.next() );
// 		}

// 		String s = "<a	, 1   >" ;
// 		String s2 = s.replaceAll( "\\s" , "");		// remove all white characters
// 		System.out.println( s2 );

// 	}
// }
