/*
 * Decompiled with CFR 0.152.
 */
import java.io.StringReader;
import java.util.Vector;

public class Lister {
    public static final boolean DEBUG = false;
    private PropositionalLogicParser parser;
    private Vector vector;
    private int nElements;
    private String formula = "";
    private int limit;
    private Object[] answers;
    private String[] keys;
    private String[] possibilities;
    private LogicalSystem current_system;
    private boolean table_is_constructable;
    private int nTruthValues;

    public Lister(LogicalSystem logicalSystem, String string, Vector vector, PropositionalLogicParser propositionalLogicParser) {
        this.vector = vector;
        this.nElements = vector.size();
        this.formula = string;
        this.parser = propositionalLogicParser;
        this.current_system = logicalSystem;
        this.nTruthValues = logicalSystem.getNTruthValues();
        this.table_is_constructable = this.nTruthValues != -1;
        this.limit = (int)Math.pow(this.nTruthValues, this.nElements);
        this.answers = new Object[this.limit];
        this.keys = new String[this.nElements];
        this.possibilities = new String[this.limit];
    }

    public void setFormula(String string) {
        this.formula = string;
    }

    public void sortElements(String[] stringArray) {
        StringCompare stringCompare = new StringCompare();
        Sort sort = new Sort();
        Sort.quicksort(stringArray, 0, stringArray.length - 1, stringCompare);
    }

    public void listReversed() {
        if (this.table_is_constructable) {
            int n;
            this.init();
            for (n = 0; n < this.nElements; ++n) {
                System.out.print(this.keys[n] + "\t");
            }
            System.out.println(this.formula);
            for (n = this.limit - 1; n >= 0; --n) {
                System.out.print(this.possibilities[n] + "\t");
                System.out.println(this.answers[n].toString());
            }
            System.out.println();
        } else {
            System.out.println("The current logical system doesn't support the command.");
        }
    }

    public Vector getSatisfyingTruthAssignmentsWithPropositionalAtoms() {
        this.init();
        Vector<String> vector = new Vector<String>();
        String string = "";
        if (this.possibilities != null) {
            int n;
            for (n = 0; n < this.nElements; ++n) {
                string = string + this.keys[n] + "\t";
            }
            string = string.trim();
            vector.add(string);
            for (n = 0; n < this.answers.length; ++n) {
                if (!this.current_system.trueOrFalse(this.answers[n])) continue;
                vector.add(this.possibilities[n]);
            }
            return vector;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        PropositionalLogicParser propositionalLogicParser = new PropositionalLogicParser(System.in);
        if (this.nElements == 0) {
            String string = "";
            StringReader stringReader = new StringReader(string);
            propositionalLogicParser.ReInit(stringReader);
            try {
                this.answers[0] = propositionalLogicParser.AdditiveExpression();
            }
            catch (ParseException parseException) {
                System.out.println("The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored...");
                parseException.printStackTrace();
                StringReader stringReader2 = new StringReader("");
                propositionalLogicParser.ReInit(stringReader2);
                propositionalLogicParser.ReInit(System.in);
            }
            catch (TokenMgrError tokenMgrError) {
                System.out.println("Illegal token encountered in the input formula.  Input ignored...");
                StringReader stringReader3 = new StringReader("");
                propositionalLogicParser.ReInit(stringReader3);
                propositionalLogicParser.ReInit(System.in);
            }
            catch (Exception exception) {
                System.out.println("Unexpected exception occurred during processing the input. Program exiting...");
                exception.printStackTrace();
                System.exit(-1);
            }
            propositionalLogicParser.ReInit(System.in);
        } else {
            this.keys = new String[this.nElements];
            Object object = this.vector;
            synchronized (object) {
                for (int i = 0; i < this.nElements; ++i) {
                    this.keys[i] = ((VariableEntry)this.vector.elementAt(i)).getKey();
                }
            }
            this.sortElements(this.keys);
            object = new BaseNMatrix();
            this.possibilities = ((BaseNMatrix)object).getPossibleValues(this.nTruthValues, this.nElements);
            if (this.possibilities != null) {
                String string = "";
                for (int i = this.limit - 1; i >= 0; --i) {
                    StringReader stringReader;
                    Replacer replacer = new Replacer(this.nElements);
                    string = replacer.replace(this.formula, this.keys, this.possibilities[i].replaceAll("\t", ""));
                    StringReader stringReader4 = new StringReader(string);
                    propositionalLogicParser.ReInit(stringReader4);
                    try {
                        this.answers[i] = propositionalLogicParser.AdditiveExpression();
                        continue;
                    }
                    catch (ParseException parseException) {
                        System.out.println("The input formula is ill-formed (i.e., doesn't follow the syntax).  Input ignored...");
                        parseException.printStackTrace();
                        stringReader = new StringReader("");
                        propositionalLogicParser.ReInit(stringReader);
                        propositionalLogicParser.ReInit(System.in);
                        continue;
                    }
                    catch (TokenMgrError tokenMgrError) {
                        System.out.println("Illegal token encountered in the input formula.  Input ignored...");
                        stringReader = new StringReader("");
                        propositionalLogicParser.ReInit(stringReader);
                        propositionalLogicParser.ReInit(System.in);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Unexpected exception occurred during processing the input. Program exiting...");
                        exception.printStackTrace();
                        System.exit(-1);
                    }
                }
                propositionalLogicParser.ReInit(System.in);
            } else {
                this.table_is_constructable = false;
            }
        }
    }

    public boolean isSatisfiable() {
        if (this.table_is_constructable) {
            this.init();
            for (int i = 0; i < this.answers.length; ++i) {
                if (!this.current_system.trueOrFalse(this.answers[i])) continue;
                return true;
            }
            return false;
        }
        System.out.println("The current logical system doesn't support the command.");
        System.out.println("Returning False ( value: " + this.current_system.getFalseValue().toString() + " ) instead. ");
        return false;
    }

    public boolean isValid() {
        if (this.table_is_constructable) {
            this.init();
            for (int i = 0; i < this.answers.length; ++i) {
                if (this.current_system.trueOrFalse(this.answers[i])) continue;
                return false;
            }
            return true;
        }
        System.out.println("The current logical system doesn't support the command.");
        System.out.println("Returning False ( value: " + this.current_system.getFalseValue().toString() + " ) instead. ");
        return false;
    }

    public boolean models() {
        return !this.isSatisfiable();
    }

    public static void main(String[] stringArray) {
    }
}

