/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2;

import edu.harvard.mgh.purcell.gCLINE.RestoreDataDialog;
import edu.harvard.mgh.purcell.gPLINK2.AddGenericOp;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.PLINK_Config;
import edu.harvard.mgh.purcell.gPLINK2.PLINK_Import;
import edu.harvard.mgh.purcell.gPLINK2.PLINK_Open;
import edu.harvard.mgh.purcell.gPLINK2.data.Project;
import edu.harvard.mgh.purcell.gPLINK2.forms.AlleleAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.AlleleFreq;
import edu.harvard.mgh.purcell.gPLINK2.forms.Basic;
import edu.harvard.mgh.purcell.gPLINK2.forms.CCAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.Clustering;
import edu.harvard.mgh.purcell.gPLINK2.forms.CondHaploAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.FamAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.GenFileSet;
import edu.harvard.mgh.purcell.gPLINK2.forms.HapCCAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.HapTDTAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.HaploFreq;
import edu.harvard.mgh.purcell.gPLINK2.forms.HaploPhase;
import edu.harvard.mgh.purcell.gPLINK2.forms.HardyWinEq;
import edu.harvard.mgh.purcell.gPLINK2.forms.HomozRuns;
import edu.harvard.mgh.purcell.gPLINK2.forms.IBSdist;
import edu.harvard.mgh.purcell.gPLINK2.forms.IndHetz;
import edu.harvard.mgh.purcell.gPLINK2.forms.MendelErr;
import edu.harvard.mgh.purcell.gPLINK2.forms.Merge;
import edu.harvard.mgh.purcell.gPLINK2.forms.Missing;
import edu.harvard.mgh.purcell.gPLINK2.forms.NearNeigh;
import edu.harvard.mgh.purcell.gPLINK2.forms.ProxyAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.QuantTrtInt;
import edu.harvard.mgh.purcell.gPLINK2.forms.Regression;
import edu.harvard.mgh.purcell.gPLINK2.forms.SetAssoc;
import edu.harvard.mgh.purcell.gPLINK2.forms.StratAnaly;
import edu.harvard.mgh.purcell.gPLINK2.forms.Validate;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class PlinkMenuBar
extends JMenuBar {
    private Logger logger = Logger.getLogger(PlinkMenuBar.class);
    private Project data;
    private GPLINK frame;
    private String project1;
    private String project2;
    private String project3;
    private String project4;
    private JMenu plink;
    private JMenu advplink;
    private JMenuItem config;
    private JMenuItem save;
    private JMenuItem backup;
    private JMenuItem restore;

    void setEnabledMenu() {
        boolean state = this.data != null && this.data.getLocalFolder() != null && !this.frame.getBrowseOnly();
        this.logger.info("[setEnabledMenu()] setting the items: " + state);
        this.plink.setEnabled(state);
        this.advplink.setEnabled(state);
        this.config.setEnabled(state);
        this.save.setEnabled(state);
        this.backup.setEnabled(state);
        this.restore.setEnabled(state);
    }

    private JMenu createFormsMenu() {
        this.plink = new JMenu("PLINK");
        JMenu dataMang = new JMenu("Data Management");
        this.plink.add(dataMang);
        JMenuItem filesets = new JMenuItem(GenFileSet.name);
        filesets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new GenFileSet(PlinkMenuBar.this.frame);
            }
        });
        dataMang.add(filesets);
        JMenuItem merge = new JMenuItem(Merge.name);
        merge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Merge(PlinkMenuBar.this.frame);
            }
        });
        dataMang.add(merge);
        JMenu summery = new JMenu("Summary Statistics");
        this.plink.add(summery);
        JMenuItem validate = new JMenuItem(Validate.name);
        validate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Validate(PlinkMenuBar.this.frame);
            }
        });
        summery.add(validate);
        JMenuItem miss = new JMenuItem(Missing.name);
        miss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Missing(PlinkMenuBar.this.frame);
            }
        });
        summery.add(miss);
        JMenuItem hwe = new JMenuItem(HardyWinEq.name);
        hwe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new HardyWinEq(PlinkMenuBar.this.frame);
            }
        });
        summery.add(hwe);
        JMenuItem mendel = new JMenuItem(MendelErr.name);
        mendel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new MendelErr(PlinkMenuBar.this.frame);
            }
        });
        summery.add(mendel);
        JMenuItem alleleFreq = new JMenuItem(AlleleFreq.name);
        alleleFreq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AlleleFreq(PlinkMenuBar.this.frame);
            }
        });
        summery.add(alleleFreq);
        JMenuItem hapFreq = new JMenuItem(HaploFreq.name);
        hapFreq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new HaploFreq(PlinkMenuBar.this.frame);
            }
        });
        summery.add(hapFreq);
        JMenuItem hapPhase = new JMenuItem(HaploPhase.name);
        hapPhase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new HaploPhase(PlinkMenuBar.this.frame);
            }
        });
        summery.add(hapPhase);
        JMenu strat = new JMenu("Stratification");
        this.plink.add(strat);
        JMenuItem ibs = new JMenuItem(IBSdist.name);
        ibs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IBSdist(PlinkMenuBar.this.frame);
            }
        });
        strat.add(ibs);
        JMenuItem clust = new JMenuItem(Clustering.name);
        clust.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Clustering(PlinkMenuBar.this.frame);
            }
        });
        strat.add(clust);
        JMenuItem neigh = new JMenuItem(NearNeigh.name);
        neigh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NearNeigh(PlinkMenuBar.this.frame);
            }
        });
        strat.add(neigh);
        JMenu assoc = new JMenu("Association");
        this.plink.add(assoc);
        JMenuItem alleleA = new JMenuItem(AlleleAssoc.name);
        alleleA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AlleleAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(alleleA);
        JMenuItem caseControl = new JMenuItem(CCAssoc.name);
        caseControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CCAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(caseControl);
        JMenuItem famAssoc = new JMenuItem(FamAssoc.name);
        famAssoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FamAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(famAssoc);
        JMenuItem stratAnaly = new JMenuItem(StratAnaly.name);
        stratAnaly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new StratAnaly(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(stratAnaly);
        JMenuItem qti = new JMenuItem(QuantTrtInt.name);
        qti.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new QuantTrtInt(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(qti);
        JMenuItem regress = new JMenuItem(Regression.name);
        regress.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Regression(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(regress);
        JMenuItem setAssoc = new JMenuItem(SetAssoc.name);
        setAssoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SetAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(setAssoc);
        JMenuItem haplotypeCC = new JMenuItem(HapCCAssoc.name);
        haplotypeCC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new HapCCAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(haplotypeCC);
        JMenuItem haplotypeTDT = new JMenuItem(HapTDTAssoc.name);
        haplotypeTDT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new HapTDTAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(haplotypeTDT);
        JMenuItem condHap = new JMenuItem(CondHaploAssoc.name);
        condHap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new CondHaploAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(condHap);
        JMenuItem proxy = new JMenuItem(ProxyAssoc.name);
        proxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ProxyAssoc(PlinkMenuBar.this.frame);
            }
        });
        assoc.add(proxy);
        JMenu ibdEst = new JMenu("IBD Estimation");
        this.plink.add(ibdEst);
        JMenuItem hetz = new JMenuItem(IndHetz.name);
        hetz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new IndHetz(PlinkMenuBar.this.frame);
            }
        });
        ibdEst.add(hetz);
        JMenuItem homoz = new JMenuItem(HomozRuns.name);
        homoz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new HomozRuns(PlinkMenuBar.this.frame);
            }
        });
        ibdEst.add(homoz);
        return this.plink;
    }

    private void launchOldProject(String folder) {
        File remoteConfig = new File(folder, ".remote_gPLINK");
        if (remoteConfig.exists()) {
            Properties remote = new Properties();
            try {
                remote.load(new FileInputStream(remoteConfig));
            }
            catch (FileNotFoundException e1) {
                this.logger.error("[launchOldProject()] FileNotFoundException occured when trying to load remote config file");
            }
            catch (IOException e1) {
                this.logger.error("[launchOldProject()] IOException occured when trying to load remote config file");
            }
            String remoteName = remote.getProperty("remote_folder");
            String host = remote.getProperty("host");
            String user = remote.getProperty("user");
            String port = remote.getProperty("port");
            if (remoteName != null && host != null && user != null && port != null) {
                new PLINK_Open(this.frame, folder, remoteName, host, user, port);
            } else {
                new PLINK_Open(this.frame, folder);
            }
        } else {
            new PLINK_Open(this.frame, folder);
        }
    }

    private JMenu createProjectMenu() {
        this.logger.info("[creatingProjectMenu()] Entering");
        JMenu ans = new JMenu("Project");
        JMenuItem open = new JMenuItem("Open");
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlinkMenuBar.this.logger.info("open is clicked!");
                new PLINK_Open(PlinkMenuBar.this.frame);
            }
        });
        this.save = new JMenuItem("Save");
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlinkMenuBar.this.data.saveInfo()) {
                    PlinkMenuBar.this.logger.info("save is clicked!");
                    ((PlinkMenuBar)PlinkMenuBar.this).frame.messanger.createError("Can not save information.", "createProjectMenu");
                }
            }
        });
        this.backup = new JMenuItem("Save As XML");
        this.backup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlinkMenuBar.this.data.backupInfo()) {
                    PlinkMenuBar.this.logger.info("[createProjectMenu()] Can no create backup file");
                    ((PlinkMenuBar)PlinkMenuBar.this).frame.messanger.createError("Can not backup information.", "createProjectMenu");
                }
            }
        });
        this.restore = new JMenuItem("Restore from XML");
        this.restore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new RestoreDataDialog(PlinkMenuBar.this.frame, PlinkMenuBar.this.data);
            }
        });
        this.config = new JMenuItem("Configure");
        this.config.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlinkMenuBar.this.logger.info("config is clicked!");
                new PLINK_Config(PlinkMenuBar.this.frame).makeVisible();
            }
        });
        ans.add(open);
        ans.addSeparator();
        ans.add(this.save);
        ans.add(this.backup);
        ans.add(this.restore);
        ans.addSeparator();
        ans.add(this.config);
        if (this.data != null) {
            this.project1 = this.data.getP1();
            if (this.project1 != null && !this.project1.matches("^\\s*$")) {
                ans.addSeparator();
                JMenuItem firstProject = new JMenuItem(this.project1);
                this.logger.info("adding " + this.project1);
                firstProject.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PlinkMenuBar.this.logger.info(String.valueOf(PlinkMenuBar.this.project1) + " is firing opening dialog Param:" + e.paramString() + " ID:" + e.getID());
                        PlinkMenuBar.this.launchOldProject(PlinkMenuBar.this.project1);
                    }
                });
                ans.add(firstProject);
            }
            this.project2 = this.data.getP2();
            if (this.project2 != null && !this.project2.matches("^\\s*$")) {
                JMenuItem secondProject = new JMenuItem(this.project2);
                secondProject.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PlinkMenuBar.this.logger.info(String.valueOf(PlinkMenuBar.this.project2) + " is firing opening dialog");
                        PlinkMenuBar.this.launchOldProject(PlinkMenuBar.this.project2);
                    }
                });
                ans.add(secondProject);
            }
            this.project3 = this.data.getP3();
            if (this.project3 != null && !this.project3.matches("^\\s*$")) {
                JMenuItem thirdProject = new JMenuItem(this.project3);
                thirdProject.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PlinkMenuBar.this.logger.info(String.valueOf(PlinkMenuBar.this.project3) + " is firing opening dialog");
                        PlinkMenuBar.this.launchOldProject(PlinkMenuBar.this.project3);
                    }
                });
                ans.add(thirdProject);
            }
            this.project4 = this.data.getP4();
            if (this.project4 != null && !this.project4.matches("^\\s*$")) {
                JMenuItem forthProject = new JMenuItem(this.project4);
                forthProject.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PlinkMenuBar.this.logger.info(String.valueOf(PlinkMenuBar.this.project4) + " is firing opening dialog");
                        PlinkMenuBar.this.launchOldProject(PlinkMenuBar.this.project4);
                    }
                });
                ans.add(forthProject);
            }
        }
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlinkMenuBar.this.logger.info("GPLINK is closing (1)");
                if (PlinkMenuBar.this.data != null) {
                    PlinkMenuBar.this.data.properClosing();
                }
                System.exit(0);
            }
        });
        ans.addSeparator();
        ans.add(exit);
        return ans;
    }

    private JMenu createAdvMenu() {
        this.advplink = new JMenu("Advanced");
        JMenuItem importOp = new JMenuItem("Import PLINK operation");
        importOp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PLINK_Import(PlinkMenuBar.this.frame, PlinkMenuBar.this.data);
            }
        });
        this.advplink.add(importOp);
        JMenuItem basicCLine = new JMenuItem("Create PLINK command");
        basicCLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Basic(PlinkMenuBar.this.frame);
            }
        });
        this.advplink.add(basicCLine);
        JMenuItem inputNonPlink = new JMenuItem("Add non-PLINK command");
        inputNonPlink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new AddGenericOp(PlinkMenuBar.this.frame);
            }
        });
        this.advplink.add(inputNonPlink);
        return this.advplink;
    }

    public PlinkMenuBar(GPLINK givenFrame) {
        this.logger.info("[PlinkMenuBar(GPLINK)] Entering...");
        this.data = givenFrame.data;
        this.frame = givenFrame;
        this.add(this.createProjectMenu());
        this.add(this.createFormsMenu());
        this.add(this.createAdvMenu());
        this.setEnabledMenu();
        this.add(Box.createHorizontalGlue());
        JMenuItem about = new JMenuItem("About");
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((PlinkMenuBar)PlinkMenuBar.this).frame.messanger.createMessage("gPLINK vs" + ((PlinkMenuBar)PlinkMenuBar.this).frame.version + "\n Released under GNU GPLv2\n" + " Writen by: Kathe Todd-Brown, Shaun Purcell\n" + "http://pngu.mgh.harvard.edu/~purcell/plink/", "");
            }
        });
        about.setMaximumSize(new Dimension(about.getPreferredSize().width, about.getMaximumSize().height));
        this.add(about);
        this.logger.info("[PlinkMenuBar(GPLINK)] ...exiting");
    }
}

