/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE;

import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.general.GCFileChooser;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LinkNewFileDialog
extends JDialog {
    private Record data;
    private String opName;
    private JTextField addFile;
    private JRadioButton infile;
    ActionListener process = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            if (LinkNewFileDialog.this.addFile.getText().equals("") || LinkNewFileDialog.this.addFile.getText().matches("\\s")) {
                LinkNewFileDialog.this.dispose();
            }
            String fileType = LinkNewFileDialog.this.infile.isSelected() ? "input" : "output";
            LinkNewFileDialog.this.data.getOp(LinkNewFileDialog.this.opName).addFile(fileType, LinkNewFileDialog.this.addFile.getText(), "", "");
            LinkNewFileDialog.this.dispose();
        }
    };
    ActionListener cancel = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            LinkNewFileDialog.this.dispose();
        }
    };

    private JPanel createFilePane() {
        JPanel filePane = new JPanel();
        this.addFile = new JTextField(10);
        filePane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        filePane.add((Component)this.addFile, c);
        c.weightx = 0.0;
        c.gridx = 1;
        filePane.add(new BrowseButton(this.addFile));
        return filePane;
    }

    private JPanel createInOutPane() {
        JPanel inOutPane = new JPanel();
        this.infile = new JRadioButton("Input file");
        this.infile.setSelected(true);
        JRadioButton outfile = new JRadioButton("Output file");
        ButtonGroup pickOne = new ButtonGroup();
        pickOne.add(this.infile);
        pickOne.add(outfile);
        inOutPane.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 2;
        inOutPane.add((Component)new JLabel("Link to: " + this.opName), c);
        c.weightx = 0.5;
        c.gridwidth = 1;
        c.gridy = 1;
        inOutPane.add((Component)this.infile, c);
        c.gridx = 1;
        inOutPane.add((Component)outfile, c);
        return inOutPane;
    }

    private JPanel createButtonPane() {
        JPanel buttonPane = new JPanel();
        JButton ok = new JButton("Ok");
        ok.addActionListener(this.process);
        JButton quit = new JButton("Cancel");
        quit.addActionListener(this.cancel);
        buttonPane.add(ok);
        buttonPane.add(quit);
        return buttonPane;
    }

    public LinkNewFileDialog(StartFrame mf, Record d, String given_opName) {
        super((Frame)mf, "Link New File to " + given_opName);
        this.data = d;
        this.opName = given_opName;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(this.createFilePane());
        this.getContentPane().add(this.createInOutPane());
        this.getContentPane().add(this.createButtonPane());
        this.pack();
        this.setVisible(true);
    }

    private class BrowseButton
    extends JButton {
        private String suffex;
        private String suffexDisc;
        private JTextField target;
        private GCFileChooser pick;

        BrowseButton(JTextField givenTarget) {
            super("Browse");
            this.target = givenTarget;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowseButton.this.pick = new GCFileChooser(LinkNewFileDialog.this, null, !LinkNewFileDialog.this.data.isRemote(), false, LinkNewFileDialog.this.data.getConn(), LinkNewFileDialog.this.data.getHomeFolder());
                    BrowseButton.this.pick.addFileChoosenListener(new GCFileChooser.FileChoosenListener(this){
                        final /* synthetic */ 1 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public void fileChoosenOccures(GCFileChooser.FileChoosenEvent evt) {
                            BrowseButton.access$2(1.access$0(this.this$2)).setText(BrowseButton.access$1((BrowseButton)1.access$0(this.this$2)).fileName);
                        }
                    });
                    BrowseButton.this.pick.showChooser();
                }

                static /* synthetic */ BrowseButton access$0(1 var0) {
                    return var0.BrowseButton.this;
                }
            });
        }

        static /* synthetic */ JTextField access$2(BrowseButton browseButton) {
            return browseButton.target;
        }
    }
}

