<?php
//Bulgarian (UTF-8)

//the above line is needed so that pivot knows how to display it in the user info.
//it also needs to be on the 2nd line.

// Bulgarian translation of Pivot lang file
// Created by Vladimir Velikov (vlado@gradina.net)
// http://vlado.gradina.net

// allow for different encoding for non-western languages
$encoding="utf-8";
$langname="bg";


//		General		\\
$lang['general'] = array (
	'yes' => 'Да',	//affirmative
	'no' => 'Не',		//negative
	'go' => 'Нататък',	//proceed

	'minlevel' => 'Нямате достъп до тази секция!',	
	'email' => 'e-mail',			
	'url' => 'URL',
	'further_options' => "Допълнителни настройки",
	'basic_view' => "Съкратен изглед",
	'basic_view_desc' => "Покажи само стандартните полета",
	'extended_view' => "Разширен изглед",
	'extended_view_desc' => "Покажи всички полета",
	'select' => "Избери",
	'cancel' => "Отмени",
	'delete' => 'Изтрий',
	'welcome' => "Добре дошли в %build%.",
	'write' => "Писане",
	'write_open_error' => "Грешка при записването. Файлът не може да бъде отворен за писане.",
	'write_write_error' => "Грешка при записването. Във файла не може да бъде писано.",
	'done' => "Готово!",
	'shortcuts' => "Директни връзки",
	'cantdelete' => "Нямате права за триене на %title%!",
	'cantdothat' => "Нямате права за тази операция върху %title%!",
);


$lang['userlevels'] = array (
		'Главен администратор', 'администратор', 'доверен', 'обикновен потребител', 'мобиблогър'
		//  this one might be a bit hard to translate, but basically it's an order of
		//  power or trust.  Superadmin would be the person in charge - no one can do
		//  anything about his decisions. Admin is only regulated by the Superadmin, 
		//  Advanced by the Admin and Superadmin, etc..
		//  Just get the idea of it.
);


$lang['numbers'] = array (
	'нула', '1', '2', 'три', 'четири', 'пет', 'шест', 'седем', 'осем', 'девет', 'десет', 'единайсет', 'дванайсет', 'тринайсет', 'четиринайсет', 'петнайсет', 'шестнайсет'
);


$lang['months'] = array (
	'януари', 'февруари', 'март', 'април', 'май', 'юни', 'юли', 'август', 'септември', 'октомври', 'ноември', 'декември'
);	

		
$lang['months_abbr'] = array (
	'яну', 'фев', 'мар', 'апр', 'май', 'юни', 'юли', 'авг', 'септ', 'окт', 'нов', 'дек'
);


$lang['days'] = array (
	'неделя', 'понеделник', 'вторник', 'сряда', 'четвъртък', 'петък', 'събота'
);


$lang['days_abbr'] = array (
	'нед', 'пон', 'вто', 'сря', 'чет', 'пет', 'съб'	
);


$lang['days_calendar'] = array (
	'н', 'п', 'в', 'с', 'ч', 'п', 'с'
); 


$lang['datetime_words'] = array (
	'година', 'месец', 'седмица', 'ден', 'час', 'минута', 'секунда'	//the actual words for them.
);


//		Login Page		\\
$lang['login'] = array (
	'title' => 'Идентификация',
	'name' => 'потребител',
	'pass' => 'парола',
	'remember' => 'запомни ',
	'rchoice' => array (
		'0' => 'нищо',
		'1' => 'моето потребителско име и парола',
		'2' => 'че искам да остана идентифициран.'
	),
	'delete_cookies_desc' => 'В случай, че сте сигурен/a, че сте въвели правилно потребителското име и паролата си,<br />но въпреки това имате проблеми с идентификацията, опитайте отново след като изтриете cookie-тата от този domain!',
	'delete_cookies' => 'Изтрий cookie-тата!',
	'retry' => 'Неправилно потребителско име и/или парола',
	'banned' => 'Направихте 10 погрешни опита за идентификация. В резултат от това достъпът от вашия IP-адрес ще бъде забранен в следващите 12 часа.',

);


//		Main Bar		\\
	$lang['userbar'] = array (
	'main' => 'Преглед',
	'entries' => 'Статии',
	'submit' => 'Нова статия',
	'comments' => 'Коментари',
	'modify' => 'Редактиране на коментарите',
	'userinfo' => 'Лична информация',
	'u_settings' => 'Лични настройки',
	'u_marklet' => 'Bookmarklets',
	'files' => 'Медиатека',
	'upload' => 'Upload',
	'stats' => 'Статистики',
	'admin' => 'Администрация',

	'main_title' => 'Общ преглед',
	'entries_title' => 'Преглед на статиите',
	'submit_title' => 'Писане и публикуване на статия',
	'comments_title' => 'Редактиране и триене на коментари',		
	'modify_title' => 'Редактиране на статия',
	'userinfo_title' => 'Покажи личната информация',
	'u_settings_title' => 'Редактиране на личните настройки',
	'u_marklet_title' => 'Създаване на Bookmarklet-и',
	'files_title' => 'Медиатека',
	'upload_title' => 'Upload',
	'uploaded_success' => 'Файлът беше upload-нат успешно',
	'stats_title' => 'Покажи log-ове и статистики',
	'updatetitles_title' => 'Покажи log-ове и статистики.',
	'admin_title' => 'Администрация - преглед',
	'recent_entries' => 'Последни статии',
	'recent_comments' => 'Последни коментари',
);


$lang['adminbar'] = array (
	//		Admin Bar		\\
	//'trebuild' => 'Rebuild all Files', rolled into maintenance
	'seeusers' => 'Потребители',
	'seeconfig' => 'Текущи настройки',
	'filemappings' => 'Основни файлове',
	'templates' => 'Визуализации',
	'maintenance' => 'Поддръжка',
	'regen' => 'Ре-генериране',
	'blogs' => 'Уеблогове',
	'categories' => 'Категории',
	'verifydb' => 'Проверка на базата данни',
	'buildindex' => 'Ре-генерирай индекса',
	'buildsearchindex' => 'Ре-генерирай на индекса за търсене',
	'buildfrontpage' => 'Ре-генерирай началните страници',
	'sendping' => 'Изпрати ping-ове',


	'backup' => 'Резервни копия',
	'description' => 'Описание',
	'conversion' => 'Преобразуване',
	'seeusers_title' => 'Създаване, редактиране и триене на потребители',
	'userfields' => 'Полета за потебителски данни',
	'userfields_title' => 'Създаване, редактиране и триене на полетата за потребителски данни',
	'seeconfig_title' => 'Редактиране на конфигурационния файл',
	'filemappings_title' => 'Преглед на файловете създадени от уеблоговете.',
	'templates_title' => 'Създаване, редактиране и триене на визуализации',
	'maintenance_title' => 'Профилактика на файловете',
	'regen_title' => 'Ре-генерирай файловете създавани от системата',
	'blogs_title' => 'Създаване, редактиране и триене на уеблогове',
	'blogs_edit_title' => 'Редактиране на настройките на уеблог ',
	'categories_title' => 'Създаване, редактиране и триене на категории',	
	'verifydb_title' => 'Провери консистентността на базата данни ',
	'buildindex_title' => 'Ре-генерирай индекса на базата данни',
	'buildsearchindex_title' => 'Ре-генерирай индекса за търсене включвайки статиите',
	'buildfrontpage_title' => 'Ре-генерирай началната станица, последните архиви и RSS-файлове за всеки от уеблоговете.',
	'backup_title' => 'Направи резервни копия на статиите',
	'backup_config' => 'Резервни копия на конфигурационните файлове',
	'backup_config_desc' => 'Тук имате възможност да свалите zip-файл с копие на конфигурационните файлове',
	'ipblocks' => 'Блокирани IP-адреси',
	'ipblocks_title' => 'Преглед и редакция на блокираните IP-адреси',
	'ipblocks_stored' => 'IP-адресите бяха запазени',
	'ipblocks_store' => 'Запази тези IP-адреси',
	'ignoreddomains' => 'Игнорирани domain-и',
	'ignoreddomains_title' => 'Преглед и редакция на игнорираните domain-и',
	'ignoreddomains_stored' => 'Игнорираните domain-и бяха запазени',
	'ignoreddomains_store' => 'Запази тези игнорирани domain-и',
	'fileexplore' => 'Файлов мениджър',
	'fileexplore_title' => 'Преглед на файловете (текстови и бази данни)',
	'sendping_title' => 'Изпрати ping-ове до Request-Tracker-ите',
	'buildindex_start' => 'Генериране на индекса. Процесът може да отнеме известно време, моля не прекъсвайте!',
	'buildsearchindex_start' => 'Генериране на индекса за търсене. Процесът може да отнеме известно време, моля не прекъсвайте!',
	'buildindex_finished' => 'Готово! Генерирането на индекса отне %num% секунди',

	'filemappings_desc' => 'По-долу можете да видите преглед на всеки от уеблоговете в инсталацията, включително файловете създавани от системата и вузуализациите, използвани за създаването на тези файлове. Можете да използвате тази функционалност за откриване на причините, когато имате проблеми със създаването на файловете.',

);


$lang['templates'] = array (
	'rollback' => 'Възстановяване на предишна версия.',
	'create_template' => 'Създаване на визуализация',
	'create_template_info' => 'Създаване на нова визуализация',
	'no_comment' => 'Няма коментари',
	'comment' => 'Коментар*',
	'comment_note' => '(*Забележка: Коментари могат да бъдат запазвани единствено при <b>първо</b> запазване на промените или създаване.)',
	'create' => 'Създай визуализация',
	'editing' => 'Редактиране',
	'filename' => 'Име на файла',
	'save_changes' => 'Запази промените!',
	'save_template' => 'Запази визуализацията!',		
);


//		Admin			\\
// bob notes: Mark made these, i think they should be replaced by the 'adminbar']['xxx_title'] ones
$lang['admin'] = array (
	'seeusers' => 'Създаване, редатктиране и триене на потребители',
	'seeconfig' => 'Редактиране на конфигурационния файл',
	'templates' => 'Създаване, редатктиране и триене на визуализации',
	'maintenance' => 'Профилактика на файловете (например \'Ре-генериране на файловете\', \'Проверка на консистентността на базата данни\', \'Ре-генериране на индекса\' и \'Резервни копия\'.',
	'regen' => 'Ре-генериране на всички файлове, създавани от системата',
	'blogs' => 'Създаване, редактиране и триене на различните уеблогове, поддържани от системата',
);


//		Maintenace		\\	
$lang['maint'] = array (
	'title' => 'Поддръжка',	
	'gen_arc_title' => 'Генериране на архиви', /* bob notes: redundant, see 'regen' */
	'gen_arc_text' => 'Ре-генериране на всички архиви', /* bob notes: redundant, see 'regen' */
	'xml_title' => 'Проверка на базата данни', /* bob notes: replace with more general 'Verify DB' */
	'xml_text' => 'Проверка на коснистентността на базата данни', /* bob notes: replace with more general 'Verify DB' */
	'backup_title' => 'Резервни копия',
	'backup_text' => 'Създаване на копя на всичко важни файлове',
);


//		Stats and referers		\\
$lang['stats'] = array (
	'show_last' => "Покажи последния",
	'20ref' => "20 референции",
	'50ref' => "50 референции",
	'allref' => "всички референции",
	'showunblocked' => "само non-blocked редове",
	'showall' => "blocked и non-blocked редове",
	'updateref' => "Update the referer to title mappings",
	'hostaddress' => 'Адрес на сървъра (IP-адрес)', 
	'whichpage' => 'Which page',

	'getting' => 'Getting new titles',
	'awhile' => 'This could take a while, please don\'t interrupt.',
	'firstpass' => 'First pass',
	'secondpass' => 'Second pass',
	'nowuptodate' => 'Your referer-title mappings are now up to date.',
	'finished' => 'Finished',
);


//		User Info		\\
	$lang['userinfo'] = array (
	'editfields' => 'Редактиране на полетата за информация за потребителя',
	'desc_editfields' => 'Редактиране на полетата, които потребителите могат да използват, за да опишат себе си',
	'username' => 'Потребителско име',
	'pass1' => 'Парола',
	'pass2' => 'Парола (потвърждение)',
	'email' => 'E-mail',
	'userlevel' => 'Ниво на достъп',	
	'userlevel_desc' => 'Нивото на достъп определя позволените за потребителя действия.',
	'language' => 'Език',	
	'lastlogin' => 'Последно посещение',
	'edituser' => 'Редактиране на потребителя',  //the link to.. well, edit the user (also the title)
	'edituserinfo' => 'Редактиране на информацията за потребителя',
	'newuser' => 'Създаване на нов потребител',
	'desc_newuser' => 'Създаване на нова регситрация, позволяваща пускане на статии.',
	'newuser_button' => 'Създай!',
	'edituser_button' => 'Промени!',
	'pass_too_short' => 'Паролата трябва да се състои от най-малко 4 знака.',
	'pass_equal_name' => 'Паролата трябва да се различава от потребителското име.',
	'pass_dont_match' => 'Паролата и потвърждението й не съвпадат.',
	'username_in_use' => 'Избраното потребителско име е вече регистрирано.',
	'username_too_short' => 'Потребителското име трябва да се състои от най-малко 3 знака.',
	'username_not_valid' => 'Потребителското име може да се състои само от латински букви (а до z), цифри (0 до 9) и долни черти (_).',
	'not_good_email' => 'Въведеният e-mail-адрес не е валиден.',	
	'c_admin_title' => 'Потвърдете създаването на потребител с администраторски права.',
	'c_admin_message' => ''.$lang['userlevels']['1'].'ът има пълни права над системата, може да редактира всички нови статии, потребители и коментари, както и да променя всички настройки. Сигурен/а ли сте, че искате да създадете %s '.$lang['userlevels']['1'].'?',
);


//		Config Page		\\		
	$lang['config'] = array (
	'save' => 'Запази настройките',

	'sitename' => 'Име на сайта',
	'defaultlanguage' => 'Основен език',
	'defaultencoding' => 'Кодиране (encoding)',
	'defaultencoding_desc' => 'Тази настройка определя използването от системата кодиране (encoding). (Например utf-8 или cp-1251). Оставете полето празно, освен ако не сте сигурен/а в това, което вършите. В случай, че оставите полето празно, кодирането ще бъде избрано автоматично.',
	'siteurl' => 'URL на сайта (пример - http://gradina.net)',
	'header_fileinfo' => 'Информация за файла',
	'localpath' => 'Локален път',
	'debug_options' => 'Debug-настройки',
	'debug' => 'Debug-метод',
	'debug_desc' => 'Показвай debug-информация (навсякъде)',
	'log' => 'Log-ове',
	'log_desc' => 'Пази log-ове за различните събития',

	'unlink' => 'Прекъсване на връзката между файловете',
	'unlink_desc' => 'На някои сървъри с активиран safe_mode, промяната на тази настройка може да е от полза, но за по-голямата част тя е без значение.',
	'chmod' => 'Промяна на правата над файловете (chmod) във',
	'chmod_desc' => 'Някои сървъри изискват създадените файлове да са с определени права (chmod). Най-често правилните настройки са \'0644\' и \'0755\'. Не променяйте, освен ако не сте сигурен/а в това, което вършите.',
	'header_uploads' => 'Upload-настройки',
	'upload_path' => 'Път до мястото на upload',	
	'upload_accept' => 'Разрешени типове',			
	'upload_extension' => 'Разширение по подразбиране',
	'upload_save_mode' => 'Заместване',
	'make_safe' => '\"Почистване\" на името',
	'c_upload_save_mode' => 'Номериране на името на файла',
	'max_filesize' => 'Максимален размер',
	'header_datetime' => 'Дата/Час',
	'timeoffset_unit' => 'Времева единица',
	'timeoffset' => 'Изместване на времето с',
	'header_extra' => 'Допълнителни настройки',
	'wysiwyg' => 'Използвай визуален редактор (Wysiwyg)',
	'wysiwyg_desc' => 'Тази настройка определя дали визуалният редактор (Wysiwyg) е активиран по подразбиране. Отделните потребители могат да я променят в секцията \'Моите настройки\'',
	'basic_view' => 'Използвай нормален изглед',
	'basic_view_desc' => 'Тази настройка определя дали  \'Нова статия\' да се отваря в нормален или в разширен изглед.',
	'def_text_processing' => 'Основен метод на обработка на текста', 
	'text_processing' => 'Обработка на текста',
	'text_processing_desc' => 'Тази настройка определя основния метод на обработка на текста, в случай че потребителят не използва визуалния редактор. \'Конвертирай новите редове\' променя всеки нов ред в &lt;br&gt;-tag. <a href="http://www.textism.com/tools/textile/" target="_blank">Textile</a> е мощен и същевременно лесен за употреба markup-стил.',
	'none' => 'Никакъв',
	'convert_br' => 'Конвертирай новите редове в &lt;br /&gt;',
	'textile' => 'Textile',

	'allowed_cats' => 'Разрешени категории',
	'allowed_cats_desc' => 'Избраният потребител има права да пуска статии в маркираните категории.',
	'delete_user' => "Изтрий потребителя",
	'delete_user_desc' => "Ако желаете можете да изтриете този потребител. След това достъпът му до системата става невъзможен, но статиите и коментарите му, пуснати до момента, остават.",
	'delete_user_confirm' => 'На път сте да забраните достъпа до системата на %s. Сиурен/а ли сте?',
	
	'setup_ping' => 'Настройки на Ping-овете',
	'ping_use' => 'Изпрати ping до сървърите, следящи за актуализации (update trackers)',
	'ping_use_desc' => 'Тази настройка определя дали сървърите, следящи за актуализации (update trackers) като например weblogs.com ще бъдат автоматично известени от системата, когато пуснете нова статия. Услуги от типа на blogrolling.com зависят от тези ping-ове.',	
	'ping_urls' => 'URL-и, към които да бъдат изпращани ping-ове',
	'ping_urls_desc' => 'Можете да зададете повече от един URL. Не задавайте представката http://. В противен случай настройката няма да функционира. Просто поставете всеки URL на отделен ред или го разделете от останалите чрез pipe (вертикална черта - | ). По-известни примерни сървъри са:<br /><b>rpc.weblogs.com/RPC2</b> (сървър, изпращащ ping-ове до weblogs.com, най-широко разпространеният update tracker)<br /><b>pivotlog.net/pinger</b> (сървър, изпращащ ping-ове до pivotlog, който все още не е пуснат в действие)<br /><b>rcs.datashed.net/RPC2</b> (сървър изпращащ ping-ове до euro.weblogs.com )<br /><b>ping.blo.gs</b> (сървър изпращащ ping-ове до blo.gs)<br />',

	'setup_tb' => 'Настройки на референциите',
	'tb_password' => 'Парола',
	'tb_password_desc' => 'Тази парола се използва за идентификация при триене на референции. В случай че не е конфигурирана, триенето на референции не е възможно.',
	'tb_email' => 'E-mail',
	'tb_email_desc' => 'В случай че зададете адрес, на него ще бъде изпращано известие при всяка добавена референция.',
	'tb_rss' => 'Генерирай RSS за референциите',

	'new_window' => 'Отваряй линковете в нов прозорец',
	'emoticons' => 'Използвай emoticons (smileys)',
	'javascript_email' => 'Кодиране на е-mail-адреса',	
	'new_window_desc' => 'Тази настройка определя дали всички линкове, използвани в статиите, ще се отварят в нов прозорец.',

	'mod_rewrite' => 'Използвай Mod_rewrite',
	'mod_rewrite_desc' => 'В случай че използвате Mod_rewrite опцията на Apache, системата  ще генерира URL-и по образеца www.mysite.com/archive/2003/05/30/nice_weather, вместо по образеца www.mysite.com/pivot/entry.php?id=134. Тази опция не се поддържа от всички сървъри, за това моля информрайте се за това в документацията на вашия сървър.',

	'search_index' => 'Автоматична актуализация на индекса за търсене',
	'search_index_desc' => 'Тази настройка определя дали индексът за търсене ще се актуализира автоматично винаги, когато пускате нова статия или редактирате вече съшествуваща такава.',

	'default_allow_comments' => 'Коментарите са разрешени по подразбиране',
	'default_allow_comments_desc' => 'Тази настройка определя дали статиите позволяват пускането на коментари по тях.',	

  'maxhrefs' => 'Брой на линковете',
  'maxhrefs_desc' => 'Максимален брой на линковете във всеки коментар. Тази настройка е полезна за борба със spam-коментарите.',
  'rebuild_threshold' => 'Пауза при ре-генериране',
  'rebuild_threshold_desc' => 'Времето (в секунди), което трае ре-генерирането преди системата да актуализира сраницата. Стойността по подразбиране е 28, но в случай, че имате проблеми  при ре-генериране, опитайте да я намалите на 10.',
	'default_introduction' => 'Default Introduction/Body',
	'default_introduction_desc' => 'This will determine the default values for Introduction and Body when an author writes a new entry. Normally this will be an empty paragraph, which makes the most sense semantically.',

	'upload_autothumb'	=> 'Автоматично създаване на умалени версии на графичните файлове (Thumbnails)',
	'upload_thumb_width' => 'ширина на умалените версии',
	'upload_thumb_height' => 'ширина на умалените версии',
	'upload_thumb_remote' => 'Външен script',
	'upload_thumb_remote_desc' => 'В случай че сървърът ви не разполага с функции за умаляване на графични файлове, тук можете да въведете адреса на външен script, който да изпълнява тази задача.',

	'extensions_header' => 'Директория за допълнителни модули',
	'extensions_desc'   => 'Това е мястото, където можете да поставяте допълнителни модули.
		Това улеснява актуализацията на системата. За повече информация погледнете документатцията.',
	'extensions_path'   => 'Път до директорията за допълнителни модули',

);


//		Weblog Config	\\
$lang['weblog_config'] = array (
	'edit_weblog' => 'Редакция на Уеблоговете',
	'edit_blog' => 'Редакция на Уеблоговете',
	'new_weblog' => 'Нов Уеблог',
	'new_weblog_desc' => 'Добавяне на нов Weblog',
	'del_weblog' => 'Триене на Weblog',
	'del_this_weblog' => 'Изтриване на текущия Weblog.',
	'create_new' => 'Създаване на нов Weblog',
	'subw_heading' => 'За всеки от subweblog-овете, които се намират във визуализацииите, можете да настроите използванат визуализация, както и кои категории да бъдат публикувани в тях.',
	'create' => 'Завърши!',
	
	'create_1' => 'Създаване / Редактиране на  Weblog, стъпка 1 от 3',
	'create_2' => 'Създаване / Редактиране на  Weblog, стъпка 2 от 3',
	'create_3' => 'Създаване / Редактиране на  Weblog, стъпка 3 от 3',

	'name' => 'Заглавие (име) на Weblog-а',
	'payoff' => 'Подзаглавие',
	'payoff_desc' => 'Подзаглавието може да бъде използвано и като кратко описание на вашия Weblog',
	'url' => 'URL на Weblog-а',
	'url_desc' => 'Системата ще определи автоматично url-адреса на weblog-a, ако оставите това поле непопълнено. В случай че използвате weblog-a си като част от frameset, или като serverside include, можете да използвате тази настройка, за да промените автоматично разпознатата стойност.',
	'index_name' => 'Начална страница (Index)',
	'index_name_desc' => 'Името на файлът представляващ началната страница. Обикновено е нещо от типа \'index.html\' или \'index.php\'.',

	'ssi_prefix' => 'SSI представка (SSI Prefix)',
	'ssi_prefix_desc' => 'В случай че  weblog-ът използва SSI (което не е препоръчително), можете да използвате тази настройка за да поставите представка пред имената на файловете на ситемата. Например. \'index.shtml?p=\'. Оставете полето празно, освен ако не сте сигурен/а в това, което вършите!',

	'front_path' => 'Път до началната страница',
	'front_path_desc' => 'Относителният или абсолютен път до директорията, в която системата трява да създава началната страница на този weblog.',
	'file_format' => 'Име на файла',
	'entry_heading' => 'Настройки за статиите',
	'entry_path' => 'Път до статиите',
	'entry_path_desc' => 'Относителният или абсолютен път до директорията, в която системата трява да създава файловете на отделните статии. (в случай че решите да не използвате \'Динамични статии\')',
	'live_comments' => 'Динамични статии',
	'live_comments_desc' => 'В случай че използвате  \'Динамични статии\', няма да се налага системата да генерира файл за всяка една статия. Това е предпочитаната настройка.',
	'readmore' => 'Текст \'прочети цялата статия\'',
	'readmore_desc' => 'Текстът, който ше бъде използван за индикация, че статията съдържа повече текст отколкото е показан на началната страница. В случай, че оставите това поле празно, системата ще използва текста, дефиниран по подразбиране в езиковия файл.',
	
	'arc_heading' => 'Настройки на архивите',
	'arc_index' => 'Index-файл',
	'arc_path' => 'Път до архивите',
	'archive_amount' => 'Количество на  архивите',
	'archive_unit' => 'Тип на архивите',
	'archive_format' => 'Формат на архивите',
	'archive_none' => 'Без архиви',
	'archive_weekly' => 'Седмични архиви',
	'archive_monthly' => 'Месечни архиви',
	'archive_yearly' => 'Годишни архиви',

	'archive_link' => 'Link към архивите',
	'archive_linkfile' => 'Формат на списъка на архивите',	
	'archive_order' => 'Ред на архивите',
	'archive_ascending' => 'Възходящ (първо най-старите)',
	'archive_descending' => 'Descending (първо най-новите)',

	'templates_heading' => 'Визуализации',
	'frontpage_template' => 'Визуализация на началната страница',
	'frontpage_template_desc' => 'Визуализацията, която определя външния вид на началната страница на weblog-a.',
	'archivepage_template' => 'Визуализация на страницата с архивите',
	'archivepage_template_desc' => 'Визуализацията, която определя външния вид на страницата на архивите. Може да бъде същата като визуализацията на началната страница.',	
	'entrypage_template' => 'Визуализация на страниците на статиите',
	'entrypage_template_desc' => 'Визуализацията, която определя външния вид на страниците с отделните статии.',	
	'extrapage_template' => 'Допълнитена визуализация',
	'extrapage_template_desc' => 'Визуализацията, която определя как да бъдат показвани архивите и резултатите от заявки към търсачката.',

	'shortentry_template' => 'Визуализация на кратките версии на статиите',
	'shortentry_template_desc' => 'Визуализацията, която определя външния вид на отделните статии, показвани в weblog-a или в архивите.',	
	'num_entries' => 'Брой на статиите',
	'num_entries_desc' => 'Броят на статиите в този weblog, които да бъдат показвани на началната страница.',	
	'offset' => 'Скрити',
	'offset_desc' => 'В случай че въведете число, то ще представлява броя на статиите, които ще бъдат пропуснати при генериране на страницата. Можете да използвате тази настройка, за да направите (например) списък "Предишни статии".',
	'comments' => 'Коментарите са позволени',
	'comments_desc' => 'Тази настройка определя дали читателите ще могат да оставят коментари към статиите в този weblog.',	

	'publish_cats' => 'Публикувай тези категории',

	'setup_rss_head' => 'RSS и Atom настройки',
	'rss_use' => 'Генерирай Feeds',
	'rss_use_desc' => 'Тази настройка определя дали системата ще генерира автоматично RSS и Atom feed за този weblog.',
	'rss_filename' => 'Име на RSS-файла',
	'atom_filename' => 'Име на Atom-файла',
	'rss_path' => 'Път до feed-овете',
	'rss_path_desc' => 'Относителният или абсолютен път до директорията, в която системата ще създава feed-файловете.',
//	'rss_size' => 'Feed Entry Length',	/* DEPRECATED */
//	'rss_size_desc' => 'The length (in characters) of an entry in the Feed files', /* DEPRECATED */
	'rss_full' => 'Създавай пълни feed-ове',
	'rss_full_desc' => 'Тази настройка определя дали системата ще генерира пълни  Atom и RSS-feed-ове. В случай че настройката е  \'Не\', системата ще генерира feed-ове, които съдържат само кратко описание, правейки feed-овете по-малко полезни.',
	'rss_link' => 'Link във feed-овете',
	'rss_link_desc' => 'Link-ът, сочещ към главната страница, който ще бъде изпращан във feed-овете. В случай че оставите полето празно, системата ще изпраща link към началната страница.',
	'rss_img' => 'Графичен файл на на feed-овете', 
	'rss_img_desc' => 'Можете да зададете Графичен файл, който да бъде изпращан с feed-овете. Някои feed-четци ще показват файла заедно с текста. Оставете полето празно или задайте абсолютен път до файла.',
	
	'lastcomm_head' => 'Настройки за \'Последни коментари\'',
	'lastcomm_amount' => 'Брой на показваните коментари',
	'lastcomm_length' => 'Пази само последните ',
	'lastcomm_format' => 'Формат',
	'lastcomm_format_desc' => 'Тези настройки определят изгледа на секцията \'Последни коментари \' на началната страница на weblog-а.',
	'lastcomm_nofollow' => 'Използвай \'Nofollow\'',
	'lastcomm_nofollow_desc' => 'За противодействие на т. нар. refererspam тук можете да изберете да добавите rel="nofollow" атрибут на всички link-ове в коментарите референциите, тъй като това ще попречи на spam-ърите да подобрят page-rank-a си в Google.',

	'lastref_head' => 'Настройки на \'Последни референции\'',
	'lastref_amount' => 'Брой на показваните референции',
	'lastref_length' => 'Пази само последните ',
	'lastref_format' => 'Формат',
	'lastref_format_desc' => 'тези настройки определят изгледа на секцията \'Последни референции\' на началната страница на weblog-a.',
	'lastref_graphic' => 'Използвай графични изображения',
	'lastref_graphic_desc' => 'Тази настройка определя дали секцията \'Последни референции\' ще използва малки изображения за най-често срещаните търсачки, от които читателите биха могли да бъдат насочвани към weblog-а .',
	'lastref_redirect' => 'Пренасочвай референциите',
	'lastref_redirect_desc' => 'За противодействие на т. нар. refererspam тук можете да изберета да пренасочвате link-ове, сочещи към външни site-ове, тъй като това ще попречи на spam-ърите да подобрят page-rank-a си в Google.',

	'various_head' => 'Допълнителни настройки',
	'emoticons' => 'Използвай emoticon-и (smileys)',
	'emoticons_desc' => 'Тази настройка определя дали emoticon-и като :-) ще бъдат трансформирани в съответните графични еквиваленти.',
	'encode_email_addresses' => 'Кодирай е-mail-адресите',
	'encode_email_addresses_desc' => 'Тази настройка определя дали e-mail-адресите ще бъдат кодирани с javascript, за защита от spam-роботи събиращи е-mail-адреси.',
	'target_blank' => 'Отваряй всички link-ове в нов прозорец',
	'xhtml_workaround' => 'XHTML алтернатива',
	'target_blank_desc' => 'В случай че настройката ви е  \'Да\', всички link-ове в статиите ще бъдат отваряни в нов прозорец. В случай че настройката е \'XHTML алтернатива\', всички link-ове ще получават rel="external" атрибут, което щe доведе до генериране на валиден XHTML',

	'date_head' => 'Формат на датата',
	'full_date' => 'Пълен формат на датата',
	'full_date_desc' => 'Тази настройка определя пълния формат на дата и час. Най-честата употреба е най-горе в страниците на отделните статии.',
	'entry_date' => 'Дата на статията',
	'diff_date' => 'Различна дата',
	'diff_date_desc' => '\'Различна дата\' най-често се използва за във връзка с \'Дата на статията\'. \'Дата на статията\' се показва за всяка статия в weblog-a, докато \'Различна дата \' се показва само ако датата се различава от тази на предната стаия.',
	'language' => 'Език',
	'language_desc' => 'Тази настройка определя на какъв език да бъдат показвани датите и числата, както и т. нар. encoding на страницата  (например iso-8859-1 или cp-1251).',	

	'comment_head' => 'Настройки на коментарите',
	'comment_sendmail' => 'Изпрашай e-mail',
	'comment_sendmail_desc' => 'Тук можете да определите дали администраторите на този weblog да получават e-mail за всеки нов коментар.',
	'comment_emailto' => 'e-mail-адрес',
	'comment_emailto_desc' => 'Въведете e-mail-адрес/ите на които да бъде изпращан e-mail. Разделяйте адресите един от друг със запетая.',
	'comment_texttolinks' => 'Автоматични link-ове',
	'comment_texttolinks_desc' => 'Тази настройка определя дали url-адресите, в коментарите ще бъдат автоматични трансформирани в link-ове.',
	'comment_wrap' => 'Нов ред след ',
	'comment_wrap_desc' => 'За да предотвратите "разкъсването" на структурата,  можете да определите след колко знака текстът да продължава на нов ред.',
	'comments_text_0' => 'текст за  \'няма коментари\'',
	'comments_text_1' => 'текст за  \'един коментар\'',
	'comments_text_2' => 'текст за  \'X коментара\'',
	'comments_text_2_desc' => 'Текстът, който ще бъде използван за индикатор на броя на коментарите. В случай че оставите това поле непопълнено, системата ще използва текста дефиниран по подразбиране в езиковия файл.',

	'comment_pop' => 'Отваряй коментарите в нов прозорец (pop-up)',
	'comment_pop_desc' => 'Тази настройка определя дали страницата с коментарите ще буде отваряна в нов прозорец (pop-up), или ше бъде зареждана в същия.',
	'comment_width' => 'Ширина на новия прозорец (pop-up)',
	'comment_height' => 'Височина на новия прозорец (pop-up)',
	'comment_height_desc' => 'Определете ширината и височината (в пиксели) на новия прозорец (pop-up).',
			
	'comment_format' => "Формат на коментарите",
	'comment_format_desc' => "Тази настройка определя формàта на коментарите.",

	'comment_reply' => "Формат на 'Oтговор ..'",
	'comment_reply_desc' => "Тази настройка определя формàта на link-a, който потребителите могат да използват, за да отговорят на даден коментар.",
	'comment_forward' => "Формат на 'Oтговор от ..'",
	'comment_forward_desc' => "Тази настройка определя формàта на текста, който бива показван, когато на коментара е отговорено с друг коментар.",
	'comment_backward' => "Формат на  'Отговор на ..'",
	'comment_backward_desc' => "Тази настройка определя формàта на текста, който бива показван, когато коментарът е отговор на друг коментар.",
	
	'comment_textile' => 'Разреши Textile',
	'comment_textile_desc' => 'В случай че настройката Ви е \'Да\', посетителите ще могат да използват <a href="http://www.textism.com/tools/textile/" target="_blank">Textile</a> в своите коментари.',

	'saved_create' => 'Новият weblog беше успешно създаден.',
	'saved_update' => 'Weblog-ът беше успешно актуализиран.',
	'deleted' => 'Weblog-ът беше успешно изтрит.',
	'confirm_delete' => 'На път сте да изтриете weblog %1. Сигурен/а ли сте?',	

	'blogroll_heading' => 'Blogroll настройки',
	'blogroll_id' => 'Blogrolling ID #',
	'blogroll_id_desc' => 'Ако желаете можете да добавите <a href="http://www.blogrolling.com" target="_blank">blogrolling.com</a> blogroll към вашия weblog. Blogrolling отлична услуга за поддръжка на списък от link-ове, който показва, колко скоро са били актуализирани. В случай че не желаете това, можете спокойно да преминете нататък. Иначе: след като се идентофицирате в blogrolling.com, click-нете на  \'get code\' и ще намерите link-ове с вашето blogroll ID #. То би трябвало да изглежда по подобен начин: 2ef8b42161020d87223d42ae18191f6d',
	'blogroll_fg' => 'Цвят на текста',
	'blogroll_bg' => 'Цвят на фона',
	'blogroll_line1' => 'Цвят на ред 1',
	'blogroll_line2' => 'Цвят на ред 2',
	'blogroll_c1' => 'Цвят 1',
	'blogroll_c2' => 'Цвят 2',
	'blogroll_c3' => 'Цвят 3',
	'blogroll_c4' => 'Цвят 4',
	'blogroll_c4_desc' => 'Тези цветове определят как ще изглежда вашият blogroll. Цвят 1 до Цвят 4 са визуална индикация затова, колко скоро е бил актуализиран даден link.',
);


$lang['upload'] = array (
	//		File Upload		\\
	'preview' => 'Преглед на целия списък',
	'thumbs' => 'Преглед в умален размер',
	'create_thumb' => '(Създай версия с умален размер)',
	'title' => 'Файлове',
	'thisfile' => 'Upload на нов файл:',
	'button' => 'Upload',
	'filename' => 'Име на файла',
	'thumbnail' => 'Умалена версия (thumbnail)',
	'date' => 'Дата',
	'filesize' => 'Размер на файла',
	'dimensions' => 'ширина x височина',		
	'delete_title' => 'Изтрий изображението',
	'areyousure' => 'Сигурен/а ли сте, че искате да изтриете файла %s?',
	'picheader' => 'Изтрий изображението?',
	'create' => 'Създаване',
	'edit' => 'Редактиране',

	'insert_image' => 'Вмъкни изображение',
	'insert_image_desc' => 'За да вмъкнете изображение, е необходимо да upload-нете такова, или да изберете вече upload-нато.',
	'insert_image_popup' => 'Вмъкни pop-up-изображение',
	'insert_image_popup_desc' => 'За да създадето pop-up-изображение е  необходимо първо да го upload-нете, или да изберете вече upload-нато. След това да изберет текст или умалена версия (thumbnail), които да стартират pop-up-а.',
	'choose_upload' => 'upload',
	'choose_select' => 'или избор',
	'imagename' => 'Име на изображението',
	'alt_text' => 'Алтернативен текст',
	'align' => 'Подравняване',
	'border' => 'Рамка',
	'pixels' => 'пиксела',
	'uploaded_as' => 'Файлът Ви беше upload-нат като \'%s\'.',
	'not_uploaded' => 'Файлът ви не беше upload-нат поради следните грешки:',
	'center' => 'Център (по подразбиране)',
	'left' => 'вляво',
	'right' => 'вдясно',
	'inline' => 'без подравняване',		
	'notice_upload_first' => 'Необходимо е най-напред да изберете или да upload-нете някакво изображение',
	'select_image' => 'Избери изображение',
	'select_file' => 'Избери файл',

	'for_popup' => 'За pop-up',		
	'use_thumbnail' => 'Използвай умалена версия (thumbnail)',		
	'edit_thumbnail' => 'редактирай умалената версия (thumbnail)',		
	'use_text' => 'Използвай текст',		
	'insert_download' => 'Вкъкни файл за download',
	'insert_download_desc' => 'За да вмъкнете файл за download, е необходимо първо да го upload-нете или да изберет вече upload-нат. След това изберете дали желаете  icon,  текст или умалена версия (thumbnail) които да стартират download-а.',
	'use_icon' => 'Използвай icon',
);


$lang['link'] = array (
	//		Link Insertion \\
	'insert_link' => 'Вмъкни link',
	'insert_link_desc' => 'Вмъкнете link, въвеждайки url полето по-долу. Посетителите ви ще виждат заглавието, когато посочат link-а с курсора на мишката.',
	'url' => 'URL',
	'title' => 'Заглавие',
	'text' => 'Текст',
);


//		Categories		\\
$lang['category'] = array (
	'edit_who' => 'Редакция на потребителите имаши право да пишат в категория \'%s\'',
	'name' => 'Име',
	'users' => 'Потребители',
	'make_new' => 'Създаване на нова категория',
	'create' => 'Създай категорията',
	'canpost' => 'Изберете потребителите, на които желаете да разрешите да пишат в тази категория.',
	'same_name' => 'Вече съшествува категория с това име.',
	'need_name' => 'Категорията се нуждае от име.',
	
	'allowed' => 'Имащи право',
	'allow' => 'Разреши',
	'denied' => 'Нямащи право',
	'deny' => 'Забрани',
	'edit' => 'Актуализирай',
	
	'delete' => 'Изтрий категорията',
	'delete_desc' => 'Изберете \'да\', в случай че искате да изтриете тази категория',

	'delete_message' => 'В тази версия на системата ще бъде изтрито само името на категорията. В следващи версии ще можете да избирате какво да се случва със статиите в нея.',
	'search_index_newctitle'   => 'Индексирай категорията',
	'search_index_newcdesc'    => 'Изберете \'Не\' само ако искате посетителите да не могат да търсят в тази категория.',
	'search_index_editcheader' => 'Индексиране на категорията',
	
	'order' => 'Ред на подреждане',
	'order_desc' => 'Категории с по-нисък ред на подреждане ще бъдат показвани по-нагоре в списъка. Ако категориите са с еднакъв ред на подреждане, ще бъдат подреждани по азбучен ред.',
	'public' => 'Публична категория',
	'public_desc' => 'Изберете \'Не\', ако искате тази категория да е достъпна само за регистрирани потребители. (отнася се само за  "динамични страници")',
	'hidden' => 'Скрита категория',
	'hidden_desc' => 'Изберете \'Да\', ако искате тази категория да не се показва в архивите. (отнася се само за "динамични страници")',
		
);


$lang['entries'] = array (
	//		Entries			\\
	'post_entry' => "Публикувай",
	'preview_entry' => "Преглед",

	'first' => 'първа',
	'last' => 'последна',
	'next' => 'следваща',
	'previous' => 'предишна',

	'jumptopage' => 'страница (%num%)',
	'filteron' => 'филтър (%name%) активен',
	'filteroff' => 'filter неактивен',
	'title' => 'Заглавие',
	'subtitle' => 'Подзаглавие',
	'introduction' => 'Начало',
	'body' => 'Същинска част',
	'publish_on' => 'Публикувай на',
	'status' => 'Статус',
	'post_status' => 'Статус',
	'category' => 'Категория',
	'select_multi_cats' => '(Използвайте Ctrl-click, за да изберете повече от една категория)',
	'last_edited' => "Последна редакция на",
	'created_on' => "Публикувана на",		
	'date' => 'Дата',
	'author' => 'Автор',
	'code' => 'Код',
	'comm' => 'Брой коментари',
	'name' => 'Име',
	'allow_comments' => 'Разреши коментарите',

	'delete_entry' => "Изрий статията",
	'delete_entry_desc' => "Изтрийте тази статия и коментарите към нея",
	'delete_one_confirm' => "Сигурен/a ли сте, че искате да изтриете тази статия?",
	'delete_multiple_confirm' => "Сигурен/a ли сте, че искате да изтриете тези статии?",
	
	'convert_lb' => 'Преобразувай linebreak-овете',
	'always_off' => '(Тази настройка е неактивна в режим Wysiwyg)',
	'be_careful' => '(Внимавайте с това!)',
	'edit_comments' => 'Редактиране на коментарите',
	'edit_comments_desc' => 'Редактиране на коментарите към тази статия',
	'edit_comment' => 'Актуализирай',
	'delete_comment' => 'Изтрий',
	'block_single' => 'Блокирай IP %s',
	'block_range' => 'Блокирай всички IP-адреси в диапазона %s',
	'unblock_single' => 'Деблокирай IP %s',
	'unblock_range' => 'Блокирай всички IP-адреси в диапазона %s',
	'trackback' => 'Изпрати Trackback ping',
	'trackback_desc' => 'Изпратете Trackback Ping-ове до следните URL. Използвайте нов ред за всеки отделен адрес.',
	'keywords' => 'Ключови думи',
	'keywords_desc' => 'Използвайте това поле да зададете няколко ключови думи, които да бъдат използвани за намиране на тази статия от търсачката.',
	'vialink' => "Чрез link",
	'viatitle' => "Чрез заглавие",
	'via_desc' => 'Използвайте това поле, за да зададете link към файла на тази статия.',
	'entry_catnopost' => 'Нямате права за писане в категория \'%s\'.',
	'entry_saved_ok' => 'Статията \'%s\' беше успешно запазена.',
	'entry_ping_sent' => 'Trackback ping беше изпратен до \'%s\'.',
);


//		Form Fun		\\
$lang['forms'] = array (
	'c_all' => 'Маркирай всички',
	'c_none' => 'Демаркирай всичкиl',
	'choose' => '- изберете -',
	'publish' => 'Публиквай',
	'hold' => 'Скрий',
	'delete' => 'Изтрий',
	'generate' => 'Публикувай и генерирай',

	'with_checked_entries' => "Действие върху всички маркирани статии:",
	'with_checked_files' => "Действие върху всички маркирани файлове:",
	'with_checked_templates' => 'Действие върху всички маркирани визуализации:',
);


//		Errors			\\
$lang['error'] = array (
	'path_open' => 'Неуспешно отваряне на директорията, проверете правата си.',
	'path_read' => 'Неуспешно четене на директорията, проверете правата си.',
	'path_write' => 'Неуспешно писане в директорията, проверете правата си.',

	'file_open' => 'Неуспешно отваряне на файла, проверете правата си.',
	'file_read' => 'Неуспешно четене на файла, проверете правата си.',
	'file_write' => 'Неуспешно писане във файла, проверете правата си.',
);


//		Notices			\\
$lang['notice'] = array (		
	'comment_saved' => "Коментарът беше успешно запазен.",
	'comment_deleted' => "Коментарът беше успешно изтрит.",
	'comment_none' => "Няма коментари към тази статия.",
);


// Comments, Karma and voting \\
$lang['karma'] = array (
	'vote' => 'Оцени тази статия с \'%val%\'.',
	'good' => '(+)',
	'bad' => '(-)',
	'already' => 'Вече сте гласували за тази статия или анкета',
	'register' => 'Гласувахте с \'%val%\'',
);


$lang['comment'] = array (
	'register' => 'Коментарът ви беше успешно запазен.',
	'preview' => 'Това е само преглед на вашия коментар. За да го публикувате click-нете върху  \'Публикувай\'.',
	'duplicate' => 'Коментарът не беше запазен, тъй като повтаря съдържанието на публикуван преди това коментар.',
	'no_name' => 'Въведете име или псевдоним в полето \'Име\'. След това click-нете върху \'Публикувай\', за да запазите коментара.',
	'no_comment' => 'Добре е да напишете нещо в полето \'Коментар\'. След това click-нете върху \'Публикувай\', за да запазите коментара.',
	'too_many_hrefs' => 'Превишавате допустимия брой link-ове. Спрете със spam-а.',
);


$lang['comments_text'] = array (
	'0' => "Няма коментари",
	'1' => "%num% коментар",
	'2' => "%num% коментара",
);


$lang['weblog_text'] = array (
	// these are used in the weblogs, for the labels related to archives
	'archives' => "Архиви",
	'next_archive' => "Следващ архив",
	'previous_archive' => "Предишен архив",
	'last_comments' => "Последни коментари",
	'last_referrers' => "Последни референции",
	'calendar' => "Календар",
	'links' => "Връзки",
	'xml_feed' => "XML: RSS Feed",
	'atom_feed' => "XML: Atom Feed",
	'powered_by' => "Powered by",
	'name' => "Име",
	'email' => "E-mail",
	'url' => "URL",
	'date' => "Дата",		
	'comment' => "Коментар",
	'ip' => "IP-адрес",		
	'yes' => "Да",
	'no' => "Не",
	'emoticons' => "Emoticons",
	'emoticons_reference' => "Отвори справочника на Emoticon-ите",
	'textile' => "Textile",
	'textile_reference' => "Отвори справочника на Textile",
	'post_comment' => "Публикувай",
	'preview_comment' => "Преглед",
	'remember_info' => "Запомни личните данни",
	'notify' => "Известие",
	'notify_yes' => "Да, изшрати ми e-mail, когато някой отговори.",
	'register' => "Регистрация / Идентификация",
	'disclaimer' => "Всякакви HTML-тагове с изключение на  &lt;b&gt; and &lt;i&gt; ще бъдат игнорирани. Въведените url и е-mail-адреси биват преобразувани в линкове автоматично.",	
	'search_title' => "Резултати",
	'search' => "Търси!",
	'nomatches' => "Търсенето за '%name%' се оказа напразно. Опитайте с други ключови думи.",
	'matches' => "Търсенето за '%name%' даде следните резултати:",
	'about' => "За мен",
	'stuff' => "Stuff",
	'linkdump' => "Връзки",
);


$lang['ufield_main'] = array (
	//		Userfields		\\
	'title' => 'Редактиране на полетата за потребителите',
	'edit' => 'Редактиране',
	'create' => 'Създаване',

	'dispname' => 'Публично име',
	'intname' => 'Системно име',
	'intname_desc' => 'Системното име е името, което можете да задавате на системата, като референция в дадена визуализация.',
	'size' => 'Размер',
	'rows' => 'Редове',
	'cols' => 'Колони',
	'maxlen' => 'Максимална дължина',
	'minlevel' => 'Минимално ниво за достъп',	
	'filter' => 'Филтрирай по',
	'filter_desc' => 'Филтрирайки, намалявате типовете input, които могат да бъдат използвани',
	'no_filter' => 'Нищо',
	'del_title' => 'Потвърдете изтриването',
	'del_desc' => 'Изтриването на полето (<b>%s</b>) ще изтрие и всички данни, които потребителите са въвели в него и мястото, отредено във визуализациите ще остане празно.',	
	
	'already' => 'Избраното име вече е заето.',
	'int' => 'Системното име трябва да се състои от най-малко 4 знака.',
	'short_disp' => 'Публичното име трябва да се състои от най-малко 4 знака.',
);


$lang['bookmarklets'] = array (
	'bookmarklets' => 'Bookmarklets',
	'bm_add' => 'Добави Bookmarklet.',
	'bm_withlink' => 'със link',
	'bm_withlink_desc' => 'Този  bookmarklet отваря порозрец с Нова статия, съдържаща link към страницата, от която е бил отворен прозорецът.',

	'bm_nolink' => 'без link',
	'bm_nolink_desc' => 'Този  bookmarklet отваря порозрец с празна Нова статия.',

	'bookmarklets_info' => 'Можете да използвате Bookmarklet-и като пряк път за писане на нови статии. За да добавите Bookmarklet в browser-a, използвайте една от следните възможности: (в зависимост от browser-а)',
	'bookmarklets_info_1' => 'Click-нете и издърпайте bookmarklet-а в Links-toolbar-а или в Bookmarks-бутона.',
	'bookmarklets_info_2' => 'Click-нете с десния бутон върху bookmarklet-а и изберете \'Add to Bookmarks\'.',
);

// Accessibility - These are used for form fields, labels, fieldsets etc.
// for Web Content Accessibility Guidelines & 508 compliancy issues.
// see: http://bobby.watchfire.com/bobby/html/en/index.jsp
// JM =*=*= 2004/10/04
// 2004/11/25 =*=*= JM - minor correction for tim
$lang['accessibility'] = array(
	'search_idname'      => 'търсене',
	'search_formname'    => 'Търсене на статии в този сайт съдържащи зададените думи',
	'search_fldname'     => 'Въведете търсените думи тук:',
	'search_placeholder' => 'Въведете ключовите думи',

	'calendar_summary'   => 'Тази таблица представлява календар на статиите в този weblog с линкове към датите, на които са публикувани статии.',
	'calendar_noscript'  => 'Календарът предсатвлява начин за достъп до статиите в този weblog',
	/* 
	2-letter language code, used to designate the principal language used on the site
	see: http://www.oasis-open.org/cover/iso639a.html
	*/

	'lang' => $langname,
) ;


$lang['snippets_text'] = array (
    'word_plural'     => 'думи',
    'image_single'    => 'изображение',
    'image_plural'    => 'изображения',
    'download_single' => 'файл',
    'download_plural' => 'файла',
); 

$lang['trackback'] = array (
    'noid'      => 'Няма TrackBack ID (tb_id)',
    'nourl'     => 'Няма URL (url)',
    'noping'    => 'Няма ping URL',
    'tburl'     => 'TrackBack URL за тази статия',
    'delete'    => '[DELETE]',
    'yoursite'  => 'Товя вашият site ли е?',
    'todelete'  => ' за да изтриете ping-ове.',
    'login'     => 'Вход',
    'logout'    => 'Изход',
    'sendping'  => 'Изпрати ping',
    'unaut'     => 'Нямате достъп',
    'pinged'    => 'Ping беше изпратен успешно',
    'notpinged' => 'Грешка: адресът е недостъпен',
    'invalid'   => 'Грешно потребитеслко име / парола.',
    'disabled'  => 'Достъпът е деактивиран.',
    'loggedout' => 'Излязохте успешно от системата.',
    'tracked'   => 'Tracked',
    'pass'      => 'Парола',
    'email_subject' => '[Trackback] нов Trackback',
    'email_txt' => 'Оставен е нов trackback на вашия website.',
);

$lang['commentuser'] = array (
    'title'             => 'Идентификация',
    'header'            => 'Идентифицирайте се като регистриран посетител',
    'logout'            => 'Изход.',
    'loggedout'         => 'Излязохте успешно от системата.',
    'login'             => 'Вход',
    'loggedin'          => 'Идентифицирахте се успешно.',
    'loggedinas'        => 'Идентифицирахте се като ',
    'pass_forgot'       => 'Забравена парола',
    'register_new'      => 'Регистрация на нов потребител',
    'register'          => 'Регистрация на нов посетител',
    'register_info'     => 'Моля полълнете следната информация. <strong>Въведете валиден e-mail-адрес</strong>, тъй като на него ще бъде изпратено потвърждението.',
    'pass_note'         => 'Забележка: Администраторът на този site има достъп до вашата парола <br />.. <em>Не</em> въвеждайте парола<br /> която използвате в други site-ове / account-и!',
    'show_email'        => 'Прилагай e-mail-адреса ми в коментарите',
    'notify'            => 'Известявай ме с e-mail за нови статии',
    'def_notify'        => 'Стандартно известие при отговор',
    'register'          => 'Регистрирай',
    'pass_invalid'      => 'Невалидна парола',
    'nouser'            => 'Няма такъв потребител..',
    'change_info'       => 'Тук можете да промените личната си информация.',
    'pref_edit'         => 'Редакция на настройките Ви',
    'pref_change'       => 'Актуализирай настройките',
    'options'           => 'Опции',
    'user_exists'       => 'Вече съшествува потребител с това име.. Моля изберете друго.',
    'email_note'        => 'Въвеждането на e-mail-адрес е задължително, тъй като иначе не бихте могли да потвърдите регистрацията си. Винаги можете да изберете да не показвате адреса си на останалите постеители.',
    'stored'            => 'Промените бяха успешно запазени.',
    'verified'          => 'Регистрацията ви беше успешно потвърдена. Моля идентифицирайте се..',
    'not_verified'      => 'Кодът е грешен. За съжаление потвърждаването е невъзможно..',
    'pass_sent'         => 'Паролата беше изпратена на зададения e-mail-адрес..',
    'user_pass_nomatch' => 'Потребителското име не съответства на e-mail-адреса.',
    'pass_send'         => 'Изпрати паролата',
    'pass_send_desc'    => 'В случай че сте забравили паролата си, попълнете потребителското си име и e-mail-адреси системата ще ви я изпрати. ',
    'oops'              => 'Оооps',
    'back'              => 'Назад към',
    'back_login'        => 'Назад към индентификацията.'
);

// A little tool to help you check if the file is correct..
if (count(get_included_files())<2) {

	$groups = count($lang);
	$total = 0;
	foreach ($lang as $langgroup) {
		$total += count($langgroup);
	}
	echo "<h2>Езиковият файл функционира!</h2>";
	echo "Файлът съдържа $groups групи и общо $total етикета.";

}

?>
