<?php

function snippet_show_bbclone_hits_entry($formatString = '%n visits.', $entryTitle = '%title%') {
	global $Paths;

	if(empty($Paths['bbclone_path'])) {
		return "<!-- error in snippet show_bbclone_hits_entry: bbclone directory not found -->";
	}

	if (defined('LIVEPAGE')){
		// for pages like 'live entries' and 'dynamic archives'..
		return main_show_bbclone_hits_entry($formatString, $entryTitle);
	} else{

		// For genreated pages like the frontpage and archives.
		$file = __FILE__;

		$output = "<"."?php\n";
		$output .= "    include_once('$file');\n";
		$output .= "    echo main_show_bbclone_hits_entry('$formatString','$entryTitle');\n";
		$output .= "?".">\n";

	}

	return $output;
}


function main_show_bbclone_hits_entry($formatString, $title) {
	global $Paths, $Pivot_Vars;

	// The determination of the title must be the same as in snippet_hardened_bbclone.php
	if ($title != '') {
		$weblogtitle = snippet_weblogtitle();
		if ($Pivot_Vars['c']!="") {
			$archivetitle = category_from_para($Pivot_Vars['c']);
		} else {
			$archivetitle = $weblogtitle;
		}
		if ($Pivot_Vars['tag']!="") {
			$tagtitle = $Pivot_Vars['tag'];
		} else {
			$tagtitle = $weblogtitle;
		}
		$title = str_replace("%tagtitle%", $tagtitle, $title);
		$title = str_replace("%date%", date("Y-m"), $title);
		$title = str_replace("%archivetitle%", $archivetitle, $title);
		$title = str_replace("%title%", snippet_title(), $title);
		$title = str_replace("%weblogtitle%", $weblogtitle, $title);
		$title = strip_tags(decode_text($title));
		// bbclone stores the title in ISO-8859-1 it seems
		if (i18n_is_utf8($title)) {
			$title = utf8_decode($title);
		}
	} else {
                // The default value..
                $title = sprintf("Pivot Page %s", date("Y-m"));
        }
        
	// bbclone cuts some characters if title is too long (>60) and adds "..."
	if (strlen($title) > 60){
		$title = substr($title,(strlen($title) - 57));
		$title = "...".$title;
	}
	// bbclone replaces a few character by its entities
	$title = htmlspecialchars($title,ENT_QUOTES);
	require($Paths['bbclone_path']."/var/access.php");
	$hits = $access["page"][$title]["count"];
        if (empty($hits)) { $hits = "0"; }
	$output = str_replace("%n",$hits,$formatString);
	return $output;
}

?>
