/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.datagram.AbstractEndpoint;
import org.xsocket.datagram.IConnectedEndpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.UserDatagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MulticastEndpoint
extends AbstractEndpoint
implements IConnectedEndpoint {
    private static Logger LOG = Logger.getLogger(MulticastEndpoint.class.getName());
    private static final Map<String, Class> SUPPORTED_OPTIONS = new HashMap<String, Class>();
    private volatile boolean isRunning = true;
    private MulticastSocket socket = null;
    private InetSocketAddress multicastAddress = null;

    public MulticastEndpoint(InetAddress address, int port) throws IOException {
        this(address, port, new HashMap<String, Object>(), 0, null, MulticastEndpoint.getGlobalWorkerPool());
    }

    public MulticastEndpoint(String address, int port, int receiveSize, IDatagramHandler datagramHandler) throws IOException {
        this(InetAddress.getByName(address), port, new HashMap<String, Object>(), receiveSize, datagramHandler, MulticastEndpoint.getGlobalWorkerPool());
    }

    public MulticastEndpoint(InetAddress address, int port, int receiveSize, IDatagramHandler datagramHandler) throws IOException {
        this(address, port, new HashMap<String, Object>(), receiveSize, datagramHandler, MulticastEndpoint.getGlobalWorkerPool());
    }

    public MulticastEndpoint(InetAddress address, int port, int receiveSize, IDatagramHandler datagramHandler, Executor workerPool) throws IOException {
        this(address, port, new HashMap<String, Object>(), receiveSize, datagramHandler, workerPool);
    }

    public MulticastEndpoint(String address, int port, Map<String, Object> options, int receiveSize, IDatagramHandler datagramHandler) throws IOException {
        this(InetAddress.getByName(address), port, options, receiveSize, datagramHandler, MulticastEndpoint.getGlobalWorkerPool());
    }

    public MulticastEndpoint(InetAddress address, int port, Map<String, Object> options, int receiveSize, IDatagramHandler datagramHandler) throws IOException {
        this(address, port, options, receiveSize, datagramHandler, MulticastEndpoint.getGlobalWorkerPool());
    }

    public MulticastEndpoint(InetAddress address, int port, Map<String, Object> options, int receiveSize, IDatagramHandler datagramHandler, Executor workerPool) throws IOException {
        super(datagramHandler, receiveSize, workerPool);
        this.socket = new MulticastSocket(port);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            this.setOption(entry.getKey(), entry.getValue());
        }
        this.socket.joinGroup(address);
        this.multicastAddress = new InetSocketAddress(address, port);
        if (datagramHandler != null) {
            this.startReceiver();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("upd multicast endpoint bound to " + address.getCanonicalHostName() + "/" + port);
        }
    }

    private void startReceiver() {
        Thread receiverThread = new Thread(){

            public void run() {
                while (MulticastEndpoint.this.isRunning) {
                    MulticastEndpoint.this.receiveData();
                }
            }
        };
        receiverThread.setDaemon(true);
        receiverThread.setName("MulticastReceiver#" + this.hashCode());
        receiverThread.start();
    }

    private void receiveData() {
        block2: {
            try {
                byte[] buf = new byte[this.getReceiveSize()];
                DatagramPacket dp = new DatagramPacket(buf, buf.length);
                this.socket.receive(dp);
                ByteBuffer data = ByteBuffer.wrap(dp.getData());
                data.limit(dp.getLength());
                this.onData(new InetSocketAddress(dp.getAddress(), dp.getPort()), data);
            }
            catch (IOException e) {
                if (this.socket.isClosed() || !LOG.isLoggable(Level.FINE)) break block2;
                LOG.fine("error occured by receiving data. Reason: " + e.toString());
            }
        }
    }

    @Override
    public String toString() {
        return this.multicastAddress.toString() + " (ID=" + this.getId() + ")";
    }

    @Override
    public void close() {
        if (this.isRunning) {
            block3: {
                this.isRunning = false;
                try {
                    this.socket.leaveGroup(this.multicastAddress.getAddress());
                    this.socket.close();
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block3;
                    LOG.fine("error occured by closing multicast socket. Reason: " + e.toString());
                }
            }
            super.close();
        }
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.multicastAddress.getAddress();
    }

    @Override
    public int getLocalPort() {
        return this.multicastAddress.getPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.multicastAddress;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void send(UserDatagram packet) throws ClosedChannelException, IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("[/:" + this.getLocalPort() + " " + this.getId() + "] sending datagram " + packet.toString());
        }
        packet.prepareForSend();
        byte[] bytes = new byte[packet.getData().remaining()];
        packet.getData().get(bytes);
        DatagramPacket dataPacket = new DatagramPacket(bytes, bytes.length, this.multicastAddress);
        this.socket.send(dataPacket);
    }

    protected MulticastEndpoint setOption(String name, Object value) throws IOException {
        if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            this.socket.setSendBufferSize((Integer)value);
        } else if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            this.socket.setReuseAddress((Boolean)value);
        } else if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            this.socket.setReceiveBufferSize((Integer)value);
        } else if (name.equals("IPPROTO_IP.IP_TOS")) {
            this.socket.setTrafficClass((Integer)value);
        } else if (name.equals("IPPROTO_IP.IP_MULTICAST_TTL")) {
            this.socket.setTimeToLive((Integer)value);
        } else if (name.equals("IPPROTO_IP.IP_MULTICAST_LOOP")) {
            this.socket.setLoopbackMode((Boolean)value);
        } else {
            LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        }
        return this;
    }

    @Override
    public Object getOption(String name) throws IOException {
        if (name.equals("SOL_SOCKET.SO_SNDBUF")) {
            return this.socket.getSendBufferSize();
        }
        if (name.equals("SOL_SOCKET.SO_REUSEADDR")) {
            return this.socket.getReuseAddress();
        }
        if (name.equals("SOL_SOCKET.SO_RCVBUF")) {
            return this.socket.getReceiveBufferSize();
        }
        if (name.equals("IPPROTO_IP.IP_TOS")) {
            return this.socket.getTrafficClass();
        }
        if (name.equals("IPPROTO_IP.IP_MULTICAST_TTL")) {
            return this.socket.getTimeToLive();
        }
        if (name.equals("IPPROTO_IP.IP_MULTICAST_LOOP")) {
            return this.socket.getLoopbackMode();
        }
        LOG.warning("option " + name + " is not supproted for " + this.getClass().getName());
        return null;
    }

    @Override
    public Map<String, Class> getOptions() {
        return Collections.unmodifiableMap(SUPPORTED_OPTIONS);
    }

    static {
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_RCVBUF", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_SNDBUF", Integer.class);
        SUPPORTED_OPTIONS.put("IPPROTO_IP.IP_TOS", Integer.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        SUPPORTED_OPTIONS.put("SOL_SOCKET.SO_REUSEADDR", Boolean.class);
        SUPPORTED_OPTIONS.put("IPPROTO_IP.IP_MULTICAST_TTL", Integer.class);
        SUPPORTED_OPTIONS.put("IPPROTO_IP.IP_MULTICAST_LOOP", Boolean.class);
    }
}

