/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.MaxReadSizeExceededException;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.HandlerAdapter;
import org.xsocket.connection.IConnectionScoped;
import org.xsocket.connection.IHandler;
import org.xsocket.connection.INonBlockingConnection;

class MultithreadedHandlerAdapter
extends HandlerAdapter {
    private static final Logger LOG = Logger.getLogger(MultithreadedHandlerAdapter.class.getName());
    private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();

    MultithreadedHandlerAdapter(IHandler handler, ConnectionUtils.HandlerInfo handlerInfo) {
        super(handler, handlerInfo);
    }

    public boolean onConnect(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedHandlerAdapter.super.onConnect(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onConnect multithreaded " + MultithreadedHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isConnectHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onData(final INonBlockingConnection connection) throws IOException, BufferUnderflowException, MaxReadSizeExceededException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedHandlerAdapter.super.onData(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onData multithreaded " + MultithreadedHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isDataHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onDisconnect(final INonBlockingConnection connection) throws IOException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedHandlerAdapter.super.onDisconnect(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onDisconnect multithreaded " + MultithreadedHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isDisconnectHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onIdleTimeout(final INonBlockingConnection connection) throws IOException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedHandlerAdapter.super.onIdleTimeout(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onIdleTimeout multithreaded " + MultithreadedHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isIdleTimeoutHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    public boolean onConnectionTimeout(final INonBlockingConnection connection) throws IOException {
        Runnable task = new Runnable(){

            public void run() {
                block2: {
                    try {
                        MultithreadedHandlerAdapter.super.onConnectionTimeout(connection);
                    }
                    catch (IOException ioe) {
                        if (!LOG.isLoggable(Level.FINE)) break block2;
                        LOG.fine("error occured while performing onConnectionTimeout multithreaded " + MultithreadedHandlerAdapter.this.getHandler() + " " + ioe.toString());
                    }
                }
            }
        };
        if (this.getHandlerInfo().isConnectionTimeoutHandlerMultithreaded()) {
            this.taskQueue.performMultiThreaded(task, connection.getWorkerpool());
        } else {
            this.taskQueue.performNonThreaded(task);
        }
        return true;
    }

    HandlerAdapter getConnectionInstance() {
        if (this.getHandlerInfo().isConnectionScoped()) {
            try {
                IHandler hdlCopy = (IHandler)((IConnectionScoped)((Object)this.getHandler())).clone();
                return new MultithreadedHandlerAdapter(hdlCopy, this.getHandlerInfo());
            }
            catch (CloneNotSupportedException cnse) {
                throw new RuntimeException(cnse.toString());
            }
        }
        return new MultithreadedHandlerAdapter(this.getHandler(), this.getHandlerInfo());
    }
}

