/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConnectionManager {
    private static final Logger LOG = Logger.getLogger(ConnectionManager.class.getName());
    private final ArrayList<WeakReference<TimeoutMgmHandle>> handles = new ArrayList();
    private static final long DEFAULT_WATCHDOG_PERIOD_MILLIS = 60000L;
    private long watchDogPeriodMillis = 60000L;
    private TimerTask watchDogTask = null;
    private int watchDogRuns = 0;
    private int countIdleTimeouts = 0;
    private int countConnectionTimeouts = 0;
    private AtomicInteger currentSize = new AtomicInteger(0);
    private ISizeListener sizeListener = null;

    public ConnectionManager(ISizeListener sizeListener) {
        this.sizeListener = sizeListener;
        this.updateTimeoutCheckPeriod(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeoutMgmHandle register(NonBlockingConnection connection) {
        TimeoutMgmHandle mgnCon = new TimeoutMgmHandle(this, connection);
        WeakReference<TimeoutMgmHandle> ref = new WeakReference<TimeoutMgmHandle>(mgnCon);
        mgnCon.setRef(ref);
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            this.handles.add(ref);
        }
        this.currentSize.incrementAndGet();
        this.sizeListener.sizeChanged();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection registered");
        }
        return mgnCon;
    }

    long getWatchDogPeriodMillis() {
        return this.watchDogPeriodMillis;
    }

    int getWatchDogRuns() {
        return this.watchDogRuns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(WeakReference<TimeoutMgmHandle> handleRef) {
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            this.handles.remove(handleRef);
        }
        this.currentSize.decrementAndGet();
        this.sizeListener.sizeChanged();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("handle deregistered (connections size=" + this.handles.size() + ")");
        }
    }

    int getSize() {
        return this.currentSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<NonBlockingConnection> getConnections() {
        HashSet<NonBlockingConnection> cons = new HashSet<NonBlockingConnection>();
        ArrayList connectionsCopy = null;
        ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
        synchronized (arrayList) {
            connectionsCopy = (ArrayList)this.handles.clone();
        }
        for (WeakReference handleRef : connectionsCopy) {
            TimeoutMgmHandle handle = (TimeoutMgmHandle)handleRef.get();
            if (handle == null) continue;
            NonBlockingConnection con = handle.getConnection();
            cons.add(con);
        }
        return cons;
    }

    void close() {
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
    }

    int getNumberOfIdleTimeouts() {
        return this.countIdleTimeouts;
    }

    int getNumberOfConnectionTimeouts() {
        return this.countConnectionTimeouts;
    }

    void updateTimeoutCheckPeriod(long requiredMinPeriod) {
        if (this.watchDogTask != null && this.watchDogPeriodMillis <= requiredMinPeriod) {
            return;
        }
        this.watchDogPeriodMillis = requiredMinPeriod;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("update watchdog period " + DataConverter.toFormatedDuration(this.watchDogPeriodMillis));
        }
        if (this.watchDogTask != null) {
            this.watchDogTask.cancel();
        }
        this.watchDogTask = new TimerTask(){

            public void run() {
                ConnectionManager.this.check();
            }
        };
        IoProvider.getTimer().schedule(this.watchDogTask, this.watchDogPeriodMillis, this.watchDogPeriodMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void check() {
        block8: {
            ++this.watchDogRuns;
            try {
                long current = System.currentTimeMillis();
                ArrayList connectionsCopy = null;
                ArrayList<WeakReference<TimeoutMgmHandle>> arrayList = this.handles;
                synchronized (arrayList) {
                    connectionsCopy = (ArrayList)this.handles.clone();
                }
                for (WeakReference handleRef : connectionsCopy) {
                    TimeoutMgmHandle handle = (TimeoutMgmHandle)handleRef.get();
                    if (handle == null) {
                        this.handles.remove(handleRef);
                        continue;
                    }
                    NonBlockingConnection con = handle.getConnection();
                    if (con.isOpen()) {
                        this.checkTimeout(con, current);
                        continue;
                    }
                    handle.destroy();
                    this.handles.remove(handleRef);
                }
                this.currentSize.set(this.handles.size());
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block8;
                LOG.fine("error occured: " + e.toString());
            }
        }
    }

    private void checkTimeout(NonBlockingConnection connection, long current) {
        boolean timeoutOccured = connection.checkIdleTimeout(current);
        if (timeoutOccured) {
            ++this.countIdleTimeouts;
        }
        if (timeoutOccured = connection.checkConnectionTimeout(current)) {
            ++this.countConnectionTimeouts;
        }
    }

    static interface ISizeListener {
        public void sizeChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TimeoutMgmHandle {
        private ConnectionManager connectionManager;
        private NonBlockingConnection con;
        private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
        private WeakReference<TimeoutMgmHandle> ref = null;

        public TimeoutMgmHandle(ConnectionManager connectionManager, NonBlockingConnection connection) {
            this.connectionManager = connectionManager;
            this.con = connection;
        }

        void setRef(WeakReference<TimeoutMgmHandle> ref) {
            this.ref = ref;
        }

        void updateCheckPeriod(long period) {
            this.connectionManager.updateTimeoutCheckPeriod(period);
        }

        void destroy() {
            if (!this.isDestroyed.getAndSet(true)) {
                this.connectionManager.remove(this.ref);
            }
        }

        NonBlockingConnection getConnection() {
            return this.con;
        }
    }
}

