/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;

abstract class AbstractMemoryManager {
    private static final Logger LOG = Logger.getLogger(AbstractMemoryManager.class.getName());
    private boolean useDirectMemory = false;
    private int preallocationSize = 65536;
    private int minPreallocatedBufferSize = 1;
    private boolean preallocate = false;

    protected AbstractMemoryManager(int preallocationSize, boolean preallocate, int minPreallocatedBufferSize, boolean useDirectMemory) {
        this.preallocationSize = preallocationSize;
        this.preallocate = preallocate;
        this.minPreallocatedBufferSize = minPreallocatedBufferSize;
        this.useDirectMemory = useDirectMemory;
    }

    public abstract ByteBuffer acquireMemoryStandardSizeOrPreallocated(int var1) throws IOException;

    public abstract void recycleMemory(ByteBuffer var1);

    public abstract void preallocate() throws IOException;

    public abstract int getCurrentSizePreallocatedBuffer();

    public final boolean isPreallocationMode() {
        return this.preallocate;
    }

    public final void setPreallocationMode(boolean mode) {
        this.preallocate = mode;
    }

    public final void setPreallocatedMinBufferSize(Integer minSize) {
        this.minPreallocatedBufferSize = minSize;
    }

    public final Integer getPreallocatedMinBufferSize() {
        return this.minPreallocatedBufferSize;
    }

    public final Integer gettPreallocationBufferSize() {
        return this.preallocationSize;
    }

    public final void setPreallocationBufferSize(Integer minSize) {
        this.preallocationSize = minSize;
    }

    public final boolean isDirect() {
        return this.useDirectMemory;
    }

    public final void setDirect(boolean isDirect) {
        this.useDirectMemory = isDirect;
    }

    public final ByteBuffer extractAndRecycleMemory(ByteBuffer buffer, int read) {
        ByteBuffer readData = null;
        if (read > 0) {
            buffer.limit(buffer.position());
            buffer.position(buffer.position() - read);
            readData = buffer.slice();
            if (this.preallocate && buffer.limit() < buffer.capacity()) {
                buffer.position(buffer.limit());
                buffer.limit(buffer.capacity());
                this.recycleMemory(buffer);
            }
        } else {
            readData = ByteBuffer.allocate(0);
            if (this.preallocate) {
                this.recycleMemory(buffer);
            }
        }
        return readData;
    }

    public final ByteBuffer acquireMemoryMinSize(int minSize) throws IOException {
        if (this.preallocate) {
            if (this.preallocationSize < minSize) {
                return this.newBuffer(minSize);
            }
            ByteBuffer buffer = this.acquireMemoryStandardSizeOrPreallocated(minSize);
            if (buffer.remaining() < minSize) {
                return this.newBuffer(minSize);
            }
            return buffer;
        }
        return this.newBuffer(minSize);
    }

    protected final ByteBuffer newBuffer(int size) throws IOException {
        try {
            if (this.useDirectMemory) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("allocating " + DataConverter.toFormatedBytesSize(size) + " direct memory");
                }
                return ByteBuffer.allocateDirect(size);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("allocating " + DataConverter.toFormatedBytesSize(size) + " heap memory");
            }
            return ByteBuffer.allocate(size);
        }
        catch (OutOfMemoryError oome) {
            String msg = null;
            msg = this.useDirectMemory ? "out of memory exception occured by trying to allocated direct memory " + oome.toString() : "out of memory exception occured by trying to allocated non-direct memory " + oome.toString();
            LOG.warning(msg);
            throw new IOException(msg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("useDirect=" + this.useDirectMemory + " preallocationOn=" + this.preallocate + " preallcoationSize=" + DataConverter.toFormatedBytesSize(this.preallocationSize) + " preallocatedMinSize=" + DataConverter.toFormatedBytesSize(this.minPreallocatedBufferSize));
        return sb.toString();
    }
}

