/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.bcpg.SecretSubkeyPacket;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;

public class PGPSecretKeyRing
extends PGPKeyRing {
    List keys;

    PGPSecretKeyRing(List list) {
        this.keys = list;
    }

    public PGPSecretKeyRing(byte[] byArray) throws IOException, PGPException {
        this(new ByteArrayInputStream(byArray));
    }

    public PGPSecretKeyRing(InputStream inputStream) throws IOException, PGPException {
        this.keys = new ArrayList();
        BCPGInputStream bCPGInputStream = PGPSecretKeyRing.wrap(inputStream);
        int n = bCPGInputStream.nextPacketTag();
        if (n != 5 && n != 7) {
            throw new IOException("secret key ring doesn't start with secret key tag: tag 0x" + Integer.toHexString(n));
        }
        SecretKeyPacket secretKeyPacket = (SecretKeyPacket)bCPGInputStream.readPacket();
        while (bCPGInputStream.nextPacketTag() == 61) {
            bCPGInputStream.readPacket();
        }
        TrustPacket trustPacket = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
        List list = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        PGPSecretKeyRing.readUserIDs(bCPGInputStream, arrayList, arrayList2, arrayList3);
        this.keys.add(new PGPSecretKey(secretKeyPacket, trustPacket, list, arrayList, arrayList2, arrayList3));
        while (bCPGInputStream.nextPacketTag() == 7) {
            SecretSubkeyPacket secretSubkeyPacket = (SecretSubkeyPacket)bCPGInputStream.readPacket();
            while (bCPGInputStream.nextPacketTag() == 61) {
                bCPGInputStream.readPacket();
            }
            TrustPacket trustPacket2 = PGPSecretKeyRing.readOptionalTrustPacket(bCPGInputStream);
            List list2 = PGPSecretKeyRing.readSignaturesAndTrust(bCPGInputStream);
            this.keys.add(new PGPSecretKey(secretSubkeyPacket, trustPacket2, list2));
        }
    }

    public PGPPublicKey getPublicKey() {
        return ((PGPSecretKey)this.keys.get(0)).getPublicKey();
    }

    public PGPSecretKey getSecretKey() {
        return (PGPSecretKey)this.keys.get(0);
    }

    public Iterator getSecretKeys() {
        return Collections.unmodifiableList(this.keys).iterator();
    }

    public PGPSecretKey getSecretKey(long l) {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            if (l != pGPSecretKey.getKeyID()) continue;
            return pGPSecretKey;
        }
        return null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        for (int i = 0; i != this.keys.size(); ++i) {
            PGPSecretKey pGPSecretKey = (PGPSecretKey)this.keys.get(i);
            pGPSecretKey.encode(outputStream);
        }
    }

    public static PGPSecretKeyRing insertSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>(pGPSecretKeyRing.keys);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i != arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() == pGPSecretKey.getKeyID()) {
                bl = true;
                arrayList.set(i, pGPSecretKey);
            }
            if (!pGPSecretKey2.isMasterKey()) continue;
            bl2 = true;
        }
        if (!bl) {
            if (pGPSecretKey.isMasterKey() && bl2) {
                throw new IllegalArgumentException("cannot add a master key to a ring that already has one");
            }
            arrayList.add(pGPSecretKey);
        }
        return new PGPSecretKeyRing(arrayList);
    }

    public static PGPSecretKeyRing removeSecretKey(PGPSecretKeyRing pGPSecretKeyRing, PGPSecretKey pGPSecretKey) {
        ArrayList arrayList = new ArrayList(pGPSecretKeyRing.keys);
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            PGPSecretKey pGPSecretKey2 = (PGPSecretKey)arrayList.get(i);
            if (pGPSecretKey2.getKeyID() != pGPSecretKey.getKeyID()) continue;
            bl = true;
            arrayList.remove(i);
        }
        if (!bl) {
            return null;
        }
        return new PGPSecretKeyRing(arrayList);
    }
}

