/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.downloads;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.common.log.NLogger;
import phex.xml.sax.downloads.DDownloadCandidate;
import phex.xml.sax.downloads.DDownloadFile;
import phex.xml.sax.downloads.DDownloadScope;
import phex.xml.sax.parser.downloads.DownloadCandidateHandler;

public class DownloadFileHandler
extends DefaultHandler {
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DDownloadFile downloadFile;
    private DefaultHandler parent;

    public DownloadFileHandler(DDownloadFile downloadFile, DefaultHandler parent, SAXParser parser) {
        this.downloadFile = downloadFile;
        this.parser = parser;
        this.parent = parent;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text.reset();
        if (qName.equals("candidate")) {
            DDownloadCandidate candidate = new DDownloadCandidate();
            this.downloadFile.getCandidateList().getSubElementList().add(candidate);
            DownloadCandidateHandler handler = new DownloadCandidateHandler(candidate, this, this.parser);
            this.parser.getXMLReader().setContentHandler(handler);
        } else if (qName.equals("unverified-scopes")) {
            String end;
            DDownloadScope scope = new DDownloadScope("unverified-scopes");
            String start = attributes.getValue("start");
            if (start != null) {
                try {
                    scope.setStart(Long.parseLong(start));
                }
                catch (NumberFormatException exp) {
                    NLogger.error(DownloadFileHandler.class, exp, exp);
                }
            }
            if ((end = attributes.getValue("end")) != null) {
                try {
                    scope.setEnd(Long.parseLong(end));
                }
                catch (NumberFormatException exp) {
                    NLogger.error(DownloadFileHandler.class, exp, exp);
                }
            }
            this.downloadFile.getUnverifiedScopesList().getSubElementList().add(scope);
        } else if (qName.equals("finished-scopes")) {
            String end;
            DDownloadScope scope = new DDownloadScope("finished-scopes");
            String start = attributes.getValue("start");
            if (start != null) {
                try {
                    scope.setStart(Long.parseLong(start));
                }
                catch (NumberFormatException exp) {
                    NLogger.error(DownloadFileHandler.class, exp, exp);
                }
            }
            if ((end = attributes.getValue("end")) != null) {
                try {
                    scope.setEnd(Long.parseLong(end));
                }
                catch (NumberFormatException exp) {
                    NLogger.error(DownloadFileHandler.class, exp, exp);
                }
            }
            this.downloadFile.getFinishedScopesList().getSubElementList().add(scope);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("created-time")) {
            try {
                this.downloadFile.setCreationTime(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, exp, exp);
            }
        } else if (qName.equals("filesize")) {
            try {
                this.downloadFile.setFileSize(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, exp, exp);
            }
        } else if (qName.equals("file-urn")) {
            this.downloadFile.setFileURN(this.text.toString());
        } else if (qName.equals("incomplete-file-name")) {
            this.downloadFile.setIncompleteFileName(this.text.toString());
        } else if (qName.equals("localfilename")) {
            this.downloadFile.setLocalFileName(this.text.toString());
        } else if (qName.equals("modified-time")) {
            try {
                this.downloadFile.setModificationTime(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, exp, exp);
            }
        } else if (qName.equals("scope-strategy")) {
            this.downloadFile.setScopeSelectionStrategy(this.text.toString());
        } else if (qName.equals("searchterm")) {
            this.downloadFile.setSearchTerm(this.text.toString());
        } else if (qName.equals("status")) {
            try {
                this.downloadFile.setStatus(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException exp) {
                NLogger.error(DownloadFileHandler.class, exp, exp);
            }
        } else if (qName.equals("swDownloadFile")) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }
}

