/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;
import phex.common.log.NLogger;
import phex.utils.HexConverter;

public class IOUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private IOUtil() {
    }

    public static int serializeIntLE(int value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)value;
        outbuf[offset++] = (byte)(value >> 8);
        outbuf[offset++] = (byte)(value >> 16);
        outbuf[offset++] = (byte)(value >> 24);
        return offset;
    }

    public static void serializeIntLE(int value, OutputStream outStream) throws IOException {
        outStream.write((byte)value);
        outStream.write((byte)(value >> 8));
        outStream.write((byte)(value >> 16));
        outStream.write((byte)(value >> 24));
    }

    public static int deserializeIntLE(byte[] inbuf, int offset) {
        return inbuf[offset + 3] << 24 | (inbuf[offset + 2] & 0xFF) << 16 | (inbuf[offset + 1] & 0xFF) << 8 | inbuf[offset] & 0xFF;
    }

    public static int deserializeInt(byte[] inbuf, int offset) {
        return inbuf[offset] << 24 | (inbuf[offset + 1] & 0xFF) << 16 | (inbuf[offset + 2] & 0xFF) << 8 | inbuf[offset + 3] & 0xFF;
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public static int deserializeIntLE(byte[] inbuf, int offset, int length) {
        int a;
        int d = 0;
        int c = 0;
        int b = 0;
        switch (length) {
            case 4: {
                d = inbuf[offset + 3] << 24;
            }
            case 3: {
                c = (inbuf[offset + 2] & 0xFF) << 16;
            }
            case 2: {
                b = (inbuf[offset + 1] & 0xFF) << 8;
            }
            case 1: {
                a = inbuf[offset] & 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong length: " + length);
            }
        }
        return d | c | b | a;
    }

    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public static long deserializeLongLE(byte[] inbuf, int offset, int length) {
        long a;
        long h = 0L;
        long g = 0L;
        long f = 0L;
        long e = 0L;
        long d = 0L;
        long c = 0L;
        long b = 0L;
        switch (length) {
            case 8: {
                h = ((long)inbuf[offset + 7] & 0xFFL) << 56;
            }
            case 7: {
                g = ((long)inbuf[offset + 6] & 0xFFL) << 48;
            }
            case 6: {
                f = ((long)inbuf[offset + 5] & 0xFFL) << 40;
            }
            case 5: {
                e = ((long)inbuf[offset + 4] & 0xFFL) << 32;
            }
            case 4: {
                d = ((long)inbuf[offset + 3] & 0xFFL) << 24;
            }
            case 3: {
                c = ((long)inbuf[offset + 2] & 0xFFL) << 16;
            }
            case 2: {
                b = ((long)inbuf[offset + 1] & 0xFFL) << 8;
            }
            case 1: {
                a = (long)inbuf[offset] & 0xFFL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong length: " + length);
            }
        }
        return h | g | f | e | d | c | b | a;
    }

    public static byte[] serializeInt2MinLE(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative input value");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(4);
        do {
            byteStream.write(value & 0xFF);
        } while ((value >>= 8) != 0);
        return byteStream.toByteArray();
    }

    public static byte[] serializeInt2MinLE(long value) {
        if (value <= 65535L) {
            if (value <= 255L) {
                if (value < 0L) {
                    throw new IllegalArgumentException("Negative input value");
                }
                return new byte[]{(byte)value};
            }
            return new byte[]{(byte)value, (byte)(value >> 8)};
        }
        if (value <= 0xFFFFFFL) {
            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16)};
        }
        return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
    }

    public static byte[] serializeLong2MinLE(long value) {
        if (value <= 0xFFFFFFFFFFFFFFL) {
            if (value <= 0xFFFFFFFFFFFFL) {
                if (value <= 0xFFFFFFFFFFL) {
                    if (value <= 0xFFFFFFFFL) {
                        if (value <= 0xFFFFFFL) {
                            if (value <= 65535L) {
                                if (value <= 255L) {
                                    if (value < 0L) {
                                        throw new IllegalArgumentException("value negative");
                                    }
                                    return new byte[]{(byte)value};
                                }
                                return new byte[]{(byte)value, (byte)(value >> 8)};
                            }
                            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16)};
                        }
                        return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
                    }
                    return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32)};
                }
                return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40)};
            }
            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48)};
        }
        return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
    }

    public static byte[] serializeLong(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static long deserializeLong(byte[] inbuf, int offset) {
        return ((long)inbuf[offset] & 0xFFL) << 56 | ((long)inbuf[offset + 1] & 0xFFL) << 48 | ((long)inbuf[offset + 2] & 0xFFL) << 40 | ((long)inbuf[offset + 3] & 0xFFL) << 32 | ((long)inbuf[offset + 4] & 0xFFL) << 24 | ((long)inbuf[offset + 5] & 0xFFL) << 16 | ((long)inbuf[offset + 6] & 0xFFL) << 8 | (long)inbuf[offset + 7] & 0xFFL;
    }

    public static int serializeShortLE(short value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)value;
        outbuf[offset++] = (byte)(value >> 8);
        return offset;
    }

    public static void serializeShortLE(short value, OutputStream outStream) throws IOException {
        outStream.write((byte)(value & 0xFF));
        outStream.write((byte)(value >> 8 & 0xFF));
    }

    public static int serializeShort(short value, byte[] outbuf, int offset) {
        outbuf[offset++] = (byte)(value >> 8);
        outbuf[offset++] = (byte)value;
        return offset;
    }

    public static void serializeShort(short value, OutputStream outStream) throws IOException {
        outStream.write((byte)(value >> 8 & 0xFF));
        outStream.write((byte)(value & 0xFF));
    }

    public static short deserializeShort(byte[] inbuf, int offset) {
        return (short)((inbuf[offset] & 0xFF) << 8 | inbuf[offset + 1] & 0xFF);
    }

    public static short deserializeShort(InputStream inStream) throws IOException {
        int a = (inStream.read() & 0xFF) << 8;
        int b = inStream.read() & 0xFF;
        return (short)(a | b);
    }

    public static short deserializeShortLE(byte[] inbuf, int offset) {
        return (short)((inbuf[offset + 1] & 0xFF) << 8 | inbuf[offset] & 0xFF);
    }

    public static short deserializeShortLE(InputStream inStream) throws IOException {
        int a = inStream.read() & 0xFF;
        int b = (inStream.read() & 0xFF) << 8;
        return (short)(b | a);
    }

    public static int unsignedByte2int(byte x) {
        return x & 0xFF;
    }

    public static int unsignedShort2Int(short x) {
        return x & 0xFFFF;
    }

    public static long unsignedInt2Long(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int castLong2Int(long x) {
        if (x >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (x <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)x;
    }

    public static int serializeString(String str, byte[] outbuf, int offset) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            outbuf[offset] = (byte)chars[i];
            ++offset;
        }
        return offset;
    }

    public static int deserializeString(byte[] inbuf, int offset, StringBuffer outbuf) {
        int begin = offset;
        int maxLen = inbuf.length;
        while (offset < maxLen && inbuf[offset] != 0) {
            ++offset;
        }
        if (offset - begin > 0) {
            outbuf.append(new String(inbuf, begin, offset - begin));
        }
        return offset;
    }

    public static int serializeIP(String ip, byte[] outbuf, int offset) {
        byte[] addrBuf;
        InetAddress inet = null;
        try {
            inet = InetAddress.getByName(ip);
            addrBuf = inet.getAddress();
        }
        catch (Exception e) {
            addrBuf = new byte[]{0, 0, 0, 0};
        }
        outbuf[offset++] = addrBuf[0];
        outbuf[offset++] = addrBuf[1];
        outbuf[offset++] = addrBuf[2];
        outbuf[offset++] = addrBuf[3];
        return offset;
    }

    public static byte serializeGUESSVersionFormat(int majorVersion, int minorVersion) throws IllegalArgumentException {
        if (majorVersion < 0 || majorVersion >= 16 || minorVersion < 0 || minorVersion >= 16) {
            throw new IllegalArgumentException("Version out of range.");
        }
        int guessVersion = majorVersion << 4;
        return (byte)(guessVersion |= minorVersion);
    }

    public static byte[] readBytesToNull(InputStream inStream) throws IOException {
        int b;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while (inStream.available() > 0 && (b = inStream.read()) != 0) {
            outStream.write(b);
        }
        return outStream.toByteArray();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtil.copy(input, output);
        return output.toByteArray();
    }

    public static String toString(Reader input) throws IOException {
        StringWriter reader = new StringWriter();
        IOUtil.copy(input, reader);
        return reader.toString();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static byte calculateCeilLog2(int value) {
        if (value <= 65536) {
            if (value <= 256) {
                if (value <= 16) {
                    if (value <= 4) {
                        if (value <= 2) {
                            if (value <= 1) {
                                return 0;
                            }
                            return 1;
                        }
                        return 2;
                    }
                    if (value <= 8) {
                        return 3;
                    }
                    return 4;
                }
                if (value <= 64) {
                    if (value <= 32) {
                        return 5;
                    }
                    return 6;
                }
                if (value <= 128) {
                    return 7;
                }
                return 8;
            }
            if (value <= 4096) {
                if (value <= 1024) {
                    if (value <= 512) {
                        return 9;
                    }
                    return 10;
                }
                if (value <= 2048) {
                    return 11;
                }
                return 12;
            }
            if (value <= 16384) {
                if (value <= 8192) {
                    return 13;
                }
                return 14;
            }
            if (value <= 32768) {
                return 15;
            }
            return 16;
        }
        if (value <= 0x1000000) {
            if (value <= 0x100000) {
                if (value <= 262144) {
                    if (value <= 131072) {
                        return 17;
                    }
                    return 18;
                }
                if (value <= 524288) {
                    return 19;
                }
                return 20;
            }
            if (value <= 0x400000) {
                if (value <= 0x200000) {
                    return 21;
                }
                return 22;
            }
            if (value <= 0x800000) {
                return 23;
            }
            return 24;
        }
        if (value <= 0x10000000) {
            if (value <= 0x4000000) {
                if (value <= 0x2000000) {
                    return 25;
                }
                return 26;
            }
            if (value <= 0x8000000) {
                return 27;
            }
            return 28;
        }
        if (value <= 0x40000000) {
            if (value <= 0x20000000) {
                return 29;
            }
            return 30;
        }
        return 31;
    }

    public static byte calculateLog2(int value) {
        if (value < 65536) {
            if (value < 256) {
                if (value < 16) {
                    if (value < 4) {
                        if (value < 2) {
                            return 0;
                        }
                        return 1;
                    }
                    if (value < 8) {
                        return 2;
                    }
                    return 3;
                }
                if (value < 64) {
                    if (value < 32) {
                        return 4;
                    }
                    return 5;
                }
                if (value < 128) {
                    return 6;
                }
                return 7;
            }
            if (value < 4096) {
                if (value < 1024) {
                    if (value < 512) {
                        return 8;
                    }
                    return 9;
                }
                if (value < 2048) {
                    return 10;
                }
                return 11;
            }
            if (value < 16384) {
                if (value < 8192) {
                    return 12;
                }
                return 13;
            }
            if (value < 32768) {
                return 14;
            }
            return 15;
        }
        if (value < 0x1000000) {
            if (value < 0x100000) {
                if (value < 262144) {
                    if (value < 131072) {
                        return 16;
                    }
                    return 17;
                }
                if (value < 524288) {
                    return 18;
                }
                return 19;
            }
            if (value < 0x400000) {
                if (value < 0x200000) {
                    return 20;
                }
                return 21;
            }
            if (value < 0x800000) {
                return 22;
            }
            return 23;
        }
        if (value < 0x10000000) {
            if (value < 0x4000000) {
                if (value < 0x2000000) {
                    return 24;
                }
                return 25;
            }
            if (value < 0x8000000) {
                return 26;
            }
            return 27;
        }
        if (value < 0x40000000) {
            if (value < 0x20000000) {
                return 28;
            }
            return 29;
        }
        return 30;
    }

    public static int determineBitCount(int num) {
        if (num < 0) {
            return 32;
        }
        if (num < 65536) {
            if (num < 256) {
                if (num < 16) {
                    if (num < 4) {
                        if (num < 2) {
                            if (num == 0) {
                                return 0;
                            }
                            return 1;
                        }
                        return 2;
                    }
                    if (num < 8) {
                        return 3;
                    }
                    return 4;
                }
                if (num < 64) {
                    if (num < 32) {
                        return 5;
                    }
                    return 6;
                }
                if (num < 128) {
                    return 7;
                }
                return 8;
            }
            if (num < 4096) {
                if (num < 1024) {
                    if (num < 512) {
                        return 9;
                    }
                    return 10;
                }
                if (num < 2048) {
                    return 11;
                }
                return 12;
            }
            if (num < 16384) {
                if (num < 8192) {
                    return 13;
                }
                return 14;
            }
            if (num < 32768) {
                return 15;
            }
            return 16;
        }
        if (num < 0x1000000) {
            if (num < 0x100000) {
                if (num < 262144) {
                    if (num < 131072) {
                        return 17;
                    }
                    return 18;
                }
                if (num < 524288) {
                    return 19;
                }
                return 20;
            }
            if (num < 0x400000) {
                if (num < 0x200000) {
                    return 21;
                }
                return 22;
            }
            if (num < 0x800000) {
                return 23;
            }
            return 24;
        }
        if (num < 0x10000000) {
            if (num < 0x4000000) {
                if (num < 0x2000000) {
                    return 25;
                }
                return 26;
            }
            if (num < 0x8000000) {
                return 27;
            }
            return 28;
        }
        if (num < 0x40000000) {
            if (num < 0x20000000) {
                return 29;
            }
            return 30;
        }
        return 31;
    }

    public static byte[] deflate(byte[] data) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DeflaterOutputStream compressor = new DeflaterOutputStream(outStream);
            compressor.write(data, 0, data.length);
            compressor.close();
            return outStream.toByteArray();
        }
        catch (IOException exp) {
            NLogger.error(IOUtil.class, exp, exp);
            throw new RuntimeException(exp);
        }
    }

    public static byte[] inflate(Inflater inflater, byte[] data) throws DataFormatException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        inflater.setInput(data);
        byte[] buffer = new byte[1024];
        int lengthRead = 0;
        do {
            if ((lengthRead = inflater.inflate(buffer)) <= 0) continue;
            outStream.write(buffer, 0, lengthRead);
        } while (lengthRead > 0);
        return outStream.toByteArray();
    }

    public static byte[] inflate(byte[] data) throws DataFormatException {
        return IOUtil.inflate(new Inflater(), data);
    }

    public static byte[] cobsEncode(byte[] data) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream();
            int code = 1;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == 0) {
                    outStream.write(code);
                    outStream.write(tempBuffer.toByteArray());
                    tempBuffer.reset();
                    code = 1;
                    continue;
                }
                tempBuffer.write(data[i]);
                if (++code != 255) continue;
                outStream.write(code);
                outStream.write(tempBuffer.toByteArray());
                tempBuffer.reset();
                code = 1;
            }
            outStream.write(code);
            outStream.write(tempBuffer.toByteArray());
            return outStream.toByteArray();
        }
        catch (IOException exp) {
            NLogger.error(IOUtil.class, exp, exp);
            throw new RuntimeException(exp);
        }
    }

    public static byte[] cobsDecode(byte[] data) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int index = 0;
        int code = 0;
        while (index < data.length) {
            if (index + ((code = IOUtil.unsignedByte2int(data[index++])) - 2) >= data.length) {
                if (NLogger.isWarnEnabled(IOUtil.class)) {
                    NLogger.warn(IOUtil.class, "Invalid COBS InputData: " + HexConverter.toHexString(data));
                }
                throw new IOException("Invalid COBS InputData");
            }
            for (int i = 1; i < code; ++i) {
                outStream.write(data[index++]);
            }
            if (code >= 255 || index >= data.length) continue;
            outStream.write(0);
        }
        return outStream.toByteArray();
    }

    public static void closeQuietly(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ManagedFile file) {
        if (file == null) {
            return;
        }
        try {
            file.closeFile();
        }
        catch (ManagedFileException managedFileException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ReadOnlyManagedFile file) {
        if (file == null) {
            return;
        }
        try {
            file.closeFile();
        }
        catch (ManagedFileException managedFileException) {
            // empty catch block
        }
    }
}

