/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import phex.common.AddressCounter;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.LogBuffer;
import phex.common.log.NLogger;
import phex.event.ContainerEvent;
import phex.http.HTTPRequest;
import phex.net.connection.Connection;
import phex.prefs.core.UploadPrefs;
import phex.servent.Servent;
import phex.upload.UploadEngine;
import phex.upload.UploadState;

public class UploadManager {
    private final Servent servent;
    private final AddressCounter uploadIPCounter;
    private final List<UploadState> uploadStateList;
    private final List<UploadState> queuedStateList;
    private LogBuffer uploadStateLogBuffer;

    public UploadManager(Servent servent) {
        this.servent = servent;
        this.uploadStateList = new ArrayList<UploadState>();
        this.queuedStateList = new ArrayList<UploadState>();
        this.uploadIPCounter = new AddressCounter(UploadPrefs.MaxUploadsPerIP.get(), false);
        if (UploadPrefs.UploadStateLogBufferSize.get() > 0) {
            this.uploadStateLogBuffer = new LogBuffer(UploadPrefs.UploadStateLogBufferSize.get().intValue());
        }
        Environment.getInstance().scheduleTimerTask(new CleanUploadStateTimer(), 10000L, 10000L);
    }

    public BandwidthController getUploadBandwidthController() {
        return this.servent.getBandwidthService().getUploadBandwidthController();
    }

    public void handleUploadRequest(Connection connection, HTTPRequest httpRequest) {
        UploadEngine uploadEngine = new UploadEngine(connection, httpRequest, this, this.servent.getSharedFilesService());
        uploadEngine.startUpload();
    }

    public boolean isHostBusy() {
        return this.getUploadingCount() >= UploadPrefs.MaxParallelUploads.get();
    }

    public boolean isQueueLimitReached() {
        return this.queuedStateList.size() >= UploadPrefs.MaxQueueSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndCountAddress(DestAddress address) {
        AddressCounter addressCounter = this.uploadIPCounter;
        synchronized (addressCounter) {
            this.uploadIPCounter.setMaxCount(UploadPrefs.MaxUploadsPerIP.get());
            return this.uploadIPCounter.validateAndCountAddress(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUploadAddress(DestAddress address) {
        AddressCounter addressCounter = this.uploadIPCounter;
        synchronized (addressCounter) {
            this.uploadIPCounter.relaseAddress(address);
        }
    }

    public LogBuffer getUploadStateLogBuffer() {
        return this.uploadStateLogBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadState(UploadState uploadState) {
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            int position = this.uploadStateList.size();
            this.uploadStateList.add(uploadState);
            this.fireUploadStateAdded(uploadState, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUploadState(UploadState uploadState) {
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            return this.uploadStateList.contains(uploadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadListSize() {
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            return this.uploadStateList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingCount() {
        int count = 0;
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            for (UploadState state : this.uploadStateList) {
                if (!state.isUploadRunning()) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState getUploadStateAt(int index) {
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            if (index < 0 || index >= this.uploadStateList.size()) {
                return null;
            }
            return this.uploadStateList.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState[] getUploadStatesAt(int[] indices) {
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            int length = indices.length;
            UploadState[] states = new UploadState[length];
            int listSize = this.uploadStateList.size();
            for (int i = 0; i < length; ++i) {
                states[i] = indices[i] < 0 || indices[i] >= listSize ? null : this.uploadStateList.get(indices[i]);
            }
            return states;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUploadState(UploadState state) {
        int idx;
        state.stopUpload();
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            idx = this.uploadStateList.indexOf(state);
            if (idx != -1) {
                this.uploadStateList.remove(idx);
                this.fireUploadStateRemoved(state, idx);
            }
        }
        list = this.queuedStateList;
        synchronized (list) {
            idx = this.queuedStateList.indexOf(state);
            if (idx != -1) {
                this.queuedStateList.remove(idx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUploadStateList() {
        List<UploadState> list = this.uploadStateList;
        synchronized (list) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState state = this.uploadStateList.get(i);
                if (!state.isReadyForCleanup()) continue;
                this.uploadStateList.remove(i);
                this.fireUploadStateRemoved(state, i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addQueuedUpload(UploadState uploadState) {
        int position;
        List<UploadState> list = this.queuedStateList;
        synchronized (list) {
            position = this.queuedStateList.size();
            this.queuedStateList.add(uploadState);
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedUpload(UploadState uploadState) {
        List<UploadState> list = this.queuedStateList;
        synchronized (list) {
            int position = this.queuedStateList.indexOf(uploadState);
            if (position != -1) {
                this.queuedStateList.remove(position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedPosition(UploadState state) {
        List<UploadState> list = this.queuedStateList;
        synchronized (list) {
            return this.queuedStateList.indexOf(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadQueueSize() {
        List<UploadState> list = this.queuedStateList;
        synchronized (list) {
            return this.queuedStateList.size();
        }
    }

    private void fireUploadStateAdded(UploadState uploadState, int position) {
        this.servent.getEventService().publish("phex:upload/state", new ContainerEvent(ContainerEvent.Type.ADDED, uploadState, this, position));
    }

    private void fireUploadStateRemoved(UploadState uploadState, int position) {
        this.servent.getEventService().publish("phex:upload/state", new ContainerEvent(ContainerEvent.Type.REMOVED, uploadState, this, position));
    }

    private class CleanUploadStateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private CleanUploadStateTimer() {
        }

        public void run() {
            try {
                if (UploadPrefs.AutoRemoveCompleted.get().booleanValue()) {
                    UploadManager.this.cleanUploadStateList();
                }
            }
            catch (Throwable th) {
                NLogger.error(CleanUploadStateTimer.class, th, th);
            }
        }
    }
}

