/*
 * Decompiled with CFR 0.152.
 */
package phex.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import phex.utils.IOUtil;
import phex.utils.Localizer;

public class TranslationAssistant {
    public static void main(String[] args) {
        TranslationAssistant assistent = new TranslationAssistant();
        long start = System.currentTimeMillis();
        assistent.findUnusedKeys();
        assistent.findMissingKeys();
        long end = System.currentTimeMillis();
        System.out.println("---Time: " + (end - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findMissingKeys() {
        List fileList = this.getAllPossibleLangFiles();
        InputStream stream = Localizer.class.getResourceAsStream("/phex/resources/Lang.properties");
        stream = new BufferedInputStream(stream);
        Properties mainProps = new Properties();
        try {
            mainProps.load(stream);
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
        finally {
            IOUtil.closeQuietly(stream);
        }
        Set<Object> mainKeySet = mainProps.keySet();
        for (String filename : fileList) {
            stream = Localizer.class.getResourceAsStream(filename);
            if (stream == null) continue;
            stream = new BufferedInputStream(stream);
            Properties props = new Properties();
            try {
                props.load(stream);
                Set<Object> keys = props.keySet();
                HashSet<Object> compareSet = new HashSet<Object>(mainKeySet);
                compareSet.removeAll(keys);
                Iterator keyIterator = compareSet.iterator();
                if (!keyIterator.hasNext()) continue;
                System.out.println("---Missing Keys in " + filename);
                while (keyIterator.hasNext()) {
                    System.out.println(keyIterator.next());
                }
            }
            catch (IOException exp) {
                exp.printStackTrace();
            }
            finally {
                IOUtil.closeQuietly(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findUnusedKeys() {
        List fileList = this.getAllPossibleLangFiles();
        for (String filename : fileList) {
            InputStream stream = Localizer.class.getResourceAsStream(filename);
            if (stream == null) continue;
            stream = new BufferedInputStream(stream);
            Properties props = new Properties();
            try {
                props.load(stream);
                Set<Object> keys = props.keySet();
                this.findUnusedKeys(keys, new File("src/phex"));
                System.out.println("---Unused Keys in " + filename);
                Iterator<Object> keyIterator = keys.iterator();
                while (keyIterator.hasNext()) {
                    System.out.println(keyIterator.next());
                }
            }
            catch (IOException exp) {}
            continue;
            finally {
                IOUtil.closeQuietly(stream);
            }
        }
    }

    private void findUnusedKeysRegEx(Set keys, File source) throws IOException {
        if (source.isDirectory()) {
            File[] childs = source.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("java");
                }
            });
            for (int i = 0; i < childs.length; ++i) {
                this.findUnusedKeysRegEx(keys, childs[i]);
            }
        } else {
            System.out.println("searching " + keys.size() + " : " + source);
            FileInputStream inStream = new FileInputStream(source);
            FileChannel channel = inStream.getChannel();
            ByteBuffer byteBuf = ByteBuffer.allocate((int)source.length());
            channel.read(byteBuf);
            byteBuf.rewind();
            CharBuffer charBuf = Charset.forName("US-ASCII").decode(byteBuf);
            String[] keyArr = keys.toArray(new String[keys.size()]);
            for (int i = 0; i < keyArr.length; ++i) {
                Pattern pattern = Pattern.compile(".*" + keyArr[i] + ".*", 32);
                Matcher matcher = pattern.matcher(charBuf);
                if (!matcher.matches()) continue;
                keys.remove(keyArr[i]);
            }
        }
    }

    private void findUnusedKeys(Set keys, File source) throws IOException {
        if (source.isDirectory()) {
            File[] childs = source.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith("java");
                }
            });
            for (int i = 0; i < childs.length; ++i) {
                this.findUnusedKeys(keys, childs[i]);
            }
        } else {
            FileInputStream inStream = new FileInputStream(source);
            FileChannel channel = inStream.getChannel();
            ByteBuffer byteBuf = ByteBuffer.allocate((int)source.length());
            channel.read(byteBuf);
            byteBuf.rewind();
            String fileString = new String(byteBuf.array(), "US-ASCII");
            String[] keyArr = keys.toArray(new String[keys.size()]);
            for (int i = 0; i < keyArr.length; ++i) {
                if (fileString.indexOf(keyArr[i]) == -1) continue;
                keys.remove(keyArr[i]);
            }
        }
    }

    private List getAllPossibleLangFiles() {
        List<Locale> availableLocales = Localizer.getAvailableLocales();
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add("/phex/resources/Lang.properties");
        fileList.add("/Lang.properties");
        for (Locale locale : availableLocales) {
            StringBuffer buffer = new StringBuffer("Lang");
            String language = locale.getLanguage();
            if (language.length() <= 0) continue;
            buffer.append('_');
            buffer.append(language);
            fileList.add("/phex/resources/" + buffer.toString() + ".properties");
            fileList.add("/" + buffer.toString() + ".properties");
            String country = locale.getCountry();
            if (country.length() <= 0) continue;
            buffer.append('_');
            buffer.append(country);
            fileList.add("/phex/resources/" + buffer.toString() + ".properties");
            fileList.add("/" + buffer.toString() + ".properties");
        }
        return fileList;
    }
}

