/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import java.util.HashMap;
import phex.common.AbstractLifeCycle;
import phex.common.HorizonTracker;
import phex.common.LongObj;
import phex.common.bandwidth.BandwidthManager;
import phex.msg.PongMsg;
import phex.prefs.core.StatisticPrefs;
import phex.servent.Servent;
import phex.statistic.ChainedSimpleStatisticProvider;
import phex.statistic.DailyUptimeStatisticProvider;
import phex.statistic.HorizonStatisticProvider;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticProviderConstants;
import phex.statistic.TransferAverageStatisticProvider;
import phex.statistic.UptimeStatisticProvider;

public class StatisticsManager
extends AbstractLifeCycle
implements StatisticProviderConstants {
    private HashMap<String, StatisticProvider> statisticProviderMap = new HashMap();

    public StatisticsManager() {
        this.registerStatisticProvider("UptimeProvider", new UptimeStatisticProvider());
        this.registerStatisticProvider("DailyUptimeProvider", new DailyUptimeStatisticProvider());
        this.initializeMsgCountStats();
        this.initializeUpDownloadStats();
    }

    public void registerStatisticProvider(String name, StatisticProvider provider) {
        this.statisticProviderMap.put(name, provider);
    }

    public StatisticProvider getStatisticProvider(String name) {
        return this.statisticProviderMap.get(name);
    }

    public void doStart() {
        Servent servent = Servent.getInstance();
        BandwidthManager manager = servent.getBandwidthService();
        this.registerStatisticProvider("TotalBandwidthProvider", new TransferAverageStatisticProvider(manager.getServentBandwidthController()));
        this.registerStatisticProvider("NetworkBandwidthProvider", new TransferAverageStatisticProvider(manager.getNetworkBandwidthController()));
        this.registerStatisticProvider("DownloadBandwidthProvider", new TransferAverageStatisticProvider(manager.getDownloadBandwidthController()));
        this.registerStatisticProvider("UploadBandwidthProvider", new TransferAverageStatisticProvider(manager.getUploadBandwidthController()));
        HorizonTracker horizonTracker = new HorizonTracker();
        servent.getMessageService().addMessageSubscriber(PongMsg.class, horizonTracker);
        this.registerStatisticProvider("HorizonHostCountProvider", new HorizonStatisticProvider(HorizonStatisticProvider.Type.HOST_COUNT, horizonTracker));
        this.registerStatisticProvider("HorizonFileCountProvider", new HorizonStatisticProvider(HorizonStatisticProvider.Type.FILE_COUNT, horizonTracker));
        this.registerStatisticProvider("HorizonFileSizeProvider", new HorizonStatisticProvider(HorizonStatisticProvider.Type.FILE_SIZE, horizonTracker));
    }

    public void doStop() {
        UptimeStatisticProvider uptimeProvider = (UptimeStatisticProvider)this.getStatisticProvider("UptimeProvider");
        uptimeProvider.saveUptimeStats();
        DailyUptimeStatisticProvider dailyUptimeProvider = (DailyUptimeStatisticProvider)this.getStatisticProvider("DailyUptimeProvider");
        dailyUptimeProvider.shutdown();
        SimpleStatisticProvider totalDownloadCount = (SimpleStatisticProvider)this.getStatisticProvider("TotalDownloadCountProvider");
        SimpleStatisticProvider totalUploadCount = (SimpleStatisticProvider)this.getStatisticProvider("TotalUploadCountProvider");
        StatisticPrefs.TotalDownloadCount.set((int)((LongObj)totalDownloadCount.getValue()).value);
        StatisticPrefs.TotalUploadCount.set((int)((LongObj)totalUploadCount.getValue()).value);
    }

    private void initializeMsgCountStats() {
        SimpleStatisticProvider totalInMsgCounter = new SimpleStatisticProvider();
        ChainedSimpleStatisticProvider pingMsgInCounter = new ChainedSimpleStatisticProvider(totalInMsgCounter);
        ChainedSimpleStatisticProvider pongMsgInCounter = new ChainedSimpleStatisticProvider(totalInMsgCounter);
        ChainedSimpleStatisticProvider pushMsgInCounter = new ChainedSimpleStatisticProvider(totalInMsgCounter);
        ChainedSimpleStatisticProvider queryMsgInCounter = new ChainedSimpleStatisticProvider(totalInMsgCounter);
        ChainedSimpleStatisticProvider queryHitMsgInCounter = new ChainedSimpleStatisticProvider(totalInMsgCounter);
        this.registerStatisticProvider("TotalMsgInProvider", totalInMsgCounter);
        this.registerStatisticProvider("PingMsgInProvider", pingMsgInCounter);
        this.registerStatisticProvider("PongMsgInProvider", pongMsgInCounter);
        this.registerStatisticProvider("PushMsgInProvider", pushMsgInCounter);
        this.registerStatisticProvider("QueryMsgInProvider", queryMsgInCounter);
        this.registerStatisticProvider("QueryHitMsgInProvider", queryHitMsgInCounter);
        SimpleStatisticProvider totalOutMsgCounter = new SimpleStatisticProvider();
        ChainedSimpleStatisticProvider pingMsgOutCounter = new ChainedSimpleStatisticProvider(totalOutMsgCounter);
        ChainedSimpleStatisticProvider pongMsgOutCounter = new ChainedSimpleStatisticProvider(totalOutMsgCounter);
        ChainedSimpleStatisticProvider pushMsgOutCounter = new ChainedSimpleStatisticProvider(totalOutMsgCounter);
        ChainedSimpleStatisticProvider queryMsgOutCounter = new ChainedSimpleStatisticProvider(totalOutMsgCounter);
        ChainedSimpleStatisticProvider queryHitMsgOutCounter = new ChainedSimpleStatisticProvider(totalOutMsgCounter);
        this.registerStatisticProvider("TotalMsgOutProvider", totalOutMsgCounter);
        this.registerStatisticProvider("PingMsgOutProvider", pingMsgOutCounter);
        this.registerStatisticProvider("PongMsgOutProvider", pongMsgOutCounter);
        this.registerStatisticProvider("PushMsgOutProvider", pushMsgOutCounter);
        this.registerStatisticProvider("QueryMsgOutProvider", queryMsgOutCounter);
        this.registerStatisticProvider("QueryHitMsgOutProvider", queryHitMsgOutCounter);
        SimpleStatisticProvider dropedMsgTotalCounter = new SimpleStatisticProvider();
        ChainedSimpleStatisticProvider dropedMsgInCounter = new ChainedSimpleStatisticProvider(dropedMsgTotalCounter);
        ChainedSimpleStatisticProvider dropedMsgOutCounter = new ChainedSimpleStatisticProvider(dropedMsgTotalCounter);
        this.registerStatisticProvider("DropedMsgTotalProvider", dropedMsgTotalCounter);
        this.registerStatisticProvider("DropedMsgInProvider", dropedMsgInCounter);
        this.registerStatisticProvider("DropedMsgOutProvider", dropedMsgOutCounter);
    }

    private void initializeUpDownloadStats() {
        SimpleStatisticProvider totalUploadCount = new SimpleStatisticProvider();
        totalUploadCount.setValue(StatisticPrefs.TotalUploadCount.get().intValue());
        ChainedSimpleStatisticProvider sessionUploadCount = new ChainedSimpleStatisticProvider(totalUploadCount);
        this.registerStatisticProvider("SessionUploadCountProvider", sessionUploadCount);
        this.registerStatisticProvider("TotalUploadCountProvider", totalUploadCount);
        SimpleStatisticProvider totalDownloadCount = new SimpleStatisticProvider();
        totalDownloadCount.setValue(StatisticPrefs.TotalDownloadCount.get().intValue());
        ChainedSimpleStatisticProvider sessionDownloadCount = new ChainedSimpleStatisticProvider(totalDownloadCount);
        this.registerStatisticProvider("SessionDownloadCountProvider", sessionDownloadCount);
        this.registerStatisticProvider("TotalDownloadCountProvider", totalDownloadCount);
        this.registerStatisticProvider("PushDownloadAttemptsProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushDownloadSucessProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushDownloadFailureProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushDldPushProxyAttemptsProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushDldPushProxySuccessProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushUploadAttemptsProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushUploadSucessProvider", new SimpleStatisticProvider());
        this.registerStatisticProvider("PushUploadFailureProvider", new SimpleStatisticProvider());
    }
}

