/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.util.Arrays;
import phex.common.address.AddressUtils;
import phex.utils.IOUtil;

public class IpPortAddress {
    private int hash = 0;
    private byte[] ipAddress;
    private byte[] port;

    public IpPortAddress(byte[] hostIp) {
        int offset;
        this.ipAddress = new byte[4];
        for (offset = 0; offset < 4; ++offset) {
            this.ipAddress[offset] = hostIp[offset];
        }
        this.port = new byte[4];
        if (hostIp.length > 6) {
            for (offset = 0; offset < 4; ++offset) {
                this.port[offset] = hostIp[offset + 4];
            }
        } else {
            for (offset = 0; offset < 2; ++offset) {
                this.port[offset] = hostIp[offset + 4];
            }
        }
    }

    public IpPortAddress(String IpAddress2, int port) {
        this.ipAddress = AddressUtils.parseIP(IpAddress2);
        this.port = new byte[4];
        IOUtil.serializeShortLE((short)port, this.port, 0);
    }

    public byte[] getOrigIpAddress() {
        return this.ipAddress;
    }

    public byte[] getOrigPort() {
        return this.port;
    }

    public String getIpAddress() {
        return AddressUtils.ip2string(this.ipAddress);
    }

    public int getPort() {
        return IOUtil.deserializeInt(this.port, 0);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int ipVal1 = IOUtil.deserializeInt(this.ipAddress, 0);
            int ipVal2 = IOUtil.deserializeInt(this.port, 0);
            this.hash = ipVal2 * 31;
            this.hash += ipVal1 * 59;
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IpPortAddress)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IpPortAddress ipPortAddr = (IpPortAddress)obj;
        return ipPortAddr.equals(ipPortAddr.getOrigIpAddress(), ipPortAddr.getOrigPort());
    }

    public boolean equals(byte[] ip, byte[] port) {
        if (this.ipAddress != null) {
            return Arrays.equals(this.ipAddress, ip) && Arrays.equals(this.port, port);
        }
        return false;
    }
}

