/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.msg.InvalidMessageException;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.DynamicQueryEngine;
import phex.query.SearchDataEvent;
import phex.query.SearchProgress;
import phex.query.SearchResultHolder;
import phex.security.AccessType;
import phex.servent.Servent;

public abstract class Search {
    private static final Logger logger = LoggerFactory.getLogger(Search.class);
    protected final Servent servent;
    protected DynamicQueryEngine queryEngine;
    protected QueryMsg queryMsg;
    protected SearchResultHolder searchResultHolder;
    protected SearchProgress searchProgress;
    protected volatile boolean isSearchFinished;

    protected Search(Servent servent) {
        this.servent = servent;
        this.searchResultHolder = new SearchResultHolder();
        this.isSearchFinished = false;
    }

    public abstract int getProgress();

    public boolean isSearchFinished() {
        if (this.isSearchFinished) {
            return true;
        }
        if (this.searchProgress != null && this.searchProgress.isSearchFinished()) {
            this.stopSearching();
            return true;
        }
        if (this.queryEngine != null && this.queryEngine.isQueryFinished()) {
            this.stopSearching();
            return true;
        }
        return false;
    }

    public void startSearching(SearchProgress progress) {
        this.searchProgress = progress;
        this.isSearchFinished = false;
        this.queryMsg.setCreationTime(System.currentTimeMillis());
        logger.debug("Sending Query '{}'.", (Object)this.queryMsg);
        this.queryEngine = this.servent.getQueryService().sendMyQuery(this.queryMsg, this.searchProgress);
        this.fireSearchStarted();
    }

    public void stopSearching() {
        if (this.isSearchFinished) {
            return;
        }
        this.isSearchFinished = true;
        if (this.queryEngine != null) {
            this.queryEngine.stopQuery();
        }
        this.fireSearchStoped();
    }

    protected boolean isResponseRecordValid(QueryResponseRecord record) {
        URN urn = record.getURN();
        if (urn != null && this.servent.getSecurityService().controlUrnAccess(urn) != AccessType.ACCESS_GRANTED) {
            logger.debug("Record contains blocked URN: {}", (Object)urn.getAsString());
            return false;
        }
        return true;
    }

    public abstract void processResponse(QueryResponseMsg var1) throws InvalidMessageException;

    protected void fireSearchStarted() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(SearchDataEvent searchChangeEvent) {
        this.servent.getEventService().publish("phex:search/data", searchChangeEvent);
    }
}

