/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.download.RemoteFile;
import phex.event.PhexEventService;
import phex.query.DefaultSearchProgress;
import phex.query.Search;
import phex.query.SearchDataEvent;
import phex.query.SearchResultHolder;
import phex.rules.Rule;
import phex.servent.Servent;

public class RuleFilteredSearch {
    private final Servent servent;
    private final PhexEventService eventService;
    private final Search search;
    private final SearchResultHolder displayedSearchResults;
    private final SearchResultHolder hiddenSearchResults;
    private final Rule[] searchFilterRules;
    private DefaultSearchProgress searchProgress;

    public RuleFilteredSearch(Search search, Rule ruleFilter, Servent servent, PhexEventService eventService) {
        this(search, new Rule[]{ruleFilter}, servent, eventService);
    }

    public RuleFilteredSearch(Search search, Rule[] ruleFilters, Servent servent, PhexEventService eventService) {
        this.servent = servent;
        this.eventService = eventService;
        this.displayedSearchResults = new SearchResultHolder();
        this.hiddenSearchResults = new SearchResultHolder();
        this.search = search;
        this.searchFilterRules = ruleFilters;
        eventService.processAnnotations(this);
    }

    public int getResultCount() {
        return this.displayedSearchResults.getQueryHitCount();
    }

    public int getHiddenCount() {
        return this.hiddenSearchResults.getQueryHitCount();
    }

    public int getProgress() {
        return this.search.getProgress();
    }

    public boolean isSearchFinished() {
        return this.search.isSearchFinished();
    }

    public void startSearching(DefaultSearchProgress searchProgress) {
        this.searchProgress = searchProgress;
        this.search.startSearching(searchProgress);
    }

    public void stopSearching() {
        this.search.stopSearching();
    }

    private void processRules(RemoteFile[] remoteFiles) {
        for (int i = 0; i < this.searchFilterRules.length; ++i) {
            this.searchFilterRules[i].process(this.search, remoteFiles, this.servent);
        }
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(remoteFiles.length);
        for (int j = 0; j < remoteFiles.length; ++j) {
            if (remoteFiles[j].isFilteredRemoved()) continue;
            if (remoteFiles[j].isFilteredHidden()) {
                this.hiddenSearchResults.addQueryHit(remoteFiles[j]);
                continue;
            }
            this.displayedSearchResults.addQueryHit(remoteFiles[j]);
            newHitList.add(remoteFiles[j]);
        }
        if (newHitList.size() > 0) {
            this.searchProgress.incReceivedResultsCount(newHitList.size());
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    @EventTopicSubscriber(topic="phex:search/data")
    public void onSearchDataEvent(String topic, SearchDataEvent event) {
        if (this.search != event.getSource()) {
            return;
        }
        short type = event.getType();
        switch (type) {
            case 1: {
                this.processRules(event.getSearchData());
                break;
            }
            default: {
                this.forwardSearchChangeEvent(event);
            }
        }
    }

    protected void fireSearchStarted() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchFiltered() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent searchChangeEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void forwardSearchChangeEvent(SearchDataEvent searchChangeEvent) {
        SearchDataEvent event = new SearchDataEvent(this, searchChangeEvent.getType(), searchChangeEvent.getSearchData());
        this.eventService.publish("phex:search/data", event);
    }

    private void fireSearchChangeEvent(SearchDataEvent searchChangeEvent) {
        this.eventService.publish("phex:search/data", searchChangeEvent);
    }
}

