/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.event.PhexEventService;
import phex.query.BackgroundSearchContainer;
import phex.query.DefaultSearchProgress;
import phex.query.QueryManager;
import phex.query.RuleFilteredSearch;
import phex.query.Search;
import phex.query.SearchDataEvent;
import phex.rules.Rule;
import phex.rules.condition.FileSizeCondition;
import phex.rules.condition.NotCondition;
import phex.rules.consequence.RemoveFromSearchConsequence;
import phex.servent.Servent;

public class ResearchSetting {
    private final BackgroundSearchContainer searchContainer;
    private long lastResearchStartTime;
    private int noNewResultsCount;
    private int totalResearchCount;
    private String searchTerm;
    private RuleFilteredSearch ruledSearch;
    private boolean hasNewSearchResults;
    private final SWDownloadFile downloadFile;
    private final Servent servent;
    private final PhexEventService eventService;

    public ResearchSetting(SWDownloadFile file, QueryManager queryService, PhexEventService eventService, Servent servent) {
        this.servent = servent;
        this.eventService = eventService;
        this.downloadFile = file;
        this.searchContainer = queryService.getBackgroundSearchContainer();
        eventService.processAnnotations(this);
    }

    public long getLastResearchStartTime() {
        return this.lastResearchStartTime;
    }

    public void setLastResearchStartTime(long time) {
        this.lastResearchStartTime = time;
    }

    public int getNoNewResultsCount() {
        return this.noNewResultsCount;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String term) {
        this.searchTerm = term;
    }

    public String getSHA1() {
        URN searchURN = this.downloadFile.getFileURN();
        if (searchURN == null || !searchURN.isSha1Nid()) {
            return "";
        }
        return searchURN.getNamespaceSpecificString();
    }

    public void startSearch() {
        long currentTime;
        if (this.ruledSearch != null && !this.ruledSearch.isSearchFinished()) {
            return;
        }
        if (this.searchTerm.length() < 2 && this.downloadFile.getFileURN() == null) {
            return;
        }
        this.hasNewSearchResults = false;
        URN queryURN = null;
        if (this.searchTerm.length() < 2 && this.downloadFile.getFileURN() != null) {
            queryURN = this.downloadFile.getFileURN();
        }
        Search search = this.searchContainer.createSearch(this.searchTerm, queryURN);
        Rule rule = new Rule();
        rule.addConsequence(RemoveFromSearchConsequence.INSTANCE);
        rule.addCondition(new NotCondition(new FileSizeCondition(this.downloadFile.getTotalDataSize(), this.downloadFile.getTotalDataSize())));
        this.ruledSearch = new RuleFilteredSearch(search, rule, this.servent, this.eventService);
        DefaultSearchProgress searchProgress = DefaultSearchProgress.createForForMeProgress(queryURN != null);
        this.ruledSearch.startSearching(searchProgress);
        ++this.totalResearchCount;
        this.lastResearchStartTime = currentTime = System.currentTimeMillis();
    }

    public int getTotalResearchCount() {
        return this.totalResearchCount;
    }

    public void stopSearch() {
        if (this.ruledSearch == null || this.ruledSearch.isSearchFinished()) {
            return;
        }
        this.ruledSearch.stopSearching();
    }

    public int getSearchHitCount() {
        return this.ruledSearch.getResultCount();
    }

    public int getSearchProgress() {
        return this.ruledSearch.getProgress();
    }

    public boolean isSearchRunning() {
        if (this.ruledSearch == null) {
            return false;
        }
        return !this.ruledSearch.isSearchFinished();
    }

    @EventTopicSubscriber(topic="phex:search/data")
    public void onSearchDataEvent(String topic, SearchDataEvent event) {
        if (this.ruledSearch != event.getSource()) {
            return;
        }
        if (event.getType() == 4) {
            this.noNewResultsCount = !this.hasNewSearchResults ? ++this.noNewResultsCount : 0;
        }
        if (event.getType() == 1) {
            RemoteFile[] files = event.getSearchData();
            for (int i = 0; i < files.length; ++i) {
                boolean isAdded = this.downloadFile.addDownloadCandidate(files[i]);
                if (!isAdded) continue;
                this.hasNewSearchResults = true;
            }
        }
    }
}

