/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.HostManager;
import phex.query.ResearchServiceConfig;
import phex.query.ResearchSetting;
import phex.servent.Servent;

public class ResearchService {
    private final SwarmingManager downloadService;
    private final ResearchServiceConfig researchConfig;

    public ResearchService(ResearchServiceConfig config, SwarmingManager downloadService) {
        this.downloadService = downloadService;
        this.researchConfig = config;
    }

    public void startResearchSequence() {
        if (!this.researchConfig.isResearchEnabled()) {
            return;
        }
        for (int i = this.downloadService.getDownloadFileCount(); i >= 0; --i) {
            SWDownloadFile file = this.downloadService.getDownloadFile(i);
            if (file == null) continue;
            this.performResearchOnDownload(file);
        }
    }

    private void performResearchOnDownload(SWDownloadFile file) {
        if (file.isDownloadInProgress() || file.isFileCompletedOrMoved() || file.isDownloadStopped()) {
            return;
        }
        this.performResearchOnSetting(file.getResearchSetting(), file);
    }

    private void performResearchOnSetting(ResearchSetting setting, SWDownloadFile downladFile) {
        HostManager hostMgr = Servent.getInstance().getHostService();
        if (hostMgr.getNetworkHostsContainer().getTotalConnectionCount() == 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.isSearchRunning(setting, currentTime)) {
            return;
        }
        if (!this.isTimeForResearch(downladFile, setting, currentTime)) {
            return;
        }
        setting.startSearch();
    }

    private boolean isTimeForResearch(SWDownloadFile downladFile, ResearchSetting setting, long currentTime) {
        long lastResearchStartTime = setting.getLastResearchStartTime();
        int noNewResultsCount = setting.getNoNewResultsCount();
        long researchInterval = this.researchConfig.getResearchIntervalMillis();
        int candidatesCount = downladFile.getCandidatesCount();
        int candidatesThreshold = this.researchConfig.getCandidatesIntervalThreshold();
        int totalResearchCount = setting.getTotalResearchCount();
        long researchPenalty = this.researchConfig.getResearchTimePenalty();
        long thisResearchInterval = researchInterval + researchInterval * (long)noNewResultsCount + researchPenalty * (long)Math.max(0, candidatesCount - candidatesThreshold) + researchPenalty * (long)totalResearchCount;
        long nextResearchTime = lastResearchStartTime + (thisResearchInterval = Math.min(thisResearchInterval, this.researchConfig.getMaxResearchIntervalMillis()));
        return currentTime > nextResearchTime;
    }

    private boolean isSearchRunning(ResearchSetting setting, long currentTime) {
        return setting.isSearchRunning();
    }
}

