/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.SystemUtils;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.msg.QueryMsg;
import phex.msghandling.MessageSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMsgToWriterMonitor
implements MessageSubscriber<QueryMsg> {
    private Writer outputWriter;

    public QueryMsgToWriterMonitor(@NonNull Writer outputWriter) {
        if (outputWriter == null) {
            throw new NullPointerException("Output writer is null.");
        }
        this.outputWriter = outputWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(QueryMsg query, Host sourceHost) {
        String searchString = query.getSearchString();
        if (searchString.length() > 0 && !searchString.equals("\\") && !searchString.startsWith("urn:sha1:")) {
            QueryMsgToWriterMonitor queryMsgToWriterMonitor = this;
            synchronized (queryMsgToWriterMonitor) {
                try {
                    this.outputWriter.write(query.getSearchString());
                    this.outputWriter.write(SystemUtils.LINE_SEPARATOR);
                }
                catch (IOException exp) {
                    NLogger.error(QueryMsgToWriterMonitor.class, exp.getMessage(), exp);
                    this.outputWriter = null;
                }
            }
        }
    }
}

