/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.File;
import java.util.TimerTask;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.host.Host;
import phex.msg.QueryFactory;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.vendor.OOBReplyCountVMsg;
import phex.msghandling.MessageService;
import phex.query.BackgroundSearchContainer;
import phex.query.DynamicQueryEngine;
import phex.query.DynamicQueryWorker;
import phex.query.SearchContainer;
import phex.query.SearchProgress;
import phex.rules.SearchFilterRules;
import phex.servent.Servent;

public class QueryManager
extends AbstractLifeCycle {
    private final Servent servent;
    private final MessageService msgService;
    private final SearchContainer searchContainer;
    private final BackgroundSearchContainer backgroundSearchContainer;
    private final SearchFilterRules searchFilterRules;
    private final DynamicQueryWorker dynamicQueryWorker;
    private final QueryFactory queryFactory;
    private volatile long lastQueryTime = 0L;

    public QueryManager(MessageService msgService, Servent servent) {
        this.servent = servent;
        this.msgService = msgService;
        this.queryFactory = new QueryFactory(servent);
        this.searchContainer = new SearchContainer(this.queryFactory, servent);
        msgService.addMessageSubscriber(QueryResponseMsg.class, this.searchContainer);
        msgService.addUdpMessageSubscriber(OOBReplyCountVMsg.class, this.searchContainer);
        msgService.addUdpMessageSubscriber(QueryResponseMsg.class, this.searchContainer);
        this.backgroundSearchContainer = new BackgroundSearchContainer(this.queryFactory, servent);
        msgService.addMessageSubscriber(QueryResponseMsg.class, this.backgroundSearchContainer);
        File filterFile = servent.getGnutellaNetwork().getSearchFilterFile();
        this.searchFilterRules = new SearchFilterRules(filterFile);
        this.dynamicQueryWorker = new DynamicQueryWorker();
    }

    protected void doStart() {
        this.searchFilterRules.load();
        this.dynamicQueryWorker.startQueryWorker();
        Environment.getInstance().scheduleTimerTask(new ExpiredSearchCheckTimer(), 5000L, 5000L);
    }

    public void doStop() {
        this.searchFilterRules.save();
    }

    public SearchContainer getSearchContainer() {
        return this.searchContainer;
    }

    public BackgroundSearchContainer getBackgroundSearchContainer() {
        return this.backgroundSearchContainer;
    }

    public void removeHostQueries(Host host) {
        if (host.isUltrapeerLeafConnection()) {
            this.dynamicQueryWorker.removeDynamicQuerysForHost(host);
        }
    }

    public DynamicQueryEngine sendDynamicQuery(QueryMsg query, Host sourceHost, SearchProgress searchProgress) {
        DynamicQueryEngine engine = new DynamicQueryEngine(query, sourceHost, searchProgress, this.servent.getHostService().getNetworkHostsContainer(), this.msgService);
        this.dynamicQueryWorker.addDynamicQueryEngine(engine);
        return engine;
    }

    public DynamicQueryEngine sendMyQuery(QueryMsg queryMsg, SearchProgress searchProgress) {
        this.lastQueryTime = System.currentTimeMillis();
        this.msgService.updateMyQueryRouting(queryMsg);
        searchProgress.searchStarted();
        if (this.servent.isUltrapeer()) {
            return this.sendDynamicQuery(queryMsg, Host.LOCAL_HOST, searchProgress);
        }
        this.msgService.forwardMyQueryToUltrapeers(queryMsg);
        return null;
    }

    public long getLastQueryTime() {
        return this.lastQueryTime;
    }

    public SearchFilterRules getSearchFilterRules() {
        return this.searchFilterRules;
    }

    private class ExpiredSearchCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 5000L;

        private ExpiredSearchCheckTimer() {
        }

        public void run() {
            long currentTime = System.currentTimeMillis();
            QueryManager.this.searchContainer.stopExpiredSearches(currentTime);
            QueryManager.this.backgroundSearchContainer.stopExpiredSearches(currentTime);
        }
    }
}

