/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import phex.common.address.DestAddress;
import phex.common.format.HostSpeedFormatUtils;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.query.QHDFlag;
import phex.servent.Servent;
import phex.utils.VendorCodes;

public class QueryHitHost {
    private GUID hostGUID;
    private int hostSpeed;
    private String cachedHostSpeedFormatted;
    private QHDFlag pushNeededFlag;
    private QHDFlag serverBusyFlag;
    private QHDFlag hasUploadedFlag;
    private QHDFlag uploadSpeedFlag;
    private String vendor;
    private boolean isChatSupported;
    private boolean isBrowseHostSupported;
    private short hostRating;
    private DestAddress hostAddress;
    private DestAddress[] pushProxyAddresses;
    private boolean isUdpHost;

    public QueryHitHost(GUID aHostGUID, DestAddress address, int aHostSpeed) {
        this.hostGUID = aHostGUID;
        this.hostAddress = address;
        this.hostSpeed = aHostSpeed;
        this.cachedHostSpeedFormatted = null;
        this.setQHDFlags(QHDFlag.QHD_UNKNOWN_FLAG, QHDFlag.QHD_UNKNOWN_FLAG, QHDFlag.QHD_UNKNOWN_FLAG, QHDFlag.QHD_UNKNOWN_FLAG);
        this.hostRating = (short)-1;
    }

    public boolean isUdpHost() {
        return this.isUdpHost;
    }

    public void setUdpHost(boolean isUdpHost) {
        this.isUdpHost = isUdpHost;
    }

    public DestAddress[] getPushProxyAddresses() {
        return this.pushProxyAddresses;
    }

    public void setPushProxyAddresses(DestAddress[] pushProxyAddresses) {
        this.pushProxyAddresses = pushProxyAddresses;
    }

    public void setVendorCode(String aVendorCode) {
        if (aVendorCode != null) {
            this.vendor = VendorCodes.getVendorName(aVendorCode);
        }
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setChatSupported(boolean state) {
        this.isChatSupported = state;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setBrowseHostSupported(boolean state) {
        this.isBrowseHostSupported = state;
    }

    public boolean isBrowseHostSupported() {
        return this.isBrowseHostSupported;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void setHostGUID(GUID guid) {
        this.hostGUID = guid;
    }

    public int getHostSpeed() {
        return this.hostSpeed;
    }

    public String getFormattedHostSpeed() {
        if (this.cachedHostSpeedFormatted == null) {
            this.cachedHostSpeedFormatted = HostSpeedFormatUtils.formatHostSpeed(this.hostSpeed);
        }
        return this.cachedHostSpeedFormatted;
    }

    public void setHostSpeed(int speed) {
        this.hostSpeed = speed;
        this.cachedHostSpeedFormatted = null;
        this.calculateHostRating();
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setQHDFlags(QHDFlag aPushNeededFlag, QHDFlag aServerBusyFlag, QHDFlag aHasUploadedFlag, QHDFlag aUploadSpeedFlag) {
        this.pushNeededFlag = aPushNeededFlag;
        this.serverBusyFlag = aServerBusyFlag;
        this.hasUploadedFlag = aHasUploadedFlag;
        this.uploadSpeedFlag = aUploadSpeedFlag;
    }

    public boolean isPushNeeded() {
        return this.pushNeededFlag == QHDFlag.QHD_TRUE_FLAG;
    }

    public QHDFlag getPushNeededFlag() {
        return this.pushNeededFlag;
    }

    public QHDFlag getServerBusyFlag() {
        return this.serverBusyFlag;
    }

    public QHDFlag getHasUploadedFlag() {
        return this.hasUploadedFlag;
    }

    public QHDFlag getUploadSpeedFlag() {
        return this.uploadSpeedFlag;
    }

    public short getHostRating() {
        if (this.hostRating == -1) {
            this.calculateHostRating();
        }
        return this.hostRating;
    }

    private void calculateHostRating() {
        Servent servent = Servent.getInstance();
        if (this.pushNeededFlag == QHDFlag.QHD_TRUE_FLAG && servent.isFirewalled()) {
            this.hostRating = 0;
            return;
        }
        if (this.serverBusyFlag == QHDFlag.QHD_TRUE_FLAG) {
            this.hostRating = 1;
            return;
        }
        int tmpHostRating = this.pushNeededFlag == QHDFlag.QHD_TRUE_FLAG ? (this.serverBusyFlag == QHDFlag.QHD_FALSE_FLAG ? 3 : 2) : (this.pushNeededFlag == QHDFlag.QHD_FALSE_FLAG ? (this.serverBusyFlag == QHDFlag.QHD_FALSE_FLAG ? 6 : 5) : (servent.isFirewalled() ? 3 : 4));
        if (this.hasUploadedFlag == QHDFlag.QHD_TRUE_FLAG) {
            tmpHostRating = (short)(tmpHostRating + 2);
        } else if (this.hasUploadedFlag == QHDFlag.QHD_UNKNOWN_FLAG) {
            tmpHostRating = (short)(tmpHostRating + 1);
        }
        this.hostRating = (short)tmpHostRating;
    }

    public static QueryHitHost createFrom(QueryResponseMsg sourceMsg) throws InvalidMessageException {
        QueryHitHost qhh = new QueryHitHost(sourceMsg.getRemoteServentID(), sourceMsg.getDestAddress(), sourceMsg.getRemoteHostSpeed());
        qhh.setQHDFlags(sourceMsg.getPushNeededFlag(), sourceMsg.getServerBusyFlag(), sourceMsg.getHasUploadedFlag(), sourceMsg.getUploadSpeedFlag());
        qhh.setVendorCode(sourceMsg.getVendorCode());
        qhh.setChatSupported(sourceMsg.isChatSupported());
        qhh.setBrowseHostSupported(sourceMsg.isBrowseHostSupported());
        qhh.setPushProxyAddresses(sourceMsg.getPushProxyAddresses());
        qhh.setUdpHost(sourceMsg.isUdpMsg());
        return qhh;
    }
}

