/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.log.NLogger;
import phex.download.RemoteFile;
import phex.host.Host;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.msghandling.MessageSubscriber;
import phex.query.KeywordSearch;
import phex.query.QueryHitHost;
import phex.query.SearchDataEvent;
import phex.query.SearchFilter;
import phex.security.AccessType;
import phex.servent.Servent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredQueryResponseMonitor
implements MessageSubscriber<QueryResponseMsg> {
    private final Servent servent;
    private ArrayList<RemoteFile> queryHitList = new ArrayList();
    private SearchFilter searchFilter;

    public FilteredQueryResponseMonitor(Servent servent) {
        this.servent = servent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePassiveSearchFilter(SearchFilter aSearchFilter) {
        ArrayList<RemoteFile> arrayList = this.queryHitList;
        synchronized (arrayList) {
            this.searchFilter = aSearchFilter;
            if (this.searchFilter != null) {
                this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
            }
        }
    }

    public SearchFilter getPassiveSearchFilter() {
        return this.searchFilter;
    }

    @Override
    public void onMessage(QueryResponseMsg message, Host sourceHost) {
        QueryResponseRecord[] records;
        QueryHitHost qhHost;
        if (this.searchFilter == null) {
            return;
        }
        try {
            qhHost = QueryHitHost.createFrom(message);
            records = message.getMsgRecords();
        }
        catch (InvalidMessageException e) {
            return;
        }
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(records.length);
        for (int i = 0; i < records.length; ++i) {
            if (!this.isResponseRecordValid(records[i]) || this.searchFilter == null) continue;
            this.monitorPassiveSearch(qhHost, records[i], newHitList);
        }
        if (newHitList.size() > 0) {
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    private boolean isResponseRecordValid(QueryResponseRecord record) {
        URN urn = record.getURN();
        if (urn != null && this.servent.getSecurityService().controlUrnAccess(urn) != AccessType.ACCESS_GRANTED) {
            NLogger.debug(FilteredQueryResponseMonitor.class, "Record contains blocked URN: " + urn.getAsString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorPassiveSearch(QueryHitHost qhHost, QueryResponseRecord rec, ArrayList<RemoteFile> newHitList) {
        ArrayList<RemoteFile> arrayList = this.queryHitList;
        synchronized (arrayList) {
            int speed = qhHost.getHostSpeed();
            short hostRating = qhHost.getHostRating();
            long fileSize = rec.getFileSize();
            String filename = rec.getFilename();
            boolean isFiltered = this.searchFilter.isFiltered(fileSize, filename, speed, hostRating);
            if (isFiltered) {
                return;
            }
            URN urn = rec.getURN();
            int fileIndex = rec.getFileIndex();
            String metaData = rec.getMetaData();
            RemoteFile availableHit = this.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
            short score = KeywordSearch.calculateSearchScore(this.searchFilter.getFilterString(), filename);
            if (availableHit != null) {
                availableHit.updateQueryHitHost(qhHost);
                availableHit.setMetaData(metaData);
            } else {
                String pathInfo = rec.getPathInfo();
                RemoteFile rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, score);
                this.queryHitList.add(rfile);
                newHitList.add(rfile);
            }
            DestAddress[] alternateLocations = rec.getAlternateLocations();
            if (urn != null && alternateLocations != null) {
                for (int j = 0; j < alternateLocations.length; ++j) {
                    QueryHitHost qhh = new QueryHitHost(null, alternateLocations[j], -1);
                    availableHit = this.findQueryHit(qhHost, urn, filename, fileSize, fileIndex);
                    if (availableHit != null) {
                        availableHit.updateQueryHitHost(qhHost);
                        availableHit.setMetaData(metaData);
                        continue;
                    }
                    RemoteFile rfile = new RemoteFile(qhh, -1, filename, "", fileSize, urn, metaData, score);
                    this.queryHitList.add(rfile);
                    newHitList.add(rfile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFile findQueryHit(QueryHitHost qhh, URN urn, String fileName, long fileSize, int fileIndex) {
        GUID hostGUID = qhh.getHostGUID();
        DestAddress hostAddress = qhh.getHostAddress();
        ArrayList<RemoteFile> arrayList = this.queryHitList;
        synchronized (arrayList) {
            int size = this.queryHitList.size();
            for (int i = 0; i < size; ++i) {
                DestAddress fileHostAddress;
                RemoteFile file = this.queryHitList.get(i);
                GUID fileHostGUID = file.getRemoteClientID();
                if (fileHostGUID == null || hostGUID == null ? !(fileHostAddress = file.getHostAddress()).equals(hostAddress) : !fileHostGUID.equals(hostGUID)) continue;
                if (urn != null && file.getURN() != null) {
                    if (!urn.equals(file.getURN())) continue;
                    return file;
                }
                if (fileIndex != file.getFileIndex() || fileSize != file.getFileSize() || !fileName.equals(file.getFilename())) continue;
                return file;
            }
        }
        return null;
    }

    protected void fireSearchHitsAdded(RemoteFile[] newHits) {
        SearchDataEvent dataEvent = new SearchDataEvent(this, 1, newHits);
        this.fireSearchDataEvent(dataEvent);
    }

    private void fireSearchDataEvent(SearchDataEvent searchDataEvent) {
        this.servent.getEventService().publish("phex:search/monitor/results", searchDataEvent);
    }
}

