/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.QueryRoutingTable;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.msg.QueryMsg;
import phex.msghandling.MessageService;
import phex.query.DynamicQueryConstants;
import phex.query.SearchProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicQueryEngine
implements DynamicQueryConstants {
    private static final Logger logger = LoggerFactory.getLogger(DynamicQueryEngine.class);
    private final NetworkHostsContainer hostsContainer;
    private final MessageService messageService;
    private boolean isDynamicQueryStarted;
    private boolean isDynamicQueryStopped;
    private boolean isProbeQuerySent;
    private long queryStartTime;
    private long nextProcessTime;
    private int timeToWaitPerHop;
    private int timeToDecreasePerHop;
    private int decrementCount;
    private int estimatedQueriedHorizon;
    private List<Host> queriedHosts;
    private QueryMsg query;
    private final Host sourceHost;
    private final SearchProgress searchProgress;

    public DynamicQueryEngine(QueryMsg query, Host sourceHost, SearchProgress searchProgress, NetworkHostsContainer hostsContainer, MessageService messageService) {
        this.hostsContainer = hostsContainer;
        this.messageService = messageService;
        this.query = query;
        this.sourceHost = sourceHost;
        this.searchProgress = searchProgress;
        this.isDynamicQueryStarted = false;
        this.isDynamicQueryStopped = false;
        this.isProbeQuerySent = false;
        this.timeToWaitPerHop = 2400;
        this.timeToDecreasePerHop = 10;
        this.estimatedQueriedHorizon = 1;
        this.queriedHosts = new ArrayList<Host>();
    }

    public void stopQuery() {
        this.isDynamicQueryStopped = true;
    }

    public Host getFromHost() {
        return this.sourceHost;
    }

    public boolean isQueryFinished() {
        if (!this.isDynamicQueryStarted) {
            return false;
        }
        if (this.isDynamicQueryStopped) {
            return true;
        }
        if (this.searchProgress.isSearchFinished()) {
            return true;
        }
        return this.estimatedQueriedHorizon > 200000;
    }

    public int getProgress() {
        if (!this.isDynamicQueryStarted) {
            return 0;
        }
        if (this.isDynamicQueryStopped) {
            return 100;
        }
        int horizonProgress = (int)((double)this.estimatedQueriedHorizon / 200000.0 * 100.0);
        return Math.min(horizonProgress, 100);
    }

    public void processQuery() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextProcessTime || this.isQueryFinished()) {
            return;
        }
        if (!this.isDynamicQueryStarted) {
            this.isDynamicQueryStarted = true;
            this.queryStartTime = currentTime;
            this.searchProgress.searchStarted();
            boolean sentToLeaves = this.processQueryToLeaves();
            if (sentToLeaves) {
                this.nextProcessTime = System.currentTimeMillis() + (long)this.timeToWaitPerHop;
                return;
            }
        }
        if (!this.isProbeQuerySent) {
            this.processProbeQuery();
        } else {
            this.processStandardQuery();
        }
    }

    private void processStandardQuery() {
        QueryRoutingTable qrt;
        int degree;
        Host[] ultrapeers = this.hostsContainer.getUltrapeerConnections();
        int notQueriedHosts = 0;
        Host hostToQuery = null;
        for (Host up : ultrapeers) {
            if (!up.isConnectionStable() || this.queriedHosts.contains(up)) continue;
            ++notQueriedHosts;
            hostToQuery = up;
        }
        if (notQueriedHosts == 0 || hostToQuery == null) {
            this.nextProcessTime = System.currentTimeMillis() + 5000L;
            logger.debug("No host to query.");
            return;
        }
        byte maxTTL = hostToQuery.getMaxTTL();
        byte ttl = this.calculateTTL(maxTTL, degree = hostToQuery.getUltrapeerDegree(), notQueriedHosts);
        if (ttl == 1 && hostToQuery.isUPQueryRoutingSupported() && ((qrt = hostToQuery.getLastReceivedRoutingTable()) == null || !qrt.containsQuery(this.query))) {
            ttl = 2;
        }
        QueryMsg newQuery = new QueryMsg(this.query, ttl);
        logger.debug("Send out query: ttl:{}, degree:{}", (Object)ttl, (Object)degree);
        hostToQuery.queueMessageToSend(newQuery);
        this.queriedHosts.add(hostToQuery);
        this.estimatedQueriedHorizon += DynamicQueryEngine.calculateEstimatedHorizon(degree, ttl);
        logger.debug("New est. horizon {}", (Object)this.estimatedQueriedHorizon);
        this.nextProcessTime = System.currentTimeMillis() + (long)(ttl * this.timeToWaitPerHop);
        this.adjustTimeToWaitPerHop();
    }

    private void processProbeQuery() {
        Host[] ultrapeers = this.hostsContainer.getUltrapeerConnections();
        ArrayList<Host> directHitList = new ArrayList<Host>(ultrapeers.length);
        ArrayList<Host> failedList = new ArrayList<Host>(ultrapeers.length);
        for (Host up : ultrapeers) {
            QueryRoutingTable qrt = up.getLastReceivedRoutingTable();
            if (up.isUPQueryRoutingSupported() && qrt != null) {
                if (qrt.containsQuery(this.query)) {
                    directHitList.add(up);
                    continue;
                }
                failedList.add(up);
                continue;
            }
            failedList.add(0, up);
        }
        int directProbeSize = directHitList.size();
        int failedProbeSize = 0;
        int toIdx = Math.min(10, directProbeSize);
        this.sendProbeQueryToHosts(directHitList.subList(0, toIdx), (byte)1);
        directProbeSize = toIdx;
        if (directProbeSize < 4) {
            toIdx = Math.min(3, failedList.size());
            this.sendProbeQueryToHosts(failedList.subList(0, toIdx), (byte)2);
            failedProbeSize = toIdx;
        }
        this.nextProcessTime = System.currentTimeMillis() + (long)(this.timeToWaitPerHop * (directProbeSize + failedProbeSize));
        this.isProbeQuerySent = true;
    }

    private boolean processQueryToLeaves() {
        QueryRoutingTable qrt = this.messageService.getLastSentQueryRoutingTable();
        if (qrt != null && qrt.containsQuery(this.query)) {
            QueryMsg newQuery = new QueryMsg(this.query, 1);
            this.estimatedQueriedHorizon += this.hostsContainer.getLeafConnectionCount();
            this.messageService.forwardQueryToLeaves(newQuery, this.sourceHost);
            return true;
        }
        return false;
    }

    public void sendProbeQueryToHosts(List<Host> hostList, byte ttl) {
        QueryMsg newQuery = new QueryMsg(this.query, 1);
        for (Host host : hostList) {
            host.queueMessageToSend(newQuery);
            this.queriedHosts.add(host);
            int degree = host.getUltrapeerDegree();
            this.estimatedQueriedHorizon += DynamicQueryEngine.calculateEstimatedHorizon(degree, ttl);
        }
    }

    private static int calculateEstimatedHorizon(int degree, byte ttl) {
        int hostCount = 0;
        while (ttl > 0) {
            hostCount = (int)((double)hostCount + Math.pow(degree - 1, ttl - 1));
            ttl = (byte)(ttl - 1);
        }
        return hostCount;
    }

    private byte calculateTTL(byte maxTTL, int degree, int connectionCount) {
        int desiredResults = this.searchProgress.getDesiredResultsCount();
        int receivedResults = this.searchProgress.getReceivedResultsCount();
        double resultsPerHost = (double)receivedResults / (double)this.estimatedQueriedHorizon;
        int missingResults = desiredResults - receivedResults;
        int hostsNeededToQuery = resultsPerHost > 0.0 ? (int)((double)missingResults / resultsPerHost) : 50000;
        int hostsPerConnection = hostsNeededToQuery / connectionCount;
        for (byte i = 1; i < maxTTL; i = (byte)(i + 1)) {
            int hosts = (int)(16.0 * (double)DynamicQueryEngine.calculateEstimatedHorizon(degree, i));
            if (hosts < hostsPerConnection) continue;
            return i;
        }
        return maxTTL;
    }

    private void adjustTimeToWaitPerHop() {
        if (this.timeToWaitPerHop > 100 && System.currentTimeMillis() - this.queryStartTime > 6000L) {
            this.timeToWaitPerHop -= this.timeToDecreasePerHop;
            if (this.timeToWaitPerHop < 100) {
                this.timeToWaitPerHop = 100;
                return;
            }
            int desiredResults = this.searchProgress.getDesiredResultsCount();
            int receivedResults = this.searchProgress.getReceivedResultsCount();
            int resFactor = Math.max(1, desiredResults / 2 - 30 * receivedResults);
            int decFactor = Math.max(1, this.decrementCount / 6);
            this.timeToDecreasePerHop += Math.max(5, resFactor * decFactor);
            ++this.decrementCount;
        }
    }
}

