/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.Environment;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.BrowseHostConnection;
import phex.connection.BrowseHostException;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.query.SearchProgress;
import phex.servent.Servent;

public class BrowseHostResults
extends Search {
    private static final Logger logger = LoggerFactory.getLogger(BrowseHostResults.class);
    private final DestAddress destAddress;
    private final GUID hostGUID;
    private BrowseHostStatus browseHostStatus;

    public BrowseHostResults(Servent servent, DestAddress hostAddress, GUID aHostGUID) {
        super(servent);
        this.destAddress = hostAddress;
        this.hostGUID = aHostGUID;
        this.browseHostStatus = BrowseHostStatus.INITIALIZING;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public GUID getHostGUID() {
        return this.hostGUID;
    }

    public void startSearching(SearchProgress searchProgress) {
        this.isSearchFinished = false;
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BrowseHostConnection connection = new BrowseHostConnection(BrowseHostResults.this.servent, BrowseHostResults.this.destAddress, BrowseHostResults.this.hostGUID, BrowseHostResults.this);
                try {
                    connection.sendBrowseHostRequest();
                    BrowseHostResults.this.browseHostStatus = BrowseHostStatus.FINISHED;
                }
                catch (BrowseHostException exp) {
                    logger.warn(exp.toString(), (Throwable)exp);
                    BrowseHostResults.this.browseHostStatus = BrowseHostStatus.BROWSE_HOST_ERROR;
                }
                catch (IOException exp) {
                    logger.warn(exp.toString(), (Throwable)exp);
                    BrowseHostResults.this.browseHostStatus = BrowseHostStatus.CONNECTION_ERROR;
                }
                finally {
                    BrowseHostResults.this.stopSearching();
                }
            }
        };
        Environment.getInstance().executeOnThreadPool(runner, "BrowseHostConnection-" + Integer.toHexString(runner.hashCode()));
        this.fireSearchStarted();
    }

    public void setBrowseHostStatus(BrowseHostStatus status) {
        if (status == null) {
            throw new NullPointerException();
        }
        this.browseHostStatus = status;
    }

    public BrowseHostStatus getBrowseHostStatus() {
        return this.browseHostStatus;
    }

    public void stopSearching() {
        this.isSearchFinished = true;
        this.fireSearchStoped();
    }

    public int getProgress() {
        switch (this.browseHostStatus) {
            case INITIALIZING: {
                return 0;
            }
            case CONNECTING: {
                return 10;
            }
            case FETCHING: {
                return 50;
            }
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(QueryResponseMsg msg) throws InvalidMessageException {
        QueryHitHost qhHost = QueryHitHost.createFrom(msg);
        QueryResponseRecord[] records = msg.getMsgRecords();
        ArrayList<RemoteFile> newHitList = new ArrayList<RemoteFile>(records.length);
        for (int i = 0; i < records.length; ++i) {
            if (!this.isResponseRecordValid(records[i])) continue;
            BrowseHostResults browseHostResults = this;
            synchronized (browseHostResults) {
                long fileSize = records[i].getFileSize();
                String filename = records[i].getFilename();
                URN urn = records[i].getURN();
                int fileIndex = records[i].getFileIndex();
                String metaData = records[i].getMetaData();
                String pathInfo = records[i].getPathInfo();
                RemoteFile rfile = new RemoteFile(qhHost, fileIndex, filename, pathInfo, fileSize, urn, metaData, 100);
                this.searchResultHolder.addQueryHit(rfile);
                newHitList.add(rfile);
                continue;
            }
        }
        if (newHitList.size() > 0) {
            RemoteFile[] newHits = new RemoteFile[newHitList.size()];
            newHitList.toArray(newHits);
            this.fireSearchHitsAdded(newHits);
        }
    }

    public String toString() {
        return "[BrowseHostResults:" + this.destAddress + "," + "@" + Integer.toHexString(this.hashCode()) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BrowseHostStatus {
        INITIALIZING,
        CONNECTING,
        FETCHING,
        FINISHED,
        CONNECTION_ERROR,
        BROWSE_HOST_ERROR;

    }
}

