/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xsocket.IDataSource;
import org.xsocket.datagram.Endpoint;
import org.xsocket.datagram.IDatagramHandler;
import org.xsocket.datagram.IEndpoint;
import org.xsocket.datagram.UserDatagram;
import phex.common.Environment;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.net.UdpDataHandler;
import phex.utils.IOUtil;

public class UdpService
implements IDatagramHandler {
    private static final int RECV_SEND_BUFFER_SIZE = 65536;
    private static final Logger logger = LoggerFactory.getLogger(UdpService.class);
    private final InetAddress bindAddress;
    private final int bindPort;
    private UdpDataHandler udpDataHandler;
    private volatile boolean isRunning;
    private IEndpoint endpoint;

    public UdpService(int bindPort) {
        this(null, bindPort, null);
    }

    public UdpService(int bindPort, UdpDataHandler udpDataHandler) {
        this(null, bindPort, udpDataHandler);
    }

    public UdpService(InetAddress bindAddress, int bindPort) {
        this(bindAddress, bindPort, null);
    }

    public UdpService(InetAddress bindAddress, int bindPort, UdpDataHandler udpDataHandler) {
        this.bindAddress = bindAddress;
        this.bindPort = bindPort;
        this.udpDataHandler = udpDataHandler;
    }

    public void setUdpDataHandler(UdpDataHandler udpDataHandler) {
        this.udpDataHandler = udpDataHandler;
    }

    public synchronized void startup() throws IOException {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.endpoint = new Endpoint(65536, (IDatagramHandler)this, Environment.getInstance().getThreadPool(), this.bindAddress, this.bindPort);
    }

    public synchronized void shutdown() {
        if (!this.isRunning) {
            return;
        }
        IOUtil.closeQuietly((Closeable)this.endpoint);
        this.isRunning = false;
    }

    public void sendDatagram(byte[] data, DestAddress address) throws IOException {
        SocketAddress socketAddress = AddressUtils.createSocketAddress(address);
        UserDatagram datagram = new UserDatagram(socketAddress, data);
        logger.debug("Sending Datagram {}", (Object)datagram);
        this.endpoint.send(datagram);
    }

    public boolean onDatagram(IEndpoint rcvEndpoint) {
        try {
            UserDatagram datagram = rcvEndpoint.receive();
            if (this.udpDataHandler != null) {
                DefaultDestAddress addr = new DefaultDestAddress(datagram.getRemoteAddress().getAddress(), datagram.getRemotePort());
                this.udpDataHandler.handleUdpData((IDataSource)datagram, addr);
            }
            return true;
        }
        catch (Exception exp) {
            logger.error(exp.toString(), (Throwable)exp);
            throw new RuntimeException(exp);
        }
    }
}

