/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.Environment;
import phex.common.QueryRoutingTable;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.host.Host;
import phex.host.HostManager;
import phex.io.buffer.ByteBuffer;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongFactory;
import phex.msg.PongMsg;
import phex.msg.PushRequestMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msg.vendor.PushProxyAcknowledgementVMsg;
import phex.msg.vendor.PushProxyRequestVMsg;
import phex.msg.vendor.TCPConnectBackRedirectVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMsg;
import phex.msghandling.MessageRouting;
import phex.msghandling.MessageSubscriber;
import phex.msghandling.MessageSubscriberList;
import phex.msghandling.UdpMessageSubscriber;
import phex.msghandling.UdpMessageSubscriberList;
import phex.net.connection.Connection;
import phex.net.connection.ConnectionFactory;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.MessagePrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.upload.PushWorker;
import phex.utils.HexConverter;
import phex.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(MessageDispatcher.class);
    private final Servent servent;
    private final MessageRouting msgRouting;
    private final Map<Class<? extends Message>, MessageSubscriber<? extends Message>> messageSubscribers;
    private final Map<Class<? extends Message>, UdpMessageSubscriber<? extends Message>> udpMessageSubscribers;
    private final PongFactory pongFactory;
    private final SharedFilesService sharedFilesService;
    private final HostManager hostMgr;
    private final PhexSecurityManager securityService;
    private SimpleStatisticProvider pingMsgInCounter;
    private SimpleStatisticProvider pongMsgInCounter;
    private SimpleStatisticProvider queryMsgInCounter;
    private SimpleStatisticProvider queryHitMsgInCounter;
    private SimpleStatisticProvider pushMsgInCounter;
    private SimpleStatisticProvider dropedMsgInCounter;
    private SimpleStatisticProvider totalInMsgCounter;
    private StatisticProvider uptimeStatsProvider;

    public MessageDispatcher(Servent servent, MessageRouting msgRouting, PongFactory pongFactory) {
        this.servent = servent;
        this.msgRouting = msgRouting;
        this.pongFactory = pongFactory;
        this.messageSubscribers = new HashMap<Class<? extends Message>, MessageSubscriber<? extends Message>>();
        this.udpMessageSubscribers = new HashMap<Class<? extends Message>, UdpMessageSubscriber<? extends Message>>();
        this.hostMgr = servent.getHostService();
        this.sharedFilesService = servent.getSharedFilesService();
        this.securityService = servent.getSecurityService();
    }

    protected void initStats(StatisticsManager statsMgr) {
        this.pingMsgInCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("PingMsgInProvider");
        this.pongMsgInCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("PongMsgInProvider");
        this.queryMsgInCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("QueryMsgInProvider");
        this.queryHitMsgInCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("QueryHitMsgInProvider");
        this.pushMsgInCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("PushMsgInProvider");
        this.dropedMsgInCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("DropedMsgInProvider");
        this.totalInMsgCounter = (SimpleStatisticProvider)statsMgr.getStatisticProvider("TotalMsgInProvider");
        this.uptimeStatsProvider = statsMgr.getStatisticProvider("DailyUptimeProvider");
    }

    public <T extends Message> void addMessageSubscriber(Class<T> clazz, MessageSubscriber<T> subscriber) {
        logger.debug("Adding MessageSubscriber {} for type {}.", subscriber, clazz);
        MessageSubscriber<? extends Message> registeredSubscriber = this.messageSubscribers.get(clazz);
        if (registeredSubscriber == null) {
            this.messageSubscribers.put(clazz, subscriber);
        } else if (registeredSubscriber instanceof MessageSubscriberList) {
            ((MessageSubscriberList)registeredSubscriber).addSubscriber(subscriber);
        } else {
            MessageSubscriberList<? extends Message> list = new MessageSubscriberList<Message>(registeredSubscriber, subscriber);
            this.messageSubscribers.put(clazz, list);
        }
    }

    public <T extends Message> void removeMessageSubscriber(Class<T> clazz, MessageSubscriber<T> subscriber) {
        logger.debug("Removing MessageSubscriber {} for type {}.", subscriber, clazz);
        MessageSubscriber<? extends Message> registeredSubscriber = this.messageSubscribers.get(clazz);
        if (registeredSubscriber instanceof MessageSubscriberList) {
            ((MessageSubscriberList)registeredSubscriber).removeSubscriber(subscriber);
        } else {
            this.messageSubscribers.remove(clazz);
        }
    }

    private void dispatchToSubscribers(Message message, Host sourceHost) throws InvalidMessageException {
        MessageSubscriber<? extends Message> messageSubscriber = this.messageSubscribers.get(message.getClass());
        messageSubscriber.onMessage(message, sourceHost);
    }

    public <T extends Message> void addUdpMessageSubscriber(Class<? extends Message> clazz, UdpMessageSubscriber<T> subscriber) {
        logger.debug("Adding MessageSubscriber {} for type {}.", subscriber, clazz);
        UdpMessageSubscriber<? extends Message> registeredSubscriber = this.udpMessageSubscribers.get(clazz);
        if (registeredSubscriber == null) {
            this.udpMessageSubscribers.put(clazz, subscriber);
        } else if (registeredSubscriber instanceof UdpMessageSubscriberList) {
            ((UdpMessageSubscriberList)registeredSubscriber).addSubscriber(subscriber);
        } else {
            UdpMessageSubscriberList<? extends Message> list = new UdpMessageSubscriberList<Message>(registeredSubscriber, subscriber);
            this.udpMessageSubscribers.put(clazz, list);
        }
    }

    public <T extends Message> void removeUdpMessageSubscriber(Class<T> clazz, UdpMessageSubscriber<T> subscriber) {
        logger.debug("Removing MessageSubscriber {} for type {}.", subscriber, clazz);
        UdpMessageSubscriber<? extends Message> registeredSubscriber = this.udpMessageSubscribers.get(clazz);
        if (registeredSubscriber instanceof UdpMessageSubscriberList) {
            ((UdpMessageSubscriberList)registeredSubscriber).removeSubscriber(subscriber);
        } else {
            this.udpMessageSubscribers.remove(clazz);
        }
    }

    protected void dispatchToUdpSubscribers(Message message, DestAddress sourceAddress) throws InvalidMessageException {
        UdpMessageSubscriber<? extends Message> messageSubscriber = this.udpMessageSubscribers.get(message.getClass());
        messageSubscriber.onUdpMessage(message, sourceAddress);
    }

    public void handlePing(PingMsg pingMsg, Host sourceHost) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received Ping: " + pingMsg.toString() + " - " + pingMsg.getHeader().toString());
        }
        this.pingMsgInCounter.increment(1);
        MsgHeader header = pingMsg.getHeader();
        if (!this.msgRouting.checkAndAddToPingRoutingTable(header.getMsgID(), sourceHost)) {
            this.dropMessage(pingMsg, "Dropping already seen ping", sourceHost);
            return;
        }
        this.respondToPing(pingMsg, sourceHost);
    }

    private void respondToPing(PingMsg pingMsg, Host sourceHost) {
        byte hops;
        MsgHeader header = pingMsg.getHeader();
        byte ttl = header.getTTL();
        if (ttl + (hops = header.getHopsTaken()) > 2 && !this.hostMgr.areIncommingSlotsAdvertised()) {
            return;
        }
        if (hops == 1 && ttl == 1) {
            Host[] leafs = this.hostMgr.getNetworkHostsContainer().getLeafConnections();
            for (int i = 0; i < leafs.length; ++i) {
                DestAddress ha = leafs[i].getHostAddress();
                PongMsg pong = this.pongFactory.createOtherLeafsOutgoingPong(header.getMsgID(), (byte)1, (byte)1, ha);
                sourceHost.queueMessageToSend(pong);
            }
        }
        byte by = hops;
        hops = (byte)(hops + 1);
        byte newTTL = by;
        if (hops + ttl <= 2) {
            newTTL = 1;
        }
        int avgDailyUptime = (Integer)this.uptimeStatsProvider.getValue();
        int shareFileCount = this.sharedFilesService.getFileCount();
        int shareFileSize = this.sharedFilesService.getTotalFileSizeInKb();
        PongMsg pong = this.pongFactory.createMyOutgoingPong(header.getMsgID(), this.servent.getLocalAddress(), newTTL, shareFileCount, shareFileSize, this.servent.isUltrapeer(), avgDailyUptime);
        sourceHost.queueMessageToSend(pong);
        DestAddress orginAddress = sourceHost.getHostAddress();
        IpAddress ip = orginAddress.getIpAddress();
        if (ip == null) {
            return;
        }
        GUID guid = header.getMsgID();
        List<PongMsg> pongs = this.servent.getMessageService().getCachedPongs();
        for (PongMsg pMsg : pongs) {
            if (ip.equals(pMsg.getPongAddress().getIpAddress())) continue;
            sourceHost.queueMessageToSend(this.pongFactory.createFromCachePong(guid, newTTL, pMsg));
        }
    }

    public void handlePong(PongMsg msg, Host sourceHost) {
        DestAddress connectedAddress;
        IpAddress connectedIP;
        byte hopsTaken;
        boolean isNew;
        if (logger.isDebugEnabled()) {
            logger.debug("Received Pong: " + msg.getDebugString() + " - " + msg.getHeader().toString());
        }
        this.pongMsgInCounter.increment(1);
        DestAddress pongAddress = msg.getPongAddress();
        AccessType access = this.securityService.controlHostAddressAccess(pongAddress);
        if (access == AccessType.ACCESS_STRONGLY_DENIED) {
            this.dropMessage(msg, "IP access strongly denied.", sourceHost);
            return;
        }
        try {
            this.dispatchToSubscribers(msg, sourceHost);
        }
        catch (InvalidMessageException exp) {
            this.dropMessage(msg, exp.getMessage(), sourceHost);
            return;
        }
        if (access == AccessType.ACCESS_GRANTED && (isNew = this.hostMgr.catchHosts(msg))) {
            this.servent.getMessageService().addPongToCache(msg);
        }
        if ((hopsTaken = msg.getHeader().getHopsTaken()) == 1 && (connectedIP = (connectedAddress = sourceHost.getHostAddress()).getIpAddress()).equals(pongAddress.getIpAddress())) {
            sourceHost.setFileCount(msg.getFileCount());
            sourceHost.setTotalFileSize(msg.getFileSizeInKB());
            int connectedPort = connectedAddress.getPort();
            int pongPort = pongAddress.getPort();
            if (connectedPort != pongPort) {
                sourceHost.setHostAddress(new DefaultDestAddress(connectedAddress.getIpAddress(), pongPort));
            }
        }
        if (msg.getHeader().getTTL() > 0) {
            this.msgRouting.routePongMessage(msg);
        }
    }

    public void handleQuery(QueryMsg msg, Host sourceHost) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received Query: " + msg.toString() + " - " + msg.getHeader().toString());
        }
        this.queryMsgInCounter.increment(1);
        MsgHeader header = msg.getHeader();
        if (!this.msgRouting.checkAndAddToQueryRoutingTable(header.getMsgID(), sourceHost)) {
            this.dropMessage(msg, "Drop already seen query", sourceHost);
            return;
        }
        if (sourceHost.isUltrapeerLeafConnection() && header.getHopsTaken() > 2) {
            this.dropMessage(msg, "Drop query from leaf with hops > 2.", sourceHost);
        }
        if (MessagePrefs.DropIndexQueries.get().booleanValue() && "    ".equals(msg.getSearchString())) {
            this.dropMessage(msg, "Drop index query.", sourceHost);
        }
        try {
            this.dispatchToSubscribers(msg, sourceHost);
        }
        catch (InvalidMessageException exp) {
            this.dropMessage(msg, exp.getMessage(), sourceHost);
            return;
        }
        List<ShareFile> resultFiles = this.sharedFilesService.handleQuery(msg);
        if (resultFiles == null || resultFiles.size() == 0) {
            return;
        }
        this.respondToQuery(header, resultFiles, sourceHost);
    }

    private void respondToQuery(MsgHeader header, List<ShareFile> resultFiles, Host sourceHost) {
        MsgHeader newHeader = new MsgHeader(header.getMsgID(), -127, (byte)(header.getHopsTaken() + 1), 0, 0);
        int resultCount = resultFiles.size();
        if (resultCount > 255) {
            resultFiles.subList(0, 255);
            resultCount = resultFiles.size();
        }
        assert (resultCount < 255);
        QueryResponseRecord[] records = new QueryResponseRecord[resultCount];
        int recPos = 0;
        for (ShareFile shareFile : resultFiles) {
            QueryResponseRecord record;
            records[recPos] = record = QueryResponseRecord.createFromShareFile(shareFile, this.servent.getLocalAddress());
            ++recPos;
        }
        DestAddress hostAddress = this.servent.getLocalAddress();
        GUID serventGuid = this.servent.getServentGuid();
        QueryResponseMsg response = new QueryResponseMsg(newHeader, serventGuid, hostAddress, Math.round(BandwidthPrefs.MaxUploadBandwidth.get().floatValue() / 1024.0f), records, this.hostMgr.getNetworkHostsContainer().getPushProxies(), !this.servent.isFirewalled(), this.servent.isUploadLimitReached());
        sourceHost.queueMessageToSend(response);
    }

    public void handleQueryResponse(QueryResponseMsg queryResponseMsg, Host sourceHost) {
        this.queryHitMsgInCounter.increment(1);
        MsgHeader header = queryResponseMsg.getHeader();
        GUID respServentId = queryResponseMsg.getRemoteServentID();
        if (respServentId.equals(this.servent.getServentGuid())) {
            this.dropMessage(queryResponseMsg, "My query response should never reach me.", sourceHost);
            return;
        }
        if (respServentId.equals(header.getMsgID())) {
            this.dropMessage(queryResponseMsg, "Message id equals servent id.", sourceHost);
            return;
        }
        if (respServentId.equals(GUID.EMPTY_GUID)) {
            this.dropMessage(queryResponseMsg, "Servent id is empty.", sourceHost);
            return;
        }
        DestAddress queryAddress = queryResponseMsg.getDestAddress();
        AccessType access = this.securityService.controlHostAddressAccess(queryAddress);
        if (access == AccessType.ACCESS_STRONGLY_DENIED) {
            this.dropMessage(queryResponseMsg, "IP access strongly denied.", sourceHost);
            return;
        }
        if (access == AccessType.ACCESS_GRANTED) {
            try {
                this.dispatchToSubscribers(queryResponseMsg, sourceHost);
            }
            catch (InvalidMessageException exp) {
                this.dropMessage(queryResponseMsg, exp.getMessage(), sourceHost);
                return;
            }
        }
        if (header.getTTL() > 0) {
            try {
                this.msgRouting.routeQueryResponse(queryResponseMsg, sourceHost);
            }
            catch (InvalidMessageException exp) {
                this.dropMessage(queryResponseMsg, exp.getMessage(), sourceHost);
                return;
            }
        }
    }

    public void handleRouteTableUpdate(RouteTableUpdateMsg message, Host sourceHost) {
        this.totalInMsgCounter.increment(1);
        if (!sourceHost.isQueryRoutingSupported() && !sourceHost.isUPQueryRoutingSupported()) {
            this.dropMessage(message, "QRP not supported from host.", sourceHost);
            return;
        }
        QueryRoutingTable qrTable = sourceHost.getLastReceivedRoutingTable();
        if (qrTable == null) {
            qrTable = new QueryRoutingTable();
            sourceHost.setLastReceivedRoutingTable(qrTable);
        }
        try {
            qrTable.updateRouteTable(message, sourceHost);
            if (sourceHost.isUltrapeerLeafConnection()) {
                this.servent.getMessageService().triggerQueryRoutingTableUpdate();
            }
        }
        catch (InvalidMessageException exp) {
            this.dropMessage(message, "Invalid QRT update message.", sourceHost);
        }
    }

    public void handleVendorMessage(VendorMsg vendorMsg, Host sourceHost) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received VendorMsg: " + vendorMsg.toString() + " - " + vendorMsg.getHeader().toString());
        }
        if (vendorMsg instanceof MessagesSupportedVMsg) {
            this.handleMessagesSupportedVMsg((MessagesSupportedVMsg)vendorMsg, sourceHost);
        } else if (vendorMsg instanceof TCPConnectBackVMsg) {
            this.handleTCPConnectBackVMsg((TCPConnectBackVMsg)vendorMsg, sourceHost);
        } else if (vendorMsg instanceof TCPConnectBackRedirectVMsg) {
            this.handleTCPConnectBackRedirectVMsg((TCPConnectBackRedirectVMsg)vendorMsg, sourceHost);
        } else if (vendorMsg instanceof PushProxyRequestVMsg) {
            this.handlePushProxyRequestVMsg((PushProxyRequestVMsg)vendorMsg, sourceHost);
        } else if (vendorMsg instanceof PushProxyAcknowledgementVMsg) {
            this.handlePushProxyAcknowledgementVMsg((PushProxyAcknowledgementVMsg)vendorMsg, sourceHost);
        } else if (vendorMsg instanceof HopsFlowVMsg) {
            this.handleHopsFlowVMsg((HopsFlowVMsg)vendorMsg, sourceHost);
        } else if (vendorMsg instanceof CapabilitiesVMsg) {
            this.handleCapabilitiesVMsg((CapabilitiesVMsg)vendorMsg, sourceHost);
        }
    }

    private void handleMessagesSupportedVMsg(MessagesSupportedVMsg msg, Host sourceHost) {
        sourceHost.setSupportedVMsgs(msg);
        boolean isFirewalled = this.servent.isFirewalled();
        if ((sourceHost.isLeafUltrapeerConnection() || isFirewalled && sourceHost.isUltrapeer()) && sourceHost.isPushProxySupported()) {
            PushProxyRequestVMsg pprmsg = new PushProxyRequestVMsg(this.servent.getServentGuid());
            if (sourceHost.getVendor() != null && sourceHost.getVendor().indexOf("LimeWire") != -1) {
                pprmsg.setVersion(1);
            }
            sourceHost.queueMessageToSend(pprmsg);
        }
        if (isFirewalled && this.servent.getMessageService().isTCPRedirectAllowed() && sourceHost.isTCPConnectBackSupported()) {
            DestAddress localAddress = this.servent.getLocalAddress();
            TCPConnectBackVMsg tcpConnectBack = new TCPConnectBackVMsg(localAddress.getPort());
            sourceHost.queueMessageToSend(tcpConnectBack);
            this.servent.getMessageService().incNumberOfTCPRedirectsSent();
        }
    }

    private void handleCapabilitiesVMsg(CapabilitiesVMsg msg, Host sourceHost) {
        sourceHost.setCapabilitiesVMsgs(msg);
    }

    private void handleTCPConnectBackVMsg(TCPConnectBackVMsg msg, Host sourceHost) {
        int port = msg.getPort();
        DestAddress address = sourceHost.getHostAddress();
        if (address.getPort() != port) {
            address = new DefaultDestAddress(address.getHostName(), port);
        }
        TCPConnectBackRedirectVMsg redirectMsg = new TCPConnectBackRedirectVMsg(address);
        Host[] hosts = this.hostMgr.getNetworkHostsContainer().getUltrapeerConnections();
        int sentCount = 0;
        for (int i = 0; sentCount <= 5 && i < hosts.length; ++i) {
            if (sourceHost == hosts[i] || !hosts[i].isTCPConnectBackRedirectSupported()) continue;
            hosts[i].queueMessageToSend(redirectMsg);
            ++sentCount;
        }
    }

    private void handleTCPConnectBackRedirectVMsg(TCPConnectBackRedirectVMsg msg, Host sourceHost) {
        final DestAddress address = msg.getAddress();
        Runnable connectBackRunner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Connection connection = null;
                try {
                    DefaultDestAddress connectBackAddress = new DefaultDestAddress(address.getHostName(), address.getPort());
                    connection = ConnectionFactory.createConnection(connectBackAddress, 2000, MessageDispatcher.this.servent.getBandwidthService().getNetworkBandwidthController());
                    connection.write(ByteBuffer.wrap(StringUtils.getBytesInUsAscii("\n\n")));
                    connection.flush();
                }
                catch (IOException iOException) {
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        };
        Environment.getInstance().executeOnThreadPool(connectBackRunner, "TCPConnectBackJob");
    }

    private void handlePushProxyRequestVMsg(PushProxyRequestVMsg pprvmsg, Host sourceHost) {
        if (!sourceHost.isUltrapeerLeafConnection()) {
            return;
        }
        DestAddress localAddress = this.servent.getLocalAddress();
        if (localAddress.getIpAddress() == null) {
            logger.warn("Local address has no IP to use for PPAck.");
            return;
        }
        GUID requestGUID = pprvmsg.getHeader().getMsgID();
        PushProxyAcknowledgementVMsg ppavmsg = new PushProxyAcknowledgementVMsg(localAddress, requestGUID);
        sourceHost.queueMessageToSend(ppavmsg);
        this.msgRouting.addToPushRoutingTable(requestGUID, sourceHost);
    }

    private void handlePushProxyAcknowledgementVMsg(PushProxyAcknowledgementVMsg ppavmsg, Host sourceHost) {
        if (this.servent.getServentGuid().equals(ppavmsg.getHeader().getMsgID())) {
            sourceHost.setPushProxyAddress(ppavmsg.getHostAddress());
        }
    }

    private void handleHopsFlowVMsg(HopsFlowVMsg hopsFlowVMsg, Host sourceHost) {
        byte hopsFlowValue = hopsFlowVMsg.getHopsValue();
        sourceHost.setHopsFlowLimit(hopsFlowValue);
    }

    public void handlePushRequest(PushRequestMsg msg, Host sourceHost) {
        this.pushMsgInCounter.increment(1);
        AccessType access = this.securityService.controlHostAddressAccess(msg.getRequestAddress());
        if (access == AccessType.ACCESS_STRONGLY_DENIED) {
            this.dropMessage(msg, "IP access strongly denied.", sourceHost);
            return;
        }
        if (this.servent.getServentGuid().equals(msg.getClientGUID())) {
            if (access == AccessType.ACCESS_GRANTED) {
                new PushWorker(msg, this.servent.getUploadService());
            }
            return;
        }
        if (msg.getHeader().getTTL() > 0) {
            this.servent.getMessageService().routePushMessage(msg);
        }
    }

    private void dropMessage(Message msg, String reason, Host sourceHost) {
        logger.info("Dropping message: {} from: {}", (Object)reason, (Object)sourceHost);
        if (logger.isDebugEnabled()) {
            logger.debug("Header: [" + msg.getHeader().toString() + "] - Message: [" + msg.toString() + "].");
        }
        if (sourceHost != null) {
            sourceHost.incReceivedDropCount();
        }
        this.dropedMsgInCounter.increment(1);
    }

    public void dropMessage(MsgHeader header, byte[] body, String reason, Host sourceHost) {
        logger.info("Dropping message: {} from: {}", (Object)reason, (Object)sourceHost);
        if (logger.isDebugEnabled()) {
            logger.debug("Header: [" + header.toString() + "] - Body: [" + HexConverter.toHexString(body, 0, header.getDataLength()) + "].");
        }
        if (sourceHost != null) {
            sourceHost.incReceivedDropCount();
        }
        this.dropedMsgInCounter.increment(1);
    }
}

